/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.codeguruprofiler.model;

import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkBytes;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.PayloadTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The structure representing the getProfileResponse.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetProfileResponse extends CodeGuruProfilerResponse implements
        ToCopyableBuilder<GetProfileResponse.Builder, GetProfileResponse> {
    private static final SdkField<String> CONTENT_ENCODING_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("contentEncoding").getter(getter(GetProfileResponse::contentEncoding))
            .setter(setter(Builder::contentEncoding))
            .traits(LocationTrait.builder().location(MarshallLocation.HEADER).locationName("Content-Encoding").build()).build();

    private static final SdkField<String> CONTENT_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("contentType").getter(getter(GetProfileResponse::contentType)).setter(setter(Builder::contentType))
            .traits(LocationTrait.builder().location(MarshallLocation.HEADER).locationName("Content-Type").build()).build();

    private static final SdkField<SdkBytes> PROFILE_FIELD = SdkField
            .<SdkBytes> builder(MarshallingType.SDK_BYTES)
            .memberName("profile")
            .getter(getter(GetProfileResponse::profile))
            .setter(setter(Builder::profile))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("profile").build(),
                    PayloadTrait.create()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONTENT_ENCODING_FIELD,
            CONTENT_TYPE_FIELD, PROFILE_FIELD));

    private final String contentEncoding;

    private final String contentType;

    private final SdkBytes profile;

    private GetProfileResponse(BuilderImpl builder) {
        super(builder);
        this.contentEncoding = builder.contentEncoding;
        this.contentType = builder.contentType;
        this.profile = builder.profile;
    }

    /**
     * <p>
     * The content encoding of the profile.
     * </p>
     * 
     * @return The content encoding of the profile.
     */
    public final String contentEncoding() {
        return contentEncoding;
    }

    /**
     * <p>
     * The content type of the profile in the payload. It is either <code>application/json</code> or the default
     * <code>application/x-amzn-ion</code>.
     * </p>
     * 
     * @return The content type of the profile in the payload. It is either <code>application/json</code> or the default
     *         <code>application/x-amzn-ion</code>.
     */
    public final String contentType() {
        return contentType;
    }

    /**
     * <p>
     * Information about the profile.
     * </p>
     * 
     * @return Information about the profile.
     */
    public final SdkBytes profile() {
        return profile;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(contentEncoding());
        hashCode = 31 * hashCode + Objects.hashCode(contentType());
        hashCode = 31 * hashCode + Objects.hashCode(profile());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetProfileResponse)) {
            return false;
        }
        GetProfileResponse other = (GetProfileResponse) obj;
        return Objects.equals(contentEncoding(), other.contentEncoding()) && Objects.equals(contentType(), other.contentType())
                && Objects.equals(profile(), other.profile());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetProfileResponse").add("ContentEncoding", contentEncoding()).add("ContentType", contentType())
                .add("Profile", profile()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "contentEncoding":
            return Optional.ofNullable(clazz.cast(contentEncoding()));
        case "contentType":
            return Optional.ofNullable(clazz.cast(contentType()));
        case "profile":
            return Optional.ofNullable(clazz.cast(profile()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetProfileResponse, T> g) {
        return obj -> g.apply((GetProfileResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CodeGuruProfilerResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetProfileResponse> {
        /**
         * <p>
         * The content encoding of the profile.
         * </p>
         * 
         * @param contentEncoding
         *        The content encoding of the profile.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder contentEncoding(String contentEncoding);

        /**
         * <p>
         * The content type of the profile in the payload. It is either <code>application/json</code> or the default
         * <code>application/x-amzn-ion</code>.
         * </p>
         * 
         * @param contentType
         *        The content type of the profile in the payload. It is either <code>application/json</code> or the
         *        default <code>application/x-amzn-ion</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder contentType(String contentType);

        /**
         * <p>
         * Information about the profile.
         * </p>
         * 
         * @param profile
         *        Information about the profile.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder profile(SdkBytes profile);
    }

    static final class BuilderImpl extends CodeGuruProfilerResponse.BuilderImpl implements Builder {
        private String contentEncoding;

        private String contentType;

        private SdkBytes profile;

        private BuilderImpl() {
        }

        private BuilderImpl(GetProfileResponse model) {
            super(model);
            contentEncoding(model.contentEncoding);
            contentType(model.contentType);
            profile(model.profile);
        }

        public final String getContentEncoding() {
            return contentEncoding;
        }

        public final void setContentEncoding(String contentEncoding) {
            this.contentEncoding = contentEncoding;
        }

        @Override
        public final Builder contentEncoding(String contentEncoding) {
            this.contentEncoding = contentEncoding;
            return this;
        }

        public final String getContentType() {
            return contentType;
        }

        public final void setContentType(String contentType) {
            this.contentType = contentType;
        }

        @Override
        public final Builder contentType(String contentType) {
            this.contentType = contentType;
            return this;
        }

        public final ByteBuffer getProfile() {
            return profile == null ? null : profile.asByteBuffer();
        }

        public final void setProfile(ByteBuffer profile) {
            profile(profile == null ? null : SdkBytes.fromByteBuffer(profile));
        }

        @Override
        public final Builder profile(SdkBytes profile) {
            this.profile = profile;
            return this;
        }

        @Override
        public GetProfileResponse build() {
            return new GetProfileResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
