/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.codeguruprofiler.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * 
 * <pre>
 * <code> The structure representing the &lt;code&gt;removePermissionRequest&lt;/code&gt;.&lt;/p&gt; </code>
 * </pre>
 */
@Generated("software.amazon.awssdk:codegen")
public final class RemovePermissionRequest extends CodeGuruProfilerRequest implements
        ToCopyableBuilder<RemovePermissionRequest.Builder, RemovePermissionRequest> {
    private static final SdkField<String> ACTION_GROUP_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("actionGroup").getter(getter(RemovePermissionRequest::actionGroupAsString))
            .setter(setter(Builder::actionGroup))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("actionGroup").build()).build();

    private static final SdkField<String> PROFILING_GROUP_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("profilingGroupName").getter(getter(RemovePermissionRequest::profilingGroupName))
            .setter(setter(Builder::profilingGroupName))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("profilingGroupName").build()).build();

    private static final SdkField<String> REVISION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("revisionId").getter(getter(RemovePermissionRequest::revisionId)).setter(setter(Builder::revisionId))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("revisionId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACTION_GROUP_FIELD,
            PROFILING_GROUP_NAME_FIELD, REVISION_ID_FIELD));

    private final String actionGroup;

    private final String profilingGroupName;

    private final String revisionId;

    private RemovePermissionRequest(BuilderImpl builder) {
        super(builder);
        this.actionGroup = builder.actionGroup;
        this.profilingGroupName = builder.profilingGroupName;
        this.revisionId = builder.revisionId;
    }

    /**
     * <p>
     * Specifies an action group that contains the permissions to remove from a profiling group's resource-based policy.
     * One action group is supported, <code>agentPermissions</code>, which grants <code>ConfigureAgent</code> and
     * <code>PostAgentProfile</code> permissions.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #actionGroup} will
     * return {@link ActionGroup#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #actionGroupAsString}.
     * </p>
     * 
     * @return Specifies an action group that contains the permissions to remove from a profiling group's resource-based
     *         policy. One action group is supported, <code>agentPermissions</code>, which grants
     *         <code>ConfigureAgent</code> and <code>PostAgentProfile</code> permissions.
     * @see ActionGroup
     */
    public final ActionGroup actionGroup() {
        return ActionGroup.fromValue(actionGroup);
    }

    /**
     * <p>
     * Specifies an action group that contains the permissions to remove from a profiling group's resource-based policy.
     * One action group is supported, <code>agentPermissions</code>, which grants <code>ConfigureAgent</code> and
     * <code>PostAgentProfile</code> permissions.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #actionGroup} will
     * return {@link ActionGroup#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #actionGroupAsString}.
     * </p>
     * 
     * @return Specifies an action group that contains the permissions to remove from a profiling group's resource-based
     *         policy. One action group is supported, <code>agentPermissions</code>, which grants
     *         <code>ConfigureAgent</code> and <code>PostAgentProfile</code> permissions.
     * @see ActionGroup
     */
    public final String actionGroupAsString() {
        return actionGroup;
    }

    /**
     * <p>
     * The name of the profiling group.
     * </p>
     * 
     * @return The name of the profiling group.
     */
    public final String profilingGroupName() {
        return profilingGroupName;
    }

    /**
     * <p>
     * A universally unique identifier (UUID) for the revision of the resource-based policy from which you want to
     * remove permissions.
     * </p>
     * 
     * @return A universally unique identifier (UUID) for the revision of the resource-based policy from which you want
     *         to remove permissions.
     */
    public final String revisionId() {
        return revisionId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(actionGroupAsString());
        hashCode = 31 * hashCode + Objects.hashCode(profilingGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(revisionId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RemovePermissionRequest)) {
            return false;
        }
        RemovePermissionRequest other = (RemovePermissionRequest) obj;
        return Objects.equals(actionGroupAsString(), other.actionGroupAsString())
                && Objects.equals(profilingGroupName(), other.profilingGroupName())
                && Objects.equals(revisionId(), other.revisionId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RemovePermissionRequest").add("ActionGroup", actionGroupAsString())
                .add("ProfilingGroupName", profilingGroupName()).add("RevisionId", revisionId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "actionGroup":
            return Optional.ofNullable(clazz.cast(actionGroupAsString()));
        case "profilingGroupName":
            return Optional.ofNullable(clazz.cast(profilingGroupName()));
        case "revisionId":
            return Optional.ofNullable(clazz.cast(revisionId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RemovePermissionRequest, T> g) {
        return obj -> g.apply((RemovePermissionRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CodeGuruProfilerRequest.Builder, SdkPojo, CopyableBuilder<Builder, RemovePermissionRequest> {
        /**
         * <p>
         * Specifies an action group that contains the permissions to remove from a profiling group's resource-based
         * policy. One action group is supported, <code>agentPermissions</code>, which grants
         * <code>ConfigureAgent</code> and <code>PostAgentProfile</code> permissions.
         * </p>
         * 
         * @param actionGroup
         *        Specifies an action group that contains the permissions to remove from a profiling group's
         *        resource-based policy. One action group is supported, <code>agentPermissions</code>, which grants
         *        <code>ConfigureAgent</code> and <code>PostAgentProfile</code> permissions.
         * @see ActionGroup
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ActionGroup
         */
        Builder actionGroup(String actionGroup);

        /**
         * <p>
         * Specifies an action group that contains the permissions to remove from a profiling group's resource-based
         * policy. One action group is supported, <code>agentPermissions</code>, which grants
         * <code>ConfigureAgent</code> and <code>PostAgentProfile</code> permissions.
         * </p>
         * 
         * @param actionGroup
         *        Specifies an action group that contains the permissions to remove from a profiling group's
         *        resource-based policy. One action group is supported, <code>agentPermissions</code>, which grants
         *        <code>ConfigureAgent</code> and <code>PostAgentProfile</code> permissions.
         * @see ActionGroup
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ActionGroup
         */
        Builder actionGroup(ActionGroup actionGroup);

        /**
         * <p>
         * The name of the profiling group.
         * </p>
         * 
         * @param profilingGroupName
         *        The name of the profiling group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder profilingGroupName(String profilingGroupName);

        /**
         * <p>
         * A universally unique identifier (UUID) for the revision of the resource-based policy from which you want to
         * remove permissions.
         * </p>
         * 
         * @param revisionId
         *        A universally unique identifier (UUID) for the revision of the resource-based policy from which you
         *        want to remove permissions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder revisionId(String revisionId);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends CodeGuruProfilerRequest.BuilderImpl implements Builder {
        private String actionGroup;

        private String profilingGroupName;

        private String revisionId;

        private BuilderImpl() {
        }

        private BuilderImpl(RemovePermissionRequest model) {
            super(model);
            actionGroup(model.actionGroup);
            profilingGroupName(model.profilingGroupName);
            revisionId(model.revisionId);
        }

        public final String getActionGroup() {
            return actionGroup;
        }

        @Override
        public final Builder actionGroup(String actionGroup) {
            this.actionGroup = actionGroup;
            return this;
        }

        @Override
        public final Builder actionGroup(ActionGroup actionGroup) {
            this.actionGroup(actionGroup == null ? null : actionGroup.toString());
            return this;
        }

        public final void setActionGroup(String actionGroup) {
            this.actionGroup = actionGroup;
        }

        public final String getProfilingGroupName() {
            return profilingGroupName;
        }

        @Override
        public final Builder profilingGroupName(String profilingGroupName) {
            this.profilingGroupName = profilingGroupName;
            return this;
        }

        public final void setProfilingGroupName(String profilingGroupName) {
            this.profilingGroupName = profilingGroupName;
        }

        public final String getRevisionId() {
            return revisionId;
        }

        @Override
        public final Builder revisionId(String revisionId) {
            this.revisionId = revisionId;
            return this;
        }

        public final void setRevisionId(String revisionId) {
            this.revisionId = revisionId;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public RemovePermissionRequest build() {
            return new RemovePermissionRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
