/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.codeguruprofiler.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The part of a profile that contains a recommendation found during analysis.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Match implements SdkPojo, Serializable, ToCopyableBuilder<Match.Builder, Match> {
    private static final SdkField<String> FRAME_ADDRESS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("frameAddress").getter(getter(Match::frameAddress)).setter(setter(Builder::frameAddress))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("frameAddress").build()).build();

    private static final SdkField<Integer> TARGET_FRAMES_INDEX_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("targetFramesIndex").getter(getter(Match::targetFramesIndex)).setter(setter(Builder::targetFramesIndex))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("targetFramesIndex").build()).build();

    private static final SdkField<Double> THRESHOLD_BREACH_VALUE_FIELD = SdkField.<Double> builder(MarshallingType.DOUBLE)
            .memberName("thresholdBreachValue").getter(getter(Match::thresholdBreachValue))
            .setter(setter(Builder::thresholdBreachValue))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("thresholdBreachValue").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FRAME_ADDRESS_FIELD,
            TARGET_FRAMES_INDEX_FIELD, THRESHOLD_BREACH_VALUE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String frameAddress;

    private final Integer targetFramesIndex;

    private final Double thresholdBreachValue;

    private Match(BuilderImpl builder) {
        this.frameAddress = builder.frameAddress;
        this.targetFramesIndex = builder.targetFramesIndex;
        this.thresholdBreachValue = builder.thresholdBreachValue;
    }

    /**
     * <p>
     * The location in the profiling graph that contains a recommendation found during analysis.
     * </p>
     * 
     * @return The location in the profiling graph that contains a recommendation found during analysis.
     */
    public final String frameAddress() {
        return frameAddress;
    }

    /**
     * <p>
     * The target frame that triggered a match.
     * </p>
     * 
     * @return The target frame that triggered a match.
     */
    public final Integer targetFramesIndex() {
        return targetFramesIndex;
    }

    /**
     * <p>
     * The value in the profile data that exceeded the recommendation threshold.
     * </p>
     * 
     * @return The value in the profile data that exceeded the recommendation threshold.
     */
    public final Double thresholdBreachValue() {
        return thresholdBreachValue;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(frameAddress());
        hashCode = 31 * hashCode + Objects.hashCode(targetFramesIndex());
        hashCode = 31 * hashCode + Objects.hashCode(thresholdBreachValue());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Match)) {
            return false;
        }
        Match other = (Match) obj;
        return Objects.equals(frameAddress(), other.frameAddress())
                && Objects.equals(targetFramesIndex(), other.targetFramesIndex())
                && Objects.equals(thresholdBreachValue(), other.thresholdBreachValue());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Match").add("FrameAddress", frameAddress()).add("TargetFramesIndex", targetFramesIndex())
                .add("ThresholdBreachValue", thresholdBreachValue()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "frameAddress":
            return Optional.ofNullable(clazz.cast(frameAddress()));
        case "targetFramesIndex":
            return Optional.ofNullable(clazz.cast(targetFramesIndex()));
        case "thresholdBreachValue":
            return Optional.ofNullable(clazz.cast(thresholdBreachValue()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Match, T> g) {
        return obj -> g.apply((Match) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Match> {
        /**
         * <p>
         * The location in the profiling graph that contains a recommendation found during analysis.
         * </p>
         * 
         * @param frameAddress
         *        The location in the profiling graph that contains a recommendation found during analysis.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder frameAddress(String frameAddress);

        /**
         * <p>
         * The target frame that triggered a match.
         * </p>
         * 
         * @param targetFramesIndex
         *        The target frame that triggered a match.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targetFramesIndex(Integer targetFramesIndex);

        /**
         * <p>
         * The value in the profile data that exceeded the recommendation threshold.
         * </p>
         * 
         * @param thresholdBreachValue
         *        The value in the profile data that exceeded the recommendation threshold.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder thresholdBreachValue(Double thresholdBreachValue);
    }

    static final class BuilderImpl implements Builder {
        private String frameAddress;

        private Integer targetFramesIndex;

        private Double thresholdBreachValue;

        private BuilderImpl() {
        }

        private BuilderImpl(Match model) {
            frameAddress(model.frameAddress);
            targetFramesIndex(model.targetFramesIndex);
            thresholdBreachValue(model.thresholdBreachValue);
        }

        public final String getFrameAddress() {
            return frameAddress;
        }

        @Override
        public final Builder frameAddress(String frameAddress) {
            this.frameAddress = frameAddress;
            return this;
        }

        public final void setFrameAddress(String frameAddress) {
            this.frameAddress = frameAddress;
        }

        public final Integer getTargetFramesIndex() {
            return targetFramesIndex;
        }

        @Override
        public final Builder targetFramesIndex(Integer targetFramesIndex) {
            this.targetFramesIndex = targetFramesIndex;
            return this;
        }

        public final void setTargetFramesIndex(Integer targetFramesIndex) {
            this.targetFramesIndex = targetFramesIndex;
        }

        public final Double getThresholdBreachValue() {
            return thresholdBreachValue;
        }

        @Override
        public final Builder thresholdBreachValue(Double thresholdBreachValue) {
            this.thresholdBreachValue = thresholdBreachValue;
            return this;
        }

        public final void setThresholdBreachValue(Double thresholdBreachValue) {
            this.thresholdBreachValue = thresholdBreachValue;
        }

        @Override
        public Match build() {
            return new Match(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
