/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.codeguruprofiler.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The structure representing the ListFindingsReportsResponse.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListFindingsReportsResponse extends CodeGuruProfilerResponse implements
        ToCopyableBuilder<ListFindingsReportsResponse.Builder, ListFindingsReportsResponse> {
    private static final SdkField<List<FindingsReportSummary>> FINDINGS_REPORT_SUMMARIES_FIELD = SdkField
            .<List<FindingsReportSummary>> builder(MarshallingType.LIST)
            .memberName("findingsReportSummaries")
            .getter(getter(ListFindingsReportsResponse::findingsReportSummaries))
            .setter(setter(Builder::findingsReportSummaries))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("findingsReportSummaries").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<FindingsReportSummary> builder(MarshallingType.SDK_POJO)
                                            .constructor(FindingsReportSummary::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(ListFindingsReportsResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            FINDINGS_REPORT_SUMMARIES_FIELD, NEXT_TOKEN_FIELD));

    private final List<FindingsReportSummary> findingsReportSummaries;

    private final String nextToken;

    private ListFindingsReportsResponse(BuilderImpl builder) {
        super(builder);
        this.findingsReportSummaries = builder.findingsReportSummaries;
        this.nextToken = builder.nextToken;
    }

    /**
     * Returns true if the FindingsReportSummaries property was specified by the sender (it may be empty), or false if
     * the sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public final boolean hasFindingsReportSummaries() {
        return findingsReportSummaries != null && !(findingsReportSummaries instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The list of analysis results summaries.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasFindingsReportSummaries()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The list of analysis results summaries.
     */
    public final List<FindingsReportSummary> findingsReportSummaries() {
        return findingsReportSummaries;
    }

    /**
     * <p>
     * The <code>nextToken</code> value to include in a future <code>ListFindingsReports</code> request. When the
     * results of a <code>ListFindingsReports</code> request exceed <code>maxResults</code>, this value can be used to
     * retrieve the next page of results. This value is <code>null</code> when there are no more results to return.
     * </p>
     * 
     * @return The <code>nextToken</code> value to include in a future <code>ListFindingsReports</code> request. When
     *         the results of a <code>ListFindingsReports</code> request exceed <code>maxResults</code>, this value can
     *         be used to retrieve the next page of results. This value is <code>null</code> when there are no more
     *         results to return.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasFindingsReportSummaries() ? findingsReportSummaries() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListFindingsReportsResponse)) {
            return false;
        }
        ListFindingsReportsResponse other = (ListFindingsReportsResponse) obj;
        return hasFindingsReportSummaries() == other.hasFindingsReportSummaries()
                && Objects.equals(findingsReportSummaries(), other.findingsReportSummaries())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListFindingsReportsResponse")
                .add("FindingsReportSummaries", hasFindingsReportSummaries() ? findingsReportSummaries() : null)
                .add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "findingsReportSummaries":
            return Optional.ofNullable(clazz.cast(findingsReportSummaries()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListFindingsReportsResponse, T> g) {
        return obj -> g.apply((ListFindingsReportsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CodeGuruProfilerResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, ListFindingsReportsResponse> {
        /**
         * <p>
         * The list of analysis results summaries.
         * </p>
         * 
         * @param findingsReportSummaries
         *        The list of analysis results summaries.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder findingsReportSummaries(Collection<FindingsReportSummary> findingsReportSummaries);

        /**
         * <p>
         * The list of analysis results summaries.
         * </p>
         * 
         * @param findingsReportSummaries
         *        The list of analysis results summaries.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder findingsReportSummaries(FindingsReportSummary... findingsReportSummaries);

        /**
         * <p>
         * The list of analysis results summaries.
         * </p>
         * This is a convenience that creates an instance of the {@link List<FindingsReportSummary>.Builder} avoiding
         * the need to create one manually via {@link List<FindingsReportSummary>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<FindingsReportSummary>.Builder#build()} is called
         * immediately and its result is passed to {@link #findingsReportSummaries(List<FindingsReportSummary>)}.
         * 
         * @param findingsReportSummaries
         *        a consumer that will call methods on {@link List<FindingsReportSummary>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #findingsReportSummaries(List<FindingsReportSummary>)
         */
        Builder findingsReportSummaries(Consumer<FindingsReportSummary.Builder>... findingsReportSummaries);

        /**
         * <p>
         * The <code>nextToken</code> value to include in a future <code>ListFindingsReports</code> request. When the
         * results of a <code>ListFindingsReports</code> request exceed <code>maxResults</code>, this value can be used
         * to retrieve the next page of results. This value is <code>null</code> when there are no more results to
         * return.
         * </p>
         * 
         * @param nextToken
         *        The <code>nextToken</code> value to include in a future <code>ListFindingsReports</code> request. When
         *        the results of a <code>ListFindingsReports</code> request exceed <code>maxResults</code>, this value
         *        can be used to retrieve the next page of results. This value is <code>null</code> when there are no
         *        more results to return.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends CodeGuruProfilerResponse.BuilderImpl implements Builder {
        private List<FindingsReportSummary> findingsReportSummaries = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListFindingsReportsResponse model) {
            super(model);
            findingsReportSummaries(model.findingsReportSummaries);
            nextToken(model.nextToken);
        }

        public final Collection<FindingsReportSummary.Builder> getFindingsReportSummaries() {
            if (findingsReportSummaries instanceof SdkAutoConstructList) {
                return null;
            }
            return findingsReportSummaries != null ? findingsReportSummaries.stream().map(FindingsReportSummary::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder findingsReportSummaries(Collection<FindingsReportSummary> findingsReportSummaries) {
            this.findingsReportSummaries = FindingsReportSummariesCopier.copy(findingsReportSummaries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder findingsReportSummaries(FindingsReportSummary... findingsReportSummaries) {
            findingsReportSummaries(Arrays.asList(findingsReportSummaries));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder findingsReportSummaries(Consumer<FindingsReportSummary.Builder>... findingsReportSummaries) {
            findingsReportSummaries(Stream.of(findingsReportSummaries)
                    .map(c -> FindingsReportSummary.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setFindingsReportSummaries(Collection<FindingsReportSummary.BuilderImpl> findingsReportSummaries) {
            this.findingsReportSummaries = FindingsReportSummariesCopier.copyFromBuilder(findingsReportSummaries);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListFindingsReportsResponse build() {
            return new ListFindingsReportsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
