/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codeguruprofiler.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.codeguruprofiler.model.MetricType;
import software.amazon.awssdk.services.codeguruprofiler.model.ThreadStatesCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class FrameMetric
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, FrameMetric> {
    private static final SdkField<String> FRAME_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("frameName").getter(FrameMetric.getter(FrameMetric::frameName)).setter(FrameMetric.setter(Builder::frameName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("frameName").build()}).build();
    private static final SdkField<List<String>> THREAD_STATES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("threadStates").getter(FrameMetric.getter(FrameMetric::threadStates)).setter(FrameMetric.setter(Builder::threadStates)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("threadStates").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("type").getter(FrameMetric.getter(FrameMetric::typeAsString)).setter(FrameMetric.setter(Builder::type)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("type").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FRAME_NAME_FIELD, THREAD_STATES_FIELD, TYPE_FIELD));
    private static final long serialVersionUID = 1L;
    private final String frameName;
    private final List<String> threadStates;
    private final String type;

    private FrameMetric(BuilderImpl builder) {
        this.frameName = builder.frameName;
        this.threadStates = builder.threadStates;
        this.type = builder.type;
    }

    public String frameName() {
        return this.frameName;
    }

    public boolean hasThreadStates() {
        return this.threadStates != null && !(this.threadStates instanceof SdkAutoConstructList);
    }

    public List<String> threadStates() {
        return this.threadStates;
    }

    public MetricType type() {
        return MetricType.fromValue(this.type);
    }

    public String typeAsString() {
        return this.type;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.frameName());
        hashCode = 31 * hashCode + Objects.hashCode(this.threadStates());
        hashCode = 31 * hashCode + Objects.hashCode(this.typeAsString());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FrameMetric)) {
            return false;
        }
        FrameMetric other = (FrameMetric)obj;
        return Objects.equals(this.frameName(), other.frameName()) && Objects.equals(this.threadStates(), other.threadStates()) && Objects.equals(this.typeAsString(), other.typeAsString());
    }

    public String toString() {
        return ToString.builder((String)"FrameMetric").add("FrameName", (Object)this.frameName()).add("ThreadStates", this.threadStates()).add("Type", (Object)this.typeAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "frameName": {
                return Optional.ofNullable(clazz.cast(this.frameName()));
            }
            case "threadStates": {
                return Optional.ofNullable(clazz.cast(this.threadStates()));
            }
            case "type": {
                return Optional.ofNullable(clazz.cast(this.typeAsString()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<FrameMetric, T> g) {
        return obj -> g.apply((FrameMetric)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String frameName;
        private List<String> threadStates = DefaultSdkAutoConstructList.getInstance();
        private String type;

        private BuilderImpl() {
        }

        private BuilderImpl(FrameMetric model) {
            this.frameName(model.frameName);
            this.threadStates(model.threadStates);
            this.type(model.type);
        }

        public final String getFrameName() {
            return this.frameName;
        }

        @Override
        public final Builder frameName(String frameName) {
            this.frameName = frameName;
            return this;
        }

        public final void setFrameName(String frameName) {
            this.frameName = frameName;
        }

        public final Collection<String> getThreadStates() {
            return this.threadStates;
        }

        @Override
        public final Builder threadStates(Collection<String> threadStates) {
            this.threadStates = ThreadStatesCopier.copy(threadStates);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder threadStates(String ... threadStates) {
            this.threadStates(Arrays.asList(threadStates));
            return this;
        }

        public final void setThreadStates(Collection<String> threadStates) {
            this.threadStates = ThreadStatesCopier.copy(threadStates);
        }

        public final String getType() {
            return this.type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(MetricType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final void setType(String type) {
            this.type = type;
        }

        public FrameMetric build() {
            return new FrameMetric(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, FrameMetric> {
        public Builder frameName(String var1);

        public Builder threadStates(Collection<String> var1);

        public Builder threadStates(String ... var1);

        public Builder type(String var1);

        public Builder type(MetricType var1);
    }
}

