/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codeguruprofiler.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.codeguruprofiler.model.CodeGuruProfilerResponse;
import software.amazon.awssdk.services.codeguruprofiler.model.FindingsReportSummariesCopier;
import software.amazon.awssdk.services.codeguruprofiler.model.FindingsReportSummary;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetFindingsReportAccountSummaryResponse
extends CodeGuruProfilerResponse
implements ToCopyableBuilder<Builder, GetFindingsReportAccountSummaryResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(GetFindingsReportAccountSummaryResponse.getter(GetFindingsReportAccountSummaryResponse::nextToken)).setter(GetFindingsReportAccountSummaryResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final SdkField<List<FindingsReportSummary>> REPORT_SUMMARIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(GetFindingsReportAccountSummaryResponse.getter(GetFindingsReportAccountSummaryResponse::reportSummaries)).setter(GetFindingsReportAccountSummaryResponse.setter(Builder::reportSummaries)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("reportSummaries").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(FindingsReportSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD, REPORT_SUMMARIES_FIELD));
    private final String nextToken;
    private final List<FindingsReportSummary> reportSummaries;

    private GetFindingsReportAccountSummaryResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.reportSummaries = builder.reportSummaries;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public boolean hasReportSummaries() {
        return this.reportSummaries != null && !(this.reportSummaries instanceof SdkAutoConstructList);
    }

    public List<FindingsReportSummary> reportSummaries() {
        return this.reportSummaries;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.reportSummaries());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetFindingsReportAccountSummaryResponse)) {
            return false;
        }
        GetFindingsReportAccountSummaryResponse other = (GetFindingsReportAccountSummaryResponse)((Object)obj);
        return Objects.equals(this.nextToken(), other.nextToken()) && Objects.equals(this.reportSummaries(), other.reportSummaries());
    }

    public String toString() {
        return ToString.builder((String)"GetFindingsReportAccountSummaryResponse").add("NextToken", (Object)this.nextToken()).add("ReportSummaries", this.reportSummaries()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "reportSummaries": {
                return Optional.ofNullable(clazz.cast(this.reportSummaries()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetFindingsReportAccountSummaryResponse, T> g) {
        return obj -> g.apply((GetFindingsReportAccountSummaryResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CodeGuruProfilerResponse.BuilderImpl
    implements Builder {
        private String nextToken;
        private List<FindingsReportSummary> reportSummaries = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GetFindingsReportAccountSummaryResponse model) {
            super(model);
            this.nextToken(model.nextToken);
            this.reportSummaries(model.reportSummaries);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public final Collection<FindingsReportSummary.Builder> getReportSummaries() {
            return this.reportSummaries != null ? (Collection)this.reportSummaries.stream().map(FindingsReportSummary::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder reportSummaries(Collection<FindingsReportSummary> reportSummaries) {
            this.reportSummaries = FindingsReportSummariesCopier.copy(reportSummaries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder reportSummaries(FindingsReportSummary ... reportSummaries) {
            this.reportSummaries(Arrays.asList(reportSummaries));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder reportSummaries(Consumer<FindingsReportSummary.Builder> ... reportSummaries) {
            this.reportSummaries(Stream.of(reportSummaries).map(c -> (FindingsReportSummary)((FindingsReportSummary.Builder)FindingsReportSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setReportSummaries(Collection<FindingsReportSummary.BuilderImpl> reportSummaries) {
            this.reportSummaries = FindingsReportSummariesCopier.copyFromBuilder(reportSummaries);
        }

        @Override
        public GetFindingsReportAccountSummaryResponse build() {
            return new GetFindingsReportAccountSummaryResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends CodeGuruProfilerResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetFindingsReportAccountSummaryResponse> {
        public Builder nextToken(String var1);

        public Builder reportSummaries(Collection<FindingsReportSummary> var1);

        public Builder reportSummaries(FindingsReportSummary ... var1);

        public Builder reportSummaries(Consumer<FindingsReportSummary.Builder> ... var1);
    }
}

