/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.codeguruprofiler.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about the profiling status.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ProfilingStatus implements SdkPojo, Serializable, ToCopyableBuilder<ProfilingStatus.Builder, ProfilingStatus> {
    private static final SdkField<Instant> LATEST_AGENT_ORCHESTRATED_AT_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .getter(getter(ProfilingStatus::latestAgentOrchestratedAt))
            .setter(setter(Builder::latestAgentOrchestratedAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("latestAgentOrchestratedAt").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<Instant> LATEST_AGENT_PROFILE_REPORTED_AT_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .getter(getter(ProfilingStatus::latestAgentProfileReportedAt))
            .setter(setter(Builder::latestAgentProfileReportedAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("latestAgentProfileReportedAt")
                    .build(), TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<AggregatedProfileTime> LATEST_AGGREGATED_PROFILE_FIELD = SdkField
            .<AggregatedProfileTime> builder(MarshallingType.SDK_POJO).getter(getter(ProfilingStatus::latestAggregatedProfile))
            .setter(setter(Builder::latestAggregatedProfile)).constructor(AggregatedProfileTime::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("latestAggregatedProfile").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            LATEST_AGENT_ORCHESTRATED_AT_FIELD, LATEST_AGENT_PROFILE_REPORTED_AT_FIELD, LATEST_AGGREGATED_PROFILE_FIELD));

    private static final long serialVersionUID = 1L;

    private final Instant latestAgentOrchestratedAt;

    private final Instant latestAgentProfileReportedAt;

    private final AggregatedProfileTime latestAggregatedProfile;

    private ProfilingStatus(BuilderImpl builder) {
        this.latestAgentOrchestratedAt = builder.latestAgentOrchestratedAt;
        this.latestAgentProfileReportedAt = builder.latestAgentProfileReportedAt;
        this.latestAggregatedProfile = builder.latestAggregatedProfile;
    }

    /**
     * <p>
     * The time, in milliseconds since the epoch, when the latest agent was orchestrated.
     * </p>
     * 
     * @return The time, in milliseconds since the epoch, when the latest agent was orchestrated.
     */
    public Instant latestAgentOrchestratedAt() {
        return latestAgentOrchestratedAt;
    }

    /**
     * <p>
     * The time, in milliseconds since the epoch, when the latest agent was reported..
     * </p>
     * 
     * @return The time, in milliseconds since the epoch, when the latest agent was reported..
     */
    public Instant latestAgentProfileReportedAt() {
        return latestAgentProfileReportedAt;
    }

    /**
     * <p>
     * The latest aggregated profile
     * </p>
     * 
     * @return The latest aggregated profile
     */
    public AggregatedProfileTime latestAggregatedProfile() {
        return latestAggregatedProfile;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(latestAgentOrchestratedAt());
        hashCode = 31 * hashCode + Objects.hashCode(latestAgentProfileReportedAt());
        hashCode = 31 * hashCode + Objects.hashCode(latestAggregatedProfile());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ProfilingStatus)) {
            return false;
        }
        ProfilingStatus other = (ProfilingStatus) obj;
        return Objects.equals(latestAgentOrchestratedAt(), other.latestAgentOrchestratedAt())
                && Objects.equals(latestAgentProfileReportedAt(), other.latestAgentProfileReportedAt())
                && Objects.equals(latestAggregatedProfile(), other.latestAggregatedProfile());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("ProfilingStatus").add("LatestAgentOrchestratedAt", latestAgentOrchestratedAt())
                .add("LatestAgentProfileReportedAt", latestAgentProfileReportedAt())
                .add("LatestAggregatedProfile", latestAggregatedProfile()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "latestAgentOrchestratedAt":
            return Optional.ofNullable(clazz.cast(latestAgentOrchestratedAt()));
        case "latestAgentProfileReportedAt":
            return Optional.ofNullable(clazz.cast(latestAgentProfileReportedAt()));
        case "latestAggregatedProfile":
            return Optional.ofNullable(clazz.cast(latestAggregatedProfile()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ProfilingStatus, T> g) {
        return obj -> g.apply((ProfilingStatus) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ProfilingStatus> {
        /**
         * <p>
         * The time, in milliseconds since the epoch, when the latest agent was orchestrated.
         * </p>
         * 
         * @param latestAgentOrchestratedAt
         *        The time, in milliseconds since the epoch, when the latest agent was orchestrated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder latestAgentOrchestratedAt(Instant latestAgentOrchestratedAt);

        /**
         * <p>
         * The time, in milliseconds since the epoch, when the latest agent was reported..
         * </p>
         * 
         * @param latestAgentProfileReportedAt
         *        The time, in milliseconds since the epoch, when the latest agent was reported..
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder latestAgentProfileReportedAt(Instant latestAgentProfileReportedAt);

        /**
         * <p>
         * The latest aggregated profile
         * </p>
         * 
         * @param latestAggregatedProfile
         *        The latest aggregated profile
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder latestAggregatedProfile(AggregatedProfileTime latestAggregatedProfile);

        /**
         * <p>
         * The latest aggregated profile
         * </p>
         * This is a convenience that creates an instance of the {@link AggregatedProfileTime.Builder} avoiding the need
         * to create one manually via {@link AggregatedProfileTime#builder()}.
         *
         * When the {@link Consumer} completes, {@link AggregatedProfileTime.Builder#build()} is called immediately and
         * its result is passed to {@link #latestAggregatedProfile(AggregatedProfileTime)}.
         * 
         * @param latestAggregatedProfile
         *        a consumer that will call methods on {@link AggregatedProfileTime.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #latestAggregatedProfile(AggregatedProfileTime)
         */
        default Builder latestAggregatedProfile(Consumer<AggregatedProfileTime.Builder> latestAggregatedProfile) {
            return latestAggregatedProfile(AggregatedProfileTime.builder().applyMutation(latestAggregatedProfile).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private Instant latestAgentOrchestratedAt;

        private Instant latestAgentProfileReportedAt;

        private AggregatedProfileTime latestAggregatedProfile;

        private BuilderImpl() {
        }

        private BuilderImpl(ProfilingStatus model) {
            latestAgentOrchestratedAt(model.latestAgentOrchestratedAt);
            latestAgentProfileReportedAt(model.latestAgentProfileReportedAt);
            latestAggregatedProfile(model.latestAggregatedProfile);
        }

        public final Instant getLatestAgentOrchestratedAt() {
            return latestAgentOrchestratedAt;
        }

        @Override
        public final Builder latestAgentOrchestratedAt(Instant latestAgentOrchestratedAt) {
            this.latestAgentOrchestratedAt = latestAgentOrchestratedAt;
            return this;
        }

        public final void setLatestAgentOrchestratedAt(Instant latestAgentOrchestratedAt) {
            this.latestAgentOrchestratedAt = latestAgentOrchestratedAt;
        }

        public final Instant getLatestAgentProfileReportedAt() {
            return latestAgentProfileReportedAt;
        }

        @Override
        public final Builder latestAgentProfileReportedAt(Instant latestAgentProfileReportedAt) {
            this.latestAgentProfileReportedAt = latestAgentProfileReportedAt;
            return this;
        }

        public final void setLatestAgentProfileReportedAt(Instant latestAgentProfileReportedAt) {
            this.latestAgentProfileReportedAt = latestAgentProfileReportedAt;
        }

        public final AggregatedProfileTime.Builder getLatestAggregatedProfile() {
            return latestAggregatedProfile != null ? latestAggregatedProfile.toBuilder() : null;
        }

        @Override
        public final Builder latestAggregatedProfile(AggregatedProfileTime latestAggregatedProfile) {
            this.latestAggregatedProfile = latestAggregatedProfile;
            return this;
        }

        public final void setLatestAggregatedProfile(AggregatedProfileTime.BuilderImpl latestAggregatedProfile) {
            this.latestAggregatedProfile = latestAggregatedProfile != null ? latestAggregatedProfile.build() : null;
        }

        @Override
        public ProfilingStatus build() {
            return new ProfilingStatus(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
