/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.codeguruprofiler.model;

import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkBytes;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.adapter.StandardMemberCopier;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.PayloadTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The structure representing the postAgentProfileRequest.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class PostAgentProfileRequest extends CodeGuruProfilerRequest implements
        ToCopyableBuilder<PostAgentProfileRequest.Builder, PostAgentProfileRequest> {
    private static final SdkField<SdkBytes> AGENT_PROFILE_FIELD = SdkField
            .<SdkBytes> builder(MarshallingType.SDK_BYTES)
            .getter(getter(PostAgentProfileRequest::agentProfile))
            .setter(setter(Builder::agentProfile))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("agentProfile").build(),
                    PayloadTrait.create()).build();

    private static final SdkField<String> CONTENT_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(PostAgentProfileRequest::contentType)).setter(setter(Builder::contentType))
            .traits(LocationTrait.builder().location(MarshallLocation.HEADER).locationName("Content-Type").build()).build();

    private static final SdkField<String> PROFILE_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(PostAgentProfileRequest::profileToken))
            .setter(setter(Builder::profileToken))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("profileToken").build(),
                    DefaultValueTrait.idempotencyToken()).build();

    private static final SdkField<String> PROFILING_GROUP_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(PostAgentProfileRequest::profilingGroupName)).setter(setter(Builder::profilingGroupName))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("profilingGroupName").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AGENT_PROFILE_FIELD,
            CONTENT_TYPE_FIELD, PROFILE_TOKEN_FIELD, PROFILING_GROUP_NAME_FIELD));

    private final SdkBytes agentProfile;

    private final String contentType;

    private final String profileToken;

    private final String profilingGroupName;

    private PostAgentProfileRequest(BuilderImpl builder) {
        super(builder);
        this.agentProfile = builder.agentProfile;
        this.contentType = builder.contentType;
        this.profileToken = builder.profileToken;
        this.profilingGroupName = builder.profilingGroupName;
    }

    /**
     * <p/>
     * 
     * @return
     */
    public SdkBytes agentProfile() {
        return agentProfile;
    }

    /**
     * <p/>
     * 
     * @return
     */
    public String contentType() {
        return contentType;
    }

    /**
     * <p/>
     * 
     * @return
     */
    public String profileToken() {
        return profileToken;
    }

    /**
     * <p/>
     * 
     * @return
     */
    public String profilingGroupName() {
        return profilingGroupName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(agentProfile());
        hashCode = 31 * hashCode + Objects.hashCode(contentType());
        hashCode = 31 * hashCode + Objects.hashCode(profileToken());
        hashCode = 31 * hashCode + Objects.hashCode(profilingGroupName());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PostAgentProfileRequest)) {
            return false;
        }
        PostAgentProfileRequest other = (PostAgentProfileRequest) obj;
        return Objects.equals(agentProfile(), other.agentProfile()) && Objects.equals(contentType(), other.contentType())
                && Objects.equals(profileToken(), other.profileToken())
                && Objects.equals(profilingGroupName(), other.profilingGroupName());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("PostAgentProfileRequest").add("AgentProfile", agentProfile()).add("ContentType", contentType())
                .add("ProfileToken", profileToken()).add("ProfilingGroupName", profilingGroupName()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "agentProfile":
            return Optional.ofNullable(clazz.cast(agentProfile()));
        case "contentType":
            return Optional.ofNullable(clazz.cast(contentType()));
        case "profileToken":
            return Optional.ofNullable(clazz.cast(profileToken()));
        case "profilingGroupName":
            return Optional.ofNullable(clazz.cast(profilingGroupName()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PostAgentProfileRequest, T> g) {
        return obj -> g.apply((PostAgentProfileRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CodeGuruProfilerRequest.Builder, SdkPojo, CopyableBuilder<Builder, PostAgentProfileRequest> {
        /**
         * <p/>
         * 
         * @param agentProfile
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder agentProfile(SdkBytes agentProfile);

        /**
         * <p/>
         * 
         * @param contentType
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder contentType(String contentType);

        /**
         * <p/>
         * 
         * @param profileToken
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder profileToken(String profileToken);

        /**
         * <p/>
         * 
         * @param profilingGroupName
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder profilingGroupName(String profilingGroupName);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends CodeGuruProfilerRequest.BuilderImpl implements Builder {
        private SdkBytes agentProfile;

        private String contentType;

        private String profileToken;

        private String profilingGroupName;

        private BuilderImpl() {
        }

        private BuilderImpl(PostAgentProfileRequest model) {
            super(model);
            agentProfile(model.agentProfile);
            contentType(model.contentType);
            profileToken(model.profileToken);
            profilingGroupName(model.profilingGroupName);
        }

        public final ByteBuffer getAgentProfile() {
            return agentProfile == null ? null : agentProfile.asByteBuffer();
        }

        @Override
        public final Builder agentProfile(SdkBytes agentProfile) {
            this.agentProfile = StandardMemberCopier.copy(agentProfile);
            return this;
        }

        public final void setAgentProfile(ByteBuffer agentProfile) {
            agentProfile(agentProfile == null ? null : SdkBytes.fromByteBuffer(agentProfile));
        }

        public final String getContentType() {
            return contentType;
        }

        @Override
        public final Builder contentType(String contentType) {
            this.contentType = contentType;
            return this;
        }

        public final void setContentType(String contentType) {
            this.contentType = contentType;
        }

        public final String getProfileToken() {
            return profileToken;
        }

        @Override
        public final Builder profileToken(String profileToken) {
            this.profileToken = profileToken;
            return this;
        }

        public final void setProfileToken(String profileToken) {
            this.profileToken = profileToken;
        }

        public final String getProfilingGroupName() {
            return profilingGroupName;
        }

        @Override
        public final Builder profilingGroupName(String profilingGroupName) {
            this.profilingGroupName = profilingGroupName;
            return this;
        }

        public final void setProfilingGroupName(String profilingGroupName) {
            this.profilingGroupName = profilingGroupName;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public PostAgentProfileRequest build() {
            return new PostAgentProfileRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
