/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.codeguruprofiler.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about the time range of the latest available aggregated profile.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AggregatedProfileTime implements SdkPojo, Serializable,
        ToCopyableBuilder<AggregatedProfileTime.Builder, AggregatedProfileTime> {
    private static final SdkField<String> PERIOD_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(AggregatedProfileTime::periodAsString)).setter(setter(Builder::period))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("period").build()).build();

    private static final SdkField<Instant> START_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .getter(getter(AggregatedProfileTime::start))
            .setter(setter(Builder::start))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("start").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PERIOD_FIELD, START_FIELD));

    private static final long serialVersionUID = 1L;

    private final String period;

    private final Instant start;

    private AggregatedProfileTime(BuilderImpl builder) {
        this.period = builder.period;
        this.start = builder.start;
    }

    /**
     * <p>
     * The time period.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #period} will
     * return {@link AggregationPeriod#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #periodAsString}.
     * </p>
     * 
     * @return The time period.
     * @see AggregationPeriod
     */
    public AggregationPeriod period() {
        return AggregationPeriod.fromValue(period);
    }

    /**
     * <p>
     * The time period.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #period} will
     * return {@link AggregationPeriod#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #periodAsString}.
     * </p>
     * 
     * @return The time period.
     * @see AggregationPeriod
     */
    public String periodAsString() {
        return period;
    }

    /**
     * <p>
     * The start time.
     * </p>
     * 
     * @return The start time.
     */
    public Instant start() {
        return start;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(periodAsString());
        hashCode = 31 * hashCode + Objects.hashCode(start());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AggregatedProfileTime)) {
            return false;
        }
        AggregatedProfileTime other = (AggregatedProfileTime) obj;
        return Objects.equals(periodAsString(), other.periodAsString()) && Objects.equals(start(), other.start());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("AggregatedProfileTime").add("Period", periodAsString()).add("Start", start()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "period":
            return Optional.ofNullable(clazz.cast(periodAsString()));
        case "start":
            return Optional.ofNullable(clazz.cast(start()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AggregatedProfileTime, T> g) {
        return obj -> g.apply((AggregatedProfileTime) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AggregatedProfileTime> {
        /**
         * <p>
         * The time period.
         * </p>
         * 
         * @param period
         *        The time period.
         * @see AggregationPeriod
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AggregationPeriod
         */
        Builder period(String period);

        /**
         * <p>
         * The time period.
         * </p>
         * 
         * @param period
         *        The time period.
         * @see AggregationPeriod
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AggregationPeriod
         */
        Builder period(AggregationPeriod period);

        /**
         * <p>
         * The start time.
         * </p>
         * 
         * @param start
         *        The start time.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder start(Instant start);
    }

    static final class BuilderImpl implements Builder {
        private String period;

        private Instant start;

        private BuilderImpl() {
        }

        private BuilderImpl(AggregatedProfileTime model) {
            period(model.period);
            start(model.start);
        }

        public final String getPeriod() {
            return period;
        }

        @Override
        public final Builder period(String period) {
            this.period = period;
            return this;
        }

        @Override
        public final Builder period(AggregationPeriod period) {
            this.period(period == null ? null : period.toString());
            return this;
        }

        public final void setPeriod(String period) {
            this.period = period;
        }

        public final Instant getStart() {
            return start;
        }

        @Override
        public final Builder start(Instant start) {
            this.start = start;
            return this;
        }

        public final void setStart(Instant start) {
            this.start = start;
        }

        @Override
        public AggregatedProfileTime build() {
            return new AggregatedProfileTime(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
