/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.codegen.emitters;

import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.codegen.emitters.GeneratorPathProvider;
import software.amazon.awssdk.codegen.emitters.tasks.SharedModelsTaskParamsValidator;
import software.amazon.awssdk.codegen.model.intermediate.IntermediateModel;
import software.amazon.awssdk.codegen.poet.PoetExtensions;

public class GeneratorTaskParams {
    private static final Consumer<GeneratorTaskParams> TASK_PARAMS_VALIDATORS = new SharedModelsTaskParamsValidator();
    private final IntermediateModel model;
    private final GeneratorPathProvider pathProvider;
    private final PoetExtensions poetExtensions;
    private final Logger log = LoggerFactory.getLogger(GeneratorTaskParams.class);

    private GeneratorTaskParams(IntermediateModel model, GeneratorPathProvider pathProvider) {
        this.model = model;
        this.pathProvider = pathProvider;
        this.poetExtensions = new PoetExtensions(model);
    }

    public static GeneratorTaskParams create(IntermediateModel model, String sourceDirectory, String testDirectory) {
        GeneratorPathProvider pathProvider = new GeneratorPathProvider(model, sourceDirectory, testDirectory);
        GeneratorTaskParams params = new GeneratorTaskParams(model, pathProvider);
        TASK_PARAMS_VALIDATORS.accept(params);
        return params;
    }

    public IntermediateModel getModel() {
        return this.model;
    }

    public GeneratorPathProvider getPathProvider() {
        return this.pathProvider;
    }

    public PoetExtensions getPoetExtensions() {
        return this.poetExtensions;
    }

    public Logger getLog() {
        return this.log;
    }
}

