/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.codegen.poet.rules;

import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.jr.stree.JrsBoolean;
import com.fasterxml.jackson.jr.stree.JrsString;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.FieldSpec;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import com.squareup.javapoet.TypeVariableName;
import java.lang.reflect.Type;
import java.time.Duration;
import java.util.List;
import java.util.ListIterator;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletionException;
import java.util.function.Supplier;
import javax.lang.model.element.Modifier;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.auth.signer.Aws4Signer;
import software.amazon.awssdk.auth.signer.AwsS3V4Signer;
import software.amazon.awssdk.auth.signer.SignerLoader;
import software.amazon.awssdk.awscore.AwsExecutionAttribute;
import software.amazon.awssdk.awscore.endpoints.AwsEndpointAttribute;
import software.amazon.awssdk.awscore.endpoints.authscheme.EndpointAuthScheme;
import software.amazon.awssdk.awscore.endpoints.authscheme.SigV4AuthScheme;
import software.amazon.awssdk.awscore.endpoints.authscheme.SigV4aAuthScheme;
import software.amazon.awssdk.awscore.util.SignerOverrideUtils;
import software.amazon.awssdk.codegen.internal.Utils;
import software.amazon.awssdk.codegen.model.config.customization.EndpointAuthSchemeConfig;
import software.amazon.awssdk.codegen.model.intermediate.IntermediateModel;
import software.amazon.awssdk.codegen.model.intermediate.OperationModel;
import software.amazon.awssdk.codegen.model.rules.endpoints.ParameterModel;
import software.amazon.awssdk.codegen.model.service.ClientContextParam;
import software.amazon.awssdk.codegen.model.service.ContextParam;
import software.amazon.awssdk.codegen.model.service.EndpointTrait;
import software.amazon.awssdk.codegen.model.service.HostPrefixProcessor;
import software.amazon.awssdk.codegen.model.service.StaticContextParam;
import software.amazon.awssdk.codegen.poet.ClassSpec;
import software.amazon.awssdk.codegen.poet.PoetExtension;
import software.amazon.awssdk.codegen.poet.PoetUtils;
import software.amazon.awssdk.codegen.poet.auth.scheme.AuthSchemeSpecUtils;
import software.amazon.awssdk.codegen.poet.auth.scheme.ModelAuthSchemeClassesKnowledgeIndex;
import software.amazon.awssdk.codegen.poet.rules.EndpointParamsKnowledgeIndex;
import software.amazon.awssdk.codegen.poet.rules.EndpointRulesSpecUtils;
import software.amazon.awssdk.codegen.poet.waiters.JmesPathAcceptorGenerator;
import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.core.SelectedAuthScheme;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.interceptor.Context;
import software.amazon.awssdk.core.interceptor.ExecutionAttributes;
import software.amazon.awssdk.core.interceptor.ExecutionInterceptor;
import software.amazon.awssdk.core.interceptor.SdkExecutionAttribute;
import software.amazon.awssdk.core.interceptor.SdkInternalExecutionAttribute;
import software.amazon.awssdk.core.metrics.CoreMetric;
import software.amazon.awssdk.core.signer.Signer;
import software.amazon.awssdk.endpoints.Endpoint;
import software.amazon.awssdk.http.SdkHttpRequest;
import software.amazon.awssdk.http.auth.aws.scheme.AwsV4AuthScheme;
import software.amazon.awssdk.http.auth.aws.scheme.AwsV4aAuthScheme;
import software.amazon.awssdk.http.auth.aws.signer.AwsV4HttpSigner;
import software.amazon.awssdk.http.auth.aws.signer.AwsV4aHttpSigner;
import software.amazon.awssdk.http.auth.aws.signer.RegionSet;
import software.amazon.awssdk.http.auth.spi.scheme.AuthSchemeOption;
import software.amazon.awssdk.identity.spi.Identity;
import software.amazon.awssdk.metrics.MetricCollector;
import software.amazon.awssdk.utils.AttributeMap;
import software.amazon.awssdk.utils.CollectionUtils;
import software.amazon.awssdk.utils.HostnameValidator;
import software.amazon.awssdk.utils.StringUtils;
import software.amazon.awssdk.utils.internal.CodegenNamingUtils;

public class EndpointResolverInterceptorSpec
implements ClassSpec {
    private final IntermediateModel model;
    private final EndpointRulesSpecUtils endpointRulesSpecUtils;
    private final EndpointParamsKnowledgeIndex endpointParamsKnowledgeIndex;
    private final PoetExtension poetExtension;
    private final JmesPathAcceptorGenerator jmesPathGenerator;
    private final boolean dependsOnHttpAuthAws;
    private final boolean useSraAuth;
    private final boolean multiAuthSigv4a;
    private final boolean legacyAuthFromEndpointRulesService;

    public EndpointResolverInterceptorSpec(IntermediateModel model) {
        this.model = model;
        this.endpointRulesSpecUtils = new EndpointRulesSpecUtils(model);
        this.endpointParamsKnowledgeIndex = EndpointParamsKnowledgeIndex.of(model);
        this.poetExtension = new PoetExtension(model);
        this.jmesPathGenerator = new JmesPathAcceptorGenerator(this.poetExtension.jmesPathRuntimeClass());
        Set<Class<?>> supportedAuthSchemes = ModelAuthSchemeClassesKnowledgeIndex.of(model).serviceConcreteAuthSchemeClasses();
        this.dependsOnHttpAuthAws = supportedAuthSchemes.contains(AwsV4AuthScheme.class) || supportedAuthSchemes.contains(AwsV4aAuthScheme.class);
        this.useSraAuth = new AuthSchemeSpecUtils(model).useSraAuth();
        this.multiAuthSigv4a = new AuthSchemeSpecUtils(model).usesSigV4a();
        this.legacyAuthFromEndpointRulesService = new AuthSchemeSpecUtils(model).generateEndpointBasedParams();
    }

    @Override
    public TypeSpec poetSpec() {
        FieldSpec endpointAuthSchemeStrategyFieldSpec = this.endpointAuthSchemeStrategyFieldSpec();
        TypeSpec.Builder b = PoetUtils.createClassBuilder(this.className()).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.FINAL}).addAnnotation(SdkInternalApi.class).addSuperinterface(ExecutionInterceptor.class);
        if (!this.useSraAuth) {
            b.addField(endpointAuthSchemeStrategyFieldSpec);
            b.addMethod(this.constructorMethodSpec(endpointAuthSchemeStrategyFieldSpec.name));
        }
        b.addMethod(this.modifyRequestMethod(endpointAuthSchemeStrategyFieldSpec.name));
        b.addMethod(this.modifyHttpRequestMethod());
        b.addMethod(this.ruleParams());
        b.addMethod(this.setContextParams());
        this.addContextParamMethods(b);
        b.addMethod(this.setStaticContextParamsMethod());
        this.addStaticContextParamMethods(b);
        b.addMethod(this.authSchemeWithEndpointSignerPropertiesMethod());
        if (this.hasClientContextParams()) {
            b.addMethod(this.setClientContextParamsMethod());
        }
        b.addMethod(this.setOperationContextParams());
        this.addOperationContextParamMethods(b);
        b.addMethod(this.hostPrefixMethod());
        if (!this.useSraAuth) {
            b.addMethod(this.signerProviderMethod());
        }
        this.endpointParamsKnowledgeIndex.addAccountIdMethodsIfPresent(b);
        return b.build();
    }

    @Override
    public ClassName className() {
        return this.endpointRulesSpecUtils.resolverInterceptorName();
    }

    private FieldSpec endpointAuthSchemeStrategyFieldSpec() {
        return FieldSpec.builder((TypeName)this.endpointRulesSpecUtils.rulesRuntimeClassName("EndpointAuthSchemeStrategy"), (String)"endpointAuthSchemeStrategy", (Modifier[])new Modifier[]{Modifier.PRIVATE, Modifier.FINAL}).build();
    }

    private MethodSpec modifyRequestMethod(String endpointAuthSchemeStrategyFieldName) {
        MethodSpec.Builder b = MethodSpec.methodBuilder((String)"modifyRequest").addModifiers(new Modifier[]{Modifier.PUBLIC}).addAnnotation(Override.class).returns(SdkRequest.class).addParameter(Context.ModifyRequest.class, "context", new Modifier[0]).addParameter(ExecutionAttributes.class, "executionAttributes", new Modifier[0]);
        String providerVar = "provider";
        b.addStatement("$T result = context.request()", new Object[]{SdkRequest.class});
        b.beginControlFlow("if ($1T.endpointIsDiscovered(executionAttributes))", new Object[]{this.endpointRulesSpecUtils.rulesRuntimeClassName("AwsEndpointProviderUtils")});
        b.addStatement("return result", new Object[0]);
        b.endControlFlow();
        b.addStatement("$1T $2N = ($1T) executionAttributes.getAttribute($3T.ENDPOINT_PROVIDER)", new Object[]{this.endpointRulesSpecUtils.providerInterfaceName(), providerVar, SdkInternalExecutionAttribute.class});
        b.beginControlFlow("try", new Object[0]);
        b.addStatement("long resolveEndpointStart = $T.nanoTime()", new Object[]{System.class});
        b.addStatement("$T endpointParams = ruleParams(result, executionAttributes)", new Object[]{this.endpointRulesSpecUtils.parametersClassName()});
        b.addStatement("$T endpoint = $N.resolveEndpoint(endpointParams).join()", new Object[]{Endpoint.class, providerVar});
        b.addStatement("$1T resolveEndpointDuration = $1T.ofNanos($2T.nanoTime() - resolveEndpointStart)", new Object[]{Duration.class, System.class});
        b.addStatement("$T metricCollector = executionAttributes.getOptionalAttribute($T.API_CALL_METRIC_COLLECTOR)", new Object[]{ParameterizedTypeName.get(Optional.class, (Type[])new Type[]{MetricCollector.class}), SdkExecutionAttribute.class});
        b.addStatement("metricCollector.ifPresent(mc -> mc.reportMetric($T.ENDPOINT_RESOLVE_DURATION, resolveEndpointDuration))", new Object[]{CoreMetric.class});
        b.beginControlFlow("if (!$T.disableHostPrefixInjection(executionAttributes))", new Object[]{this.endpointRulesSpecUtils.rulesRuntimeClassName("AwsEndpointProviderUtils")});
        b.addStatement("$T hostPrefix = hostPrefix(executionAttributes.getAttribute($T.OPERATION_NAME), result)", new Object[]{ParameterizedTypeName.get(Optional.class, (Type[])new Type[]{String.class}), SdkExecutionAttribute.class});
        b.beginControlFlow("if (hostPrefix.isPresent())", new Object[0]);
        b.addStatement("endpoint = $T.addHostPrefix(endpoint, hostPrefix.get())", new Object[]{this.endpointRulesSpecUtils.rulesRuntimeClassName("AwsEndpointProviderUtils")});
        b.endControlFlow();
        b.endControlFlow();
        b.addStatement("$T<$T> endpointAuthSchemes = endpoint.attribute($T.AUTH_SCHEMES)", new Object[]{List.class, EndpointAuthScheme.class, AwsEndpointAttribute.class});
        b.addStatement("$T<?> selectedAuthScheme = executionAttributes.getAttribute($T.SELECTED_AUTH_SCHEME)", new Object[]{SelectedAuthScheme.class, SdkInternalExecutionAttribute.class});
        b.beginControlFlow("if (endpointAuthSchemes != null && selectedAuthScheme != null)", new Object[0]);
        b.addStatement("selectedAuthScheme = authSchemeWithEndpointSignerProperties(endpointAuthSchemes, selectedAuthScheme)", new Object[0]);
        if (this.multiAuthSigv4a || this.legacyAuthFromEndpointRulesService) {
            b.addComment("Precedence of SigV4a RegionSet is set according to multi-auth SigV4a specifications", new Object[0]);
            b.beginControlFlow("if(selectedAuthScheme.authSchemeOption().schemeId().equals($T.SCHEME_ID) && selectedAuthScheme.authSchemeOption().signerProperty($T.REGION_SET) == null)", new Object[]{AwsV4aAuthScheme.class, AwsV4aHttpSigner.class});
            b.addStatement("$T optionBuilder = selectedAuthScheme.authSchemeOption().toBuilder()", new Object[]{AuthSchemeOption.Builder.class});
            b.addStatement("$T regionSet = $T.create(endpointParams.region().id())", new Object[]{RegionSet.class, RegionSet.class});
            b.addStatement("optionBuilder.putSignerProperty($T.REGION_SET, regionSet)", new Object[]{AwsV4aHttpSigner.class});
            b.addStatement("selectedAuthScheme = new $T(selectedAuthScheme.identity(), selectedAuthScheme.signer(), optionBuilder.build())", new Object[]{SelectedAuthScheme.class});
            b.endControlFlow();
        }
        b.addStatement("executionAttributes.putAttribute($T.SELECTED_AUTH_SCHEME, selectedAuthScheme)", new Object[]{SdkInternalExecutionAttribute.class});
        b.endControlFlow();
        if (!this.useSraAuth) {
            b.beginControlFlow("if (endpointAuthSchemes != null)", new Object[0]);
            b.addStatement("$T chosenAuthScheme = $N.chooseAuthScheme(endpointAuthSchemes)", new Object[]{EndpointAuthScheme.class, endpointAuthSchemeStrategyFieldName});
            b.addStatement("$T<$T> signerProvider = signerProvider(chosenAuthScheme)", new Object[]{Supplier.class, Signer.class});
            b.addStatement("result = $T.overrideSignerIfNotOverridden(result, executionAttributes, signerProvider)", new Object[]{SignerOverrideUtils.class});
            b.endControlFlow();
        }
        b.addStatement("executionAttributes.putAttribute(SdkInternalExecutionAttribute.RESOLVED_ENDPOINT, endpoint)", new Object[0]);
        b.addStatement("return result", new Object[0]);
        b.endControlFlow();
        b.beginControlFlow("catch ($T e)", new Object[]{CompletionException.class});
        b.addStatement("$T cause = e.getCause()", new Object[]{Throwable.class});
        b.beginControlFlow("if (cause instanceof $T)", new Object[]{SdkClientException.class});
        b.addStatement("throw ($T) cause", new Object[]{SdkClientException.class});
        b.endControlFlow();
        b.beginControlFlow("else", new Object[0]);
        b.addStatement("throw $T.create($S, cause)", new Object[]{SdkClientException.class, "Endpoint resolution failed"});
        b.endControlFlow();
        b.endControlFlow();
        return b.build();
    }

    private MethodSpec modifyHttpRequestMethod() {
        MethodSpec.Builder b = MethodSpec.methodBuilder((String)"modifyHttpRequest").addModifiers(new Modifier[]{Modifier.PUBLIC}).addAnnotation(Override.class).returns(SdkHttpRequest.class).addParameter(Context.ModifyHttpRequest.class, "context", new Modifier[0]).addParameter(ExecutionAttributes.class, "executionAttributes", new Modifier[0]);
        b.addStatement("$T resolvedEndpoint = executionAttributes.getAttribute($T.RESOLVED_ENDPOINT)", new Object[]{Endpoint.class, SdkInternalExecutionAttribute.class});
        b.beginControlFlow("if (resolvedEndpoint.headers().isEmpty())", new Object[0]);
        b.addStatement("return context.httpRequest()", new Object[0]);
        b.endControlFlow();
        b.addStatement("$T httpRequestBuilder = context.httpRequest().toBuilder()", new Object[]{SdkHttpRequest.Builder.class});
        b.addCode("resolvedEndpoint.headers().forEach((name, values) -> {", new Object[0]);
        b.addStatement("values.forEach(v -> httpRequestBuilder.appendHeader(name, v))", new Object[0]);
        b.addCode("});", new Object[0]);
        b.addStatement("return httpRequestBuilder.build()", new Object[0]);
        return b.build();
    }

    private MethodSpec ruleParams() {
        MethodSpec.Builder b = MethodSpec.methodBuilder((String)"ruleParams").addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.STATIC}).returns((TypeName)this.endpointRulesSpecUtils.parametersClassName()).addParameter(SdkRequest.class, "request", new Modifier[0]).addParameter(ExecutionAttributes.class, "executionAttributes", new Modifier[0]);
        b.addStatement("$T builder = $T.builder()", new Object[]{this.paramsBuilderClass(), this.endpointRulesSpecUtils.parametersClassName()});
        Map<String, ParameterModel> parameters = this.model.getEndpointRuleSetModel().getParameters();
        parameters.forEach((n, m) -> {
            if (m.getBuiltInEnum() == null) {
                return;
            }
            String setter = Utils.unCapitalize(CodegenNamingUtils.pascalCase((String)n));
            switch (m.getBuiltInEnum()) {
                case AWS_REGION: {
                    b.addStatement(this.endpointProviderUtilsSetter("regionBuiltIn", setter));
                    break;
                }
                case AWS_USE_DUAL_STACK: {
                    b.addStatement(this.endpointProviderUtilsSetter("dualStackEnabledBuiltIn", setter));
                    break;
                }
                case AWS_USE_FIPS: {
                    b.addStatement(this.endpointProviderUtilsSetter("fipsEnabledBuiltIn", setter));
                    break;
                }
                case SDK_ENDPOINT: {
                    b.addStatement(this.endpointProviderUtilsSetter("endpointBuiltIn", setter));
                    break;
                }
                case AWS_AUTH_ACCOUNT_ID: {
                    b.addStatement("builder.$N(resolveAndRecordAccountIdFromIdentity(executionAttributes))", new Object[]{setter});
                    break;
                }
                case AWS_AUTH_ACCOUNT_ID_ENDPOINT_MODE: {
                    b.addStatement("builder.$N(recordAccountIdEndpointMode(executionAttributes))", new Object[]{setter});
                    break;
                }
                case AWS_S3_USE_GLOBAL_ENDPOINT: {
                    b.addStatement("builder.$N(executionAttributes.getAttribute($T.$N))", new Object[]{setter, AwsExecutionAttribute.class, this.model.getNamingStrategy().getEnumValueName((String)n)});
                    break;
                }
                case AWS_S3_ACCELERATE: 
                case AWS_S3_DISABLE_MULTI_REGION_ACCESS_POINTS: 
                case AWS_S3_FORCE_PATH_STYLE: 
                case AWS_S3_USE_ARN_REGION: 
                case AWS_S3_CONTROL_USE_ARN_REGION: 
                case AWS_STS_USE_GLOBAL_ENDPOINT: {
                    return;
                }
                default: {
                    throw new RuntimeException("Don't know how to set built-in " + (Object)((Object)m.getBuiltInEnum()));
                }
            }
        });
        if (this.hasClientContextParams()) {
            b.addStatement("setClientContextParams(builder, executionAttributes)", new Object[0]);
        }
        b.addStatement("setContextParams(builder, executionAttributes.getAttribute($T.OPERATION_NAME), request)", new Object[]{AwsExecutionAttribute.class});
        b.addStatement("setStaticContextParams(builder, executionAttributes.getAttribute($T.OPERATION_NAME))", new Object[]{AwsExecutionAttribute.class});
        b.addStatement("setOperationContextParams(builder, executionAttributes.getAttribute($T.OPERATION_NAME), request)", new Object[]{AwsExecutionAttribute.class});
        b.addStatement("return builder.build()", new Object[0]);
        return b.build();
    }

    private CodeBlock endpointProviderUtilsSetter(String builtInFn, String setterName) {
        return CodeBlock.of((String)"builder.$N($T.$N(executionAttributes))", (Object[])new Object[]{setterName, this.endpointRulesSpecUtils.rulesRuntimeClassName("AwsEndpointProviderUtils"), builtInFn});
    }

    private ClassName paramsBuilderClass() {
        return this.endpointRulesSpecUtils.parametersClassName().nestedClass("Builder");
    }

    private MethodSpec addStaticContextParamsMethod(OperationModel opModel) {
        String methodName = this.staticContextParamsMethodName(opModel);
        MethodSpec.Builder b = MethodSpec.methodBuilder((String)methodName).addModifiers(new Modifier[]{Modifier.PRIVATE, Modifier.STATIC}).returns(Void.TYPE).addParameter((TypeName)this.paramsBuilderClass(), "params", new Modifier[0]);
        opModel.getStaticContextParams().forEach((n, m) -> {
            String setterName = this.endpointRulesSpecUtils.paramMethodName((String)n);
            TreeNode value = m.getValue();
            switch (value.asToken()) {
                case VALUE_STRING: {
                    b.addStatement("params.$N($S)", new Object[]{setterName, ((JrsString)value).getValue()});
                    break;
                }
                case VALUE_TRUE: 
                case VALUE_FALSE: {
                    b.addStatement("params.$N($L)", new Object[]{setterName, ((JrsBoolean)value).booleanValue()});
                    break;
                }
                default: {
                    throw new RuntimeException("Don't know how to set parameter of type " + value.asToken());
                }
            }
        });
        return b.build();
    }

    private String staticContextParamsMethodName(OperationModel opModel) {
        return opModel.getMethodName() + "StaticContextParams";
    }

    private boolean hasStaticContextParams(OperationModel opModel) {
        Map<String, StaticContextParam> staticContextParams = opModel.getStaticContextParams();
        return staticContextParams != null && !staticContextParams.isEmpty();
    }

    private boolean hasOperationContextParams(OperationModel opModel) {
        return CollectionUtils.isNotEmpty(opModel.getOperationContextParams());
    }

    private void addStaticContextParamMethods(TypeSpec.Builder classBuilder) {
        Map<String, OperationModel> operations = this.model.getOperations();
        operations.forEach((n, m) -> {
            if (this.hasStaticContextParams((OperationModel)m)) {
                classBuilder.addMethod(this.addStaticContextParamsMethod((OperationModel)m));
            }
        });
    }

    private void addContextParamMethods(TypeSpec.Builder classBuilder) {
        Map<String, OperationModel> operations = this.model.getOperations();
        operations.forEach((n, m) -> {
            if (this.hasContextParams((OperationModel)m)) {
                classBuilder.addMethod(this.setContextParamsMethod((OperationModel)m));
            }
        });
    }

    private void addOperationContextParamMethods(TypeSpec.Builder classBuilder) {
        Map<String, OperationModel> operations = this.model.getOperations();
        operations.forEach((n, m) -> {
            if (this.hasOperationContextParams((OperationModel)m)) {
                classBuilder.addMethod(this.setOperationContextParamsMethod((OperationModel)m));
            }
        });
    }

    private MethodSpec setStaticContextParamsMethod() {
        Map<String, OperationModel> operations = this.model.getOperations();
        MethodSpec.Builder b = MethodSpec.methodBuilder((String)"setStaticContextParams").addModifiers(new Modifier[]{Modifier.PRIVATE, Modifier.STATIC}).addParameter((TypeName)this.paramsBuilderClass(), "params", new Modifier[0]).addParameter(String.class, "operationName", new Modifier[0]).returns(Void.TYPE);
        boolean generateSwitch = operations.values().stream().anyMatch(this::hasStaticContextParams);
        if (generateSwitch) {
            b.beginControlFlow("switch (operationName)", new Object[0]);
            operations.forEach((n, m) -> {
                if (!this.hasStaticContextParams((OperationModel)m)) {
                    return;
                }
                b.addCode("case $S:", new Object[]{n});
                b.addStatement("$N(params)", new Object[]{this.staticContextParamsMethodName((OperationModel)m)});
                b.addStatement("break", new Object[0]);
            });
            b.addCode("default:", new Object[0]);
            b.addStatement("break", new Object[0]);
            b.endControlFlow();
        }
        return b.build();
    }

    private MethodSpec setContextParams() {
        Map<String, OperationModel> operations = this.model.getOperations();
        MethodSpec.Builder b = MethodSpec.methodBuilder((String)"setContextParams").addModifiers(new Modifier[]{Modifier.PRIVATE, Modifier.STATIC}).addParameter((TypeName)this.paramsBuilderClass(), "params", new Modifier[0]).addParameter(String.class, "operationName", new Modifier[0]).addParameter(SdkRequest.class, "request", new Modifier[0]).returns(Void.TYPE);
        boolean generateSwitch = operations.values().stream().anyMatch(this::hasContextParams);
        if (generateSwitch) {
            b.beginControlFlow("switch (operationName)", new Object[0]);
            operations.forEach((n, m) -> {
                if (!this.hasContextParams((OperationModel)m)) {
                    return;
                }
                String requestClassName = this.model.getNamingStrategy().getRequestClassName(m.getOperationName());
                ClassName requestClass = this.poetExtension.getModelClass(requestClassName);
                b.addCode("case $S:", new Object[]{n});
                b.addStatement("setContextParams(params, ($T) request)", new Object[]{requestClass});
                b.addStatement("break", new Object[0]);
            });
            b.addCode("default:", new Object[0]);
            b.addStatement("break", new Object[0]);
            b.endControlFlow();
        }
        return b.build();
    }

    private MethodSpec setOperationContextParams() {
        Map<String, OperationModel> operations = this.model.getOperations();
        MethodSpec.Builder b = MethodSpec.methodBuilder((String)"setOperationContextParams").addModifiers(new Modifier[]{Modifier.PRIVATE, Modifier.STATIC}).addParameter((TypeName)this.paramsBuilderClass(), "params", new Modifier[0]).addParameter(String.class, "operationName", new Modifier[0]).addParameter(SdkRequest.class, "request", new Modifier[0]).returns(Void.TYPE);
        boolean generateSwitch = operations.values().stream().anyMatch(this::hasOperationContextParams);
        if (generateSwitch) {
            b.beginControlFlow("switch (operationName)", new Object[0]);
            operations.forEach((n, m) -> {
                if (!this.hasOperationContextParams((OperationModel)m)) {
                    return;
                }
                String requestClassName = this.model.getNamingStrategy().getRequestClassName(m.getOperationName());
                ClassName requestClass = this.poetExtension.getModelClass(requestClassName);
                b.addCode("case $S:", new Object[]{n});
                b.addStatement("setOperationContextParams(params, ($T) request)", new Object[]{requestClass});
                b.addStatement("break", new Object[0]);
            });
            b.addCode("default:", new Object[0]);
            b.addStatement("break", new Object[0]);
            b.endControlFlow();
        }
        return b.build();
    }

    private MethodSpec setContextParamsMethod(OperationModel opModel) {
        String requestClassName = this.model.getNamingStrategy().getRequestClassName(opModel.getOperationName());
        ClassName requestClass = this.poetExtension.getModelClass(requestClassName);
        MethodSpec.Builder b = MethodSpec.methodBuilder((String)"setContextParams").addModifiers(new Modifier[]{Modifier.PRIVATE, Modifier.STATIC}).addParameter((TypeName)this.paramsBuilderClass(), "params", new Modifier[0]).addParameter((TypeName)requestClass, "request", new Modifier[0]).returns(Void.TYPE);
        opModel.getInputShape().getMembers().forEach(m -> {
            ContextParam param = m.getContextParam();
            if (param == null) {
                return;
            }
            String setterName = this.endpointRulesSpecUtils.paramMethodName(param.getName());
            b.addStatement("params.$N(request.$N())", new Object[]{setterName, m.getFluentGetterMethodName()});
        });
        return b.build();
    }

    private MethodSpec setOperationContextParamsMethod(OperationModel opModel) {
        String requestClassName = this.model.getNamingStrategy().getRequestClassName(opModel.getOperationName());
        ClassName requestClass = this.poetExtension.getModelClass(requestClassName);
        MethodSpec.Builder b = MethodSpec.methodBuilder((String)"setOperationContextParams").addModifiers(new Modifier[]{Modifier.PRIVATE, Modifier.STATIC}).addParameter((TypeName)this.paramsBuilderClass(), "params", new Modifier[0]).addParameter((TypeName)requestClass, "request", new Modifier[0]).returns(Void.TYPE);
        b.addStatement("$1T input = new $1T(request)", new Object[]{this.poetExtension.jmesPathRuntimeClass().nestedClass("Value")});
        opModel.getOperationContextParams().forEach((key, value) -> {
            if (Objects.requireNonNull(value.getPath().asToken()) != JsonToken.VALUE_STRING) {
                throw new RuntimeException("Invalid operation context parameter path for " + opModel.getOperationName() + ". Expected VALUE_STRING, but got " + value.getPath().asToken());
            }
            String setterName = this.endpointRulesSpecUtils.paramMethodName((String)key);
            String jmesPathString = ((JrsString)value.getPath()).getValue();
            CodeBlock addParam = CodeBlock.builder().add("params.$N(", new Object[]{setterName}).add(this.jmesPathGenerator.interpret(jmesPathString, "input")).add(this.matchToParameterType((String)key)).add(")", new Object[0]).build();
            b.addStatement(addParam);
        });
        return b.build();
    }

    private CodeBlock matchToParameterType(String paramName) {
        Map<String, ParameterModel> parameters = this.model.getEndpointRuleSetModel().getParameters();
        Optional<ParameterModel> endpointParameter = parameters.entrySet().stream().filter(e -> ((String)e.getKey()).toLowerCase(Locale.US).equals(paramName.toLowerCase(Locale.US))).map(Map.Entry::getValue).findFirst();
        return endpointParameter.map(this::convertValueToParameterType).orElseGet(() -> CodeBlock.of((String)"", (Object[])new Object[0]));
    }

    private CodeBlock convertValueToParameterType(ParameterModel parameterModel) {
        switch (parameterModel.getType().toLowerCase(Locale.US)) {
            case "boolean": {
                return CodeBlock.of((String)".booleanValue()", (Object[])new Object[0]);
            }
            case "string": {
                return CodeBlock.of((String)".stringValue()", (Object[])new Object[0]);
            }
            case "stringarray": {
                return CodeBlock.of((String)".stringValues()", (Object[])new Object[0]);
            }
        }
        throw new UnsupportedOperationException("Supported types are boolean, string and stringarray. Given type was " + parameterModel.getType());
    }

    private boolean hasContextParams(OperationModel opModel) {
        return opModel.getInputShape().getMembers().stream().anyMatch(m -> m.getContextParam() != null);
    }

    private boolean hasClientContextParams() {
        Map<String, ClientContextParam> clientContextParams = this.model.getClientContextParams();
        return clientContextParams != null && !clientContextParams.isEmpty();
    }

    private MethodSpec setClientContextParamsMethod() {
        MethodSpec.Builder b = MethodSpec.methodBuilder((String)"setClientContextParams").addModifiers(new Modifier[]{Modifier.PRIVATE, Modifier.STATIC}).addParameter((TypeName)this.paramsBuilderClass(), "params", new Modifier[0]).addParameter(ExecutionAttributes.class, "executionAttributes", new Modifier[0]).returns(Void.TYPE);
        b.addStatement("$T clientContextParams = executionAttributes.getAttribute($T.CLIENT_CONTEXT_PARAMS)", new Object[]{AttributeMap.class, SdkInternalExecutionAttribute.class});
        ClassName paramsClass = this.endpointRulesSpecUtils.clientContextParamsName();
        Map<String, ClientContextParam> params = this.model.getClientContextParams();
        params.forEach((n, m) -> {
            String attrName = this.endpointRulesSpecUtils.clientContextParamName((String)n);
            b.addStatement("$T.ofNullable(clientContextParams.get($T.$N)).ifPresent(params::$N)", new Object[]{Optional.class, paramsClass, attrName, this.endpointRulesSpecUtils.paramMethodName((String)n)});
        });
        return b.build();
    }

    private MethodSpec hostPrefixMethod() {
        MethodSpec.Builder builder = MethodSpec.methodBuilder((String)"hostPrefix").returns((TypeName)ParameterizedTypeName.get(Optional.class, (Type[])new Type[]{String.class})).addParameter(String.class, "operationName", new Modifier[0]).addParameter(SdkRequest.class, "request", new Modifier[0]).addModifiers(new Modifier[]{Modifier.PRIVATE, Modifier.STATIC});
        boolean generateSwitch = this.model.getOperations().values().stream().anyMatch(opModel -> StringUtils.isNotBlank((CharSequence)this.getHostPrefix((OperationModel)opModel)));
        if (!generateSwitch) {
            builder.addStatement("return $T.empty()", new Object[]{Optional.class});
        } else {
            builder.beginControlFlow("switch (operationName)", new Object[0]);
            this.model.getOperations().forEach((name, opModel) -> {
                String hostPrefix = this.getHostPrefix((OperationModel)opModel);
                if (StringUtils.isBlank((CharSequence)hostPrefix)) {
                    return;
                }
                builder.beginControlFlow("case $S:", new Object[]{name});
                HostPrefixProcessor processor = new HostPrefixProcessor(hostPrefix);
                if (processor.c2jNames().isEmpty()) {
                    builder.addStatement("return $T.of($S)", new Object[]{Optional.class, processor.hostWithStringSpecifier()});
                } else {
                    String requestVar = opModel.getInput().getVariableName();
                    processor.c2jNames().forEach(c2jName -> builder.addStatement("$1T.validateHostnameCompliant(request.getValueForField($2S, $3T.class).orElse(null), $2S, $4S)", new Object[]{HostnameValidator.class, c2jName, String.class, requestVar}));
                    builder.addCode("return $T.of($T.format($S, ", new Object[]{Optional.class, String.class, processor.hostWithStringSpecifier()});
                    ListIterator<String> c2jNamesIter = processor.c2jNames().listIterator();
                    while (c2jNamesIter.hasNext()) {
                        builder.addCode("request.getValueForField($S, $T.class).get()", new Object[]{c2jNamesIter.next(), String.class});
                        if (!c2jNamesIter.hasNext()) continue;
                        builder.addCode(",", new Object[0]);
                    }
                    builder.addStatement("))", new Object[0]);
                }
                builder.endControlFlow();
            });
            builder.addCode("default:", new Object[0]);
            builder.addStatement("return $T.empty()", new Object[]{Optional.class});
            builder.endControlFlow();
        }
        return builder.build();
    }

    private String getHostPrefix(OperationModel opModel) {
        EndpointTrait endpointTrait = opModel.getEndpointTrait();
        if (endpointTrait == null) {
            return null;
        }
        return endpointTrait.getHostPrefix();
    }

    private MethodSpec authSchemeWithEndpointSignerPropertiesMethod() {
        TypeVariableName tExtendsIdentity = TypeVariableName.get((String)"T", (Type[])new Type[]{Identity.class});
        ParameterizedTypeName selectedAuthSchemeOfT = ParameterizedTypeName.get((ClassName)ClassName.get(SelectedAuthScheme.class), (TypeName[])new TypeName[]{TypeVariableName.get((String)"T")});
        ParameterizedTypeName listOfEndpointAuthScheme = ParameterizedTypeName.get(List.class, (Type[])new Type[]{EndpointAuthScheme.class});
        MethodSpec.Builder method = MethodSpec.methodBuilder((String)"authSchemeWithEndpointSignerProperties").addModifiers(new Modifier[]{Modifier.PRIVATE}).addTypeVariable(tExtendsIdentity).returns((TypeName)selectedAuthSchemeOfT).addParameter((TypeName)listOfEndpointAuthScheme, "endpointAuthSchemes", new Modifier[0]).addParameter((TypeName)selectedAuthSchemeOfT, "selectedAuthScheme", new Modifier[0]);
        method.beginControlFlow("for ($T endpointAuthScheme : endpointAuthSchemes)", new Object[]{EndpointAuthScheme.class});
        if (this.useSraAuth) {
            method.beginControlFlow("if (!endpointAuthScheme.schemeId().equals(selectedAuthScheme.authSchemeOption().schemeId()))", new Object[0]);
            method.addStatement("continue", new Object[0]);
            method.endControlFlow();
        }
        method.addStatement("$T option = selectedAuthScheme.authSchemeOption().toBuilder()", new Object[]{AuthSchemeOption.Builder.class});
        if (this.dependsOnHttpAuthAws) {
            method.addCode(EndpointResolverInterceptorSpec.copyV4EndpointSignerPropertiesToAuth());
            method.addCode(this.copyV4aEndpointSignerPropertiesToAuth());
            if (this.endpointRulesSpecUtils.useS3Express()) {
                method.addCode(this.copyS3ExpressEndpointSignerPropertiesToAuth());
            }
        }
        method.addStatement("throw new $T(\"Endpoint auth scheme '\" + endpointAuthScheme.name() + \"' cannot be mapped to the SDK auth scheme. Was it declared in the service's model?\")", new Object[]{IllegalArgumentException.class});
        method.endControlFlow();
        method.addStatement("return selectedAuthScheme", new Object[0]);
        return method.build();
    }

    private static CodeBlock copyV4EndpointSignerPropertiesToAuth() {
        CodeBlock.Builder code = CodeBlock.builder();
        code.beginControlFlow("if (endpointAuthScheme instanceof $T)", new Object[]{SigV4AuthScheme.class});
        code.addStatement("$1T v4AuthScheme = ($1T) endpointAuthScheme", new Object[]{SigV4AuthScheme.class});
        code.beginControlFlow("if (v4AuthScheme.isDisableDoubleEncodingSet())", new Object[0]);
        code.addStatement("option.putSignerProperty($T.DOUBLE_URL_ENCODE, !v4AuthScheme.disableDoubleEncoding())", new Object[]{AwsV4HttpSigner.class});
        code.endControlFlow();
        code.beginControlFlow("if (v4AuthScheme.signingRegion() != null)", new Object[0]);
        code.addStatement("option.putSignerProperty($T.REGION_NAME, v4AuthScheme.signingRegion())", new Object[]{AwsV4HttpSigner.class});
        code.endControlFlow();
        code.beginControlFlow("if (v4AuthScheme.signingName() != null)", new Object[0]);
        code.addStatement("option.putSignerProperty($T.SERVICE_SIGNING_NAME, v4AuthScheme.signingName())", new Object[]{AwsV4HttpSigner.class});
        code.endControlFlow();
        code.addStatement("return new $T<>(selectedAuthScheme.identity(), selectedAuthScheme.signer(), option.build())", new Object[]{SelectedAuthScheme.class});
        code.endControlFlow();
        return code.build();
    }

    private CodeBlock copyV4aEndpointSignerPropertiesToAuth() {
        CodeBlock.Builder code = CodeBlock.builder();
        code.beginControlFlow("if (endpointAuthScheme instanceof $T)", new Object[]{SigV4aAuthScheme.class});
        code.addStatement("$1T v4aAuthScheme = ($1T) endpointAuthScheme", new Object[]{SigV4aAuthScheme.class});
        code.beginControlFlow("if (v4aAuthScheme.isDisableDoubleEncodingSet())", new Object[0]);
        code.addStatement("option.putSignerProperty($T.DOUBLE_URL_ENCODE, !v4aAuthScheme.disableDoubleEncoding())", new Object[]{AwsV4aHttpSigner.class});
        code.endControlFlow();
        if (this.multiAuthSigv4a || this.legacyAuthFromEndpointRulesService) {
            code.beginControlFlow("if (!(selectedAuthScheme.authSchemeOption().schemeId().equals($T.SCHEME_ID) && selectedAuthScheme.authSchemeOption().signerProperty($T.REGION_SET) != null) && !$T.isNullOrEmpty(v4aAuthScheme.signingRegionSet()))", new Object[]{AwsV4aAuthScheme.class, AwsV4aHttpSigner.class, CollectionUtils.class});
        } else {
            code.beginControlFlow("if (!$T.isNullOrEmpty(v4aAuthScheme.signingRegionSet()))", new Object[]{CollectionUtils.class});
        }
        code.addStatement("$1T regionSet = $1T.create(v4aAuthScheme.signingRegionSet())", new Object[]{RegionSet.class});
        code.addStatement("option.putSignerProperty($T.REGION_SET, regionSet)", new Object[]{AwsV4aHttpSigner.class});
        code.endControlFlow();
        code.beginControlFlow("if (v4aAuthScheme.signingName() != null)", new Object[0]);
        code.addStatement("option.putSignerProperty($T.SERVICE_SIGNING_NAME, v4aAuthScheme.signingName())", new Object[]{AwsV4aHttpSigner.class});
        code.endControlFlow();
        code.addStatement("return new $T<>(selectedAuthScheme.identity(), selectedAuthScheme.signer(), option.build())", new Object[]{SelectedAuthScheme.class});
        code.endControlFlow();
        return code.build();
    }

    private CodeBlock copyS3ExpressEndpointSignerPropertiesToAuth() {
        CodeBlock.Builder code = CodeBlock.builder();
        ClassName s3ExpressEndpointAuthSchemeClassName = ClassName.get((String)(this.model.getMetadata().getFullClientPackageName() + ".endpoints.authscheme"), (String)"S3ExpressEndpointAuthScheme", (String[])new String[0]);
        code.beginControlFlow("if (endpointAuthScheme instanceof $T)", new Object[]{s3ExpressEndpointAuthSchemeClassName});
        code.addStatement("$1T s3ExpressAuthScheme = ($1T) endpointAuthScheme", new Object[]{s3ExpressEndpointAuthSchemeClassName});
        code.beginControlFlow("if (s3ExpressAuthScheme.isDisableDoubleEncodingSet())", new Object[0]);
        code.addStatement("option.putSignerProperty($T.DOUBLE_URL_ENCODE, !s3ExpressAuthScheme.disableDoubleEncoding())", new Object[]{AwsV4HttpSigner.class});
        code.endControlFlow();
        code.beginControlFlow("if (s3ExpressAuthScheme.signingRegion() != null)", new Object[0]);
        code.addStatement("option.putSignerProperty($T.REGION_NAME, s3ExpressAuthScheme.signingRegion())", new Object[]{AwsV4HttpSigner.class});
        code.endControlFlow();
        code.beginControlFlow("if (s3ExpressAuthScheme.signingName() != null)", new Object[0]);
        code.addStatement("option.putSignerProperty($T.SERVICE_SIGNING_NAME, s3ExpressAuthScheme.signingName())", new Object[]{AwsV4HttpSigner.class});
        code.endControlFlow();
        code.addStatement("return new $T<>(selectedAuthScheme.identity(), selectedAuthScheme.signer(), option.build())", new Object[]{SelectedAuthScheme.class});
        code.endControlFlow();
        return code.build();
    }

    private MethodSpec signerProviderMethod() {
        MethodSpec.Builder builder = MethodSpec.methodBuilder((String)"signerProvider").addModifiers(new Modifier[]{Modifier.PRIVATE}).addParameter(EndpointAuthScheme.class, "authScheme", new Modifier[0]).returns((TypeName)ParameterizedTypeName.get(Supplier.class, (Type[])new Type[]{Signer.class}));
        builder.beginControlFlow("switch (authScheme.name())", new Object[0]);
        builder.addCode("case $S:", new Object[]{"sigv4"});
        if (this.endpointRulesSpecUtils.isS3() || this.endpointRulesSpecUtils.isS3Control()) {
            builder.addStatement("return $T::create", new Object[]{AwsS3V4Signer.class});
        } else {
            builder.addStatement("return $T::create", new Object[]{Aws4Signer.class});
        }
        builder.addCode("case $S:", new Object[]{"sigv4a"});
        if (this.endpointRulesSpecUtils.isS3() || this.endpointRulesSpecUtils.isS3Control()) {
            builder.addStatement("return $T::getS3SigV4aSigner", new Object[]{SignerLoader.class});
        } else {
            builder.addStatement("return $T::getSigV4aSigner", new Object[]{SignerLoader.class});
        }
        builder.addCode("default:", new Object[0]);
        builder.addStatement("break", new Object[0]);
        builder.endControlFlow();
        builder.addStatement("throw $T.create($S + authScheme.name())", new Object[]{SdkClientException.class, "Don't know how to create signer for auth scheme: "});
        return builder.build();
    }

    private MethodSpec constructorMethodSpec(String endpointAuthSchemeFieldName) {
        MethodSpec.Builder b = MethodSpec.constructorBuilder().addModifiers(new Modifier[]{Modifier.PUBLIC});
        EndpointAuthSchemeConfig endpointAuthSchemeConfig = this.model.getCustomizationConfig().getEndpointAuthSchemeConfig();
        String factoryLocalVarName = "endpointAuthSchemeStrategyFactory";
        if (endpointAuthSchemeConfig != null && endpointAuthSchemeConfig.getAuthSchemeStrategyFactoryClass() != null) {
            b.addStatement("$T $N = new $T()", new Object[]{this.endpointRulesSpecUtils.rulesRuntimeClassName("EndpointAuthSchemeStrategyFactory"), factoryLocalVarName, PoetUtils.classNameFromFqcn(endpointAuthSchemeConfig.getAuthSchemeStrategyFactoryClass())});
        } else {
            b.addStatement("$T $N = new $T()", new Object[]{this.endpointRulesSpecUtils.rulesRuntimeClassName("EndpointAuthSchemeStrategyFactory"), factoryLocalVarName, this.endpointRulesSpecUtils.rulesRuntimeClassName("DefaultEndpointAuthSchemeStrategyFactory")});
        }
        b.addStatement("this.$N = $N.endpointAuthSchemeStrategy()", new Object[]{endpointAuthSchemeFieldName, factoryLocalVarName});
        return b.build();
    }
}

