/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.codegen.poet.rules2;

import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.jr.stree.JrsArray;
import com.fasterxml.jackson.jr.stree.JrsBoolean;
import com.fasterxml.jackson.jr.stree.JrsNumber;
import com.fasterxml.jackson.jr.stree.JrsObject;
import com.fasterxml.jackson.jr.stree.JrsString;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import software.amazon.awssdk.codegen.model.rules.endpoints.ConditionModel;
import software.amazon.awssdk.codegen.model.rules.endpoints.EndpointModel;
import software.amazon.awssdk.codegen.model.rules.endpoints.RuleModel;
import software.amazon.awssdk.codegen.poet.rules2.BooleanAndExpression;
import software.amazon.awssdk.codegen.poet.rules2.EndpointExpression;
import software.amazon.awssdk.codegen.poet.rules2.ErrorExpression;
import software.amazon.awssdk.codegen.poet.rules2.FunctionCallExpression;
import software.amazon.awssdk.codegen.poet.rules2.HeadersExpression;
import software.amazon.awssdk.codegen.poet.rules2.IndexedAccessExpression;
import software.amazon.awssdk.codegen.poet.rules2.LetExpression;
import software.amazon.awssdk.codegen.poet.rules2.ListExpression;
import software.amazon.awssdk.codegen.poet.rules2.LiteralBooleanExpression;
import software.amazon.awssdk.codegen.poet.rules2.LiteralIntegerExpression;
import software.amazon.awssdk.codegen.poet.rules2.LiteralStringExpression;
import software.amazon.awssdk.codegen.poet.rules2.MemberAccessExpression;
import software.amazon.awssdk.codegen.poet.rules2.PropertiesExpression;
import software.amazon.awssdk.codegen.poet.rules2.RuleExpression;
import software.amazon.awssdk.codegen.poet.rules2.RuleSetExpression;
import software.amazon.awssdk.codegen.poet.rules2.StringConcatExpression;
import software.amazon.awssdk.codegen.poet.rules2.Tokenizer;
import software.amazon.awssdk.codegen.poet.rules2.VariableReferenceExpression;
import software.amazon.awssdk.utils.Validate;

public final class ExpressionParser {
    private ExpressionParser() {
    }

    public static RuleSetExpression parseRuleSetExpression(RuleModel model) {
        RuleSetExpression.Builder builder = RuleSetExpression.builder();
        String type = model.getType();
        List<RuleExpression> conditions = ExpressionParser.groupExpressions(model.getConditions());
        builder.conditions(conditions);
        if ("error".equals(type)) {
            builder.error(new ErrorExpression(ExpressionParser.parseErrorExpression(model.getError())));
        } else if ("endpoint".equals(type)) {
            builder.endpoint(ExpressionParser.parseEndpointExpression(model.getEndpoint()));
        } else {
            Validate.isTrue((boolean)"tree".equals(type), (String)("Unknown type, expected any of [error, endpoint, tree] but got: " + type), (Object[])new Object[0]);
            for (RuleModel child : model.getRules()) {
                builder.addChildren(ExpressionParser.parseRuleSetExpression(child));
            }
        }
        return builder.build();
    }

    private static List<RuleExpression> groupExpressions(List<ConditionModel> conditions) {
        ArrayList<RuleExpression> result = new ArrayList<RuleExpression>();
        BooleanAndExpression.Builder andBuilder = null;
        LetExpression.Builder letBuilder = null;
        Boolean readingAnd = null;
        for (ConditionModel model : conditions) {
            RuleExpression expression = ExpressionParser.parseConditionalExpression(model);
            String assign = model.getAssign();
            if (assign != null) {
                if (readingAnd == null) {
                    letBuilder = LetExpression.builder();
                } else if (Boolean.TRUE.equals(readingAnd)) {
                    result.add(andBuilder.build().simplify());
                    letBuilder = LetExpression.builder();
                    andBuilder = null;
                }
                readingAnd = false;
                letBuilder.putBinding(assign, expression);
                continue;
            }
            if (readingAnd == null) {
                andBuilder = BooleanAndExpression.builder();
            } else if (Boolean.FALSE.equals(readingAnd)) {
                result.add(letBuilder.build().simplify());
                andBuilder = BooleanAndExpression.builder();
                letBuilder = null;
            }
            readingAnd = true;
            andBuilder.addExpression(expression);
        }
        if (andBuilder != null) {
            result.add(andBuilder.build().simplify());
        }
        if (letBuilder != null) {
            result.add(letBuilder.build().simplify());
        }
        return result;
    }

    private static RuleExpression parseErrorExpression(String error) {
        return ExpressionParser.parseStringValue(error);
    }

    private static RuleExpression parseConditionalExpression(ConditionModel model) {
        String fn = model.getFn();
        return ExpressionParser.getFunctionCallExpression(fn, model.getArgv());
    }

    private static RuleExpression parseExpressionFrom(TreeNode node) {
        if (node.isObject()) {
            JrsObject obj = (JrsObject)node;
            if (obj.get("fn") != null) {
                String fn = obj.get("fn").asText();
                return ExpressionParser.getFunctionCallExpression(fn, ExpressionParser.nodeArrayToList(node.get("argv")));
            }
            if (obj.get("ref") != null) {
                String ref = obj.get("ref").asText();
                return new VariableReferenceExpression(ref);
            }
            return ExpressionParser.parsePropertiesExpression(obj);
        }
        if (node.isValueNode()) {
            JsonToken token = node.asToken();
            switch (token) {
                case VALUE_STRING: {
                    return ExpressionParser.parseStringValue(((JrsString)node).getValue());
                }
                case VALUE_NUMBER_INT: {
                    return new LiteralIntegerExpression(((JrsNumber)node).getValue().intValue());
                }
                case VALUE_TRUE: 
                case VALUE_FALSE: {
                    return new LiteralBooleanExpression(((JrsBoolean)node).booleanValue());
                }
            }
            throw new RuntimeException("Don't know how to create expression JSON type " + token);
        }
        if (node.isArray()) {
            JrsArray array = (JrsArray)node;
            ListExpression.Builder builder = ListExpression.builder();
            for (int idx = 0; idx < array.size(); ++idx) {
                builder.addExpression(ExpressionParser.parseExpressionFrom((TreeNode)array.get(idx)));
            }
            return builder.build();
        }
        throw new IllegalArgumentException("don't know how to convert from node: " + node);
    }

    public static RuleExpression parseStringValue(String value) {
        if (value.indexOf(123) != -1 || value.indexOf(91) != -1) {
            RuleExpression expr;
            Tokenizer tokenizer = new Tokenizer(value);
            if (tokenizer.isReference()) {
                VariableReferenceExpression.Builder builder = VariableReferenceExpression.builder();
                tokenizer.consumeReferenceAccess(builder::variableName);
                expr = builder.build();
                if (tokenizer.atEof()) {
                    return expr;
                }
            } else if (tokenizer.isNamedAccess()) {
                MemberAccessExpression.Builder builder = MemberAccessExpression.builder();
                tokenizer.consumeNamedAccess((source, name) -> builder.source(new VariableReferenceExpression((String)source)).name((String)name));
                expr = builder.build();
                if (tokenizer.atEof()) {
                    return expr;
                }
            } else {
                if (tokenizer.isIndexedAccess()) {
                    IndexedAccessExpression.Builder indexedAccessBuilder = IndexedAccessExpression.builder();
                    tokenizer.consumeIndexed((n, i) -> indexedAccessBuilder.source(new VariableReferenceExpression((String)n)).index((int)i));
                    tokenizer.expectAtEof("indexed access");
                    return indexedAccessBuilder.build();
                }
                expr = new LiteralStringExpression(tokenizer.next().value());
            }
            return ExpressionParser.parseStringConcat(tokenizer, expr);
        }
        return new LiteralStringExpression(value);
    }

    private static EndpointExpression parseEndpointExpression(EndpointModel model) {
        return EndpointExpression.builder().url(ExpressionParser.parseExpressionFrom(model.getUrl())).properties(ExpressionParser.parsePropertiesExpression(model.getProperties())).headers(ExpressionParser.parseHeadersExpression(model.getHeaders())).build();
    }

    private static HeadersExpression parseHeadersExpression(Map<String, List<TreeNode>> headers) {
        HeadersExpression.Builder builder = HeadersExpression.builder();
        if (headers != null) {
            headers.forEach((k, v) -> {
                ListExpression.Builder valueBuilder = ListExpression.builder();
                for (TreeNode node : v) {
                    valueBuilder.addExpression(ExpressionParser.parseExpressionFrom(node));
                }
                builder.putHeader((String)k, valueBuilder.build());
            });
        }
        return builder.build();
    }

    private static PropertiesExpression parsePropertiesExpression(Map<String, TreeNode> properties) {
        PropertiesExpression.Builder builder = PropertiesExpression.builder();
        if (properties != null) {
            properties.forEach((k, v) -> builder.putProperty((String)k, ExpressionParser.parseExpressionFrom(v)));
        }
        return builder.build();
    }

    private static RuleExpression parseStringConcat(Tokenizer tokenizer, RuleExpression expr) {
        StringConcatExpression.Builder concatBuilder = StringConcatExpression.builder();
        concatBuilder.addExpression(expr);
        while (!tokenizer.atEof()) {
            Object builder;
            if (tokenizer.isReference()) {
                builder = VariableReferenceExpression.builder();
                tokenizer.consumeReferenceAccess(((VariableReferenceExpression.Builder)builder)::variableName);
                concatBuilder.addExpression(((VariableReferenceExpression.Builder)builder).build());
                continue;
            }
            if (tokenizer.isNamedAccess()) {
                builder = MemberAccessExpression.builder();
                tokenizer.consumeNamedAccess((arg_0, arg_1) -> ExpressionParser.lambda$parseStringConcat$4((MemberAccessExpression.Builder)builder, arg_0, arg_1));
                concatBuilder.addExpression(((MemberAccessExpression.Builder)builder).build());
                continue;
            }
            concatBuilder.addExpression(new LiteralStringExpression(tokenizer.next().value()));
        }
        return concatBuilder.build();
    }

    private static List<TreeNode> nodeArrayToList(TreeNode argv) {
        if (!argv.isArray()) {
            throw new IllegalArgumentException("expecting tree node array, got instead: " + argv.asToken());
        }
        JrsArray array = (JrsArray)argv;
        ArrayList<TreeNode> result = new ArrayList<TreeNode>(array.size());
        for (int idx = 0; idx < array.size(); ++idx) {
            result.add((TreeNode)array.get(idx));
        }
        return result;
    }

    private static RuleExpression getFunctionCallExpression(String fn, List<TreeNode> argv) {
        if ("getAttr".equals(fn)) {
            return ExpressionParser.getAttrExpression(argv);
        }
        FunctionCallExpression.Builder builder = FunctionCallExpression.builder().name(fn);
        for (TreeNode node : argv) {
            builder.addArgument(ExpressionParser.parseExpressionFrom(node));
        }
        return builder.build();
    }

    private static RuleExpression getAttrExpression(List<TreeNode> argv) {
        if (argv.size() != 2) {
            throw new IllegalArgumentException("getAttr expects two arguments");
        }
        TreeNode argv0 = argv.get(0);
        TreeNode argv1 = argv.get(1);
        RuleExpression variable = ExpressionParser.getReference(argv0);
        TreeNode nameNode = argv1;
        if (!(nameNode instanceof JrsString)) {
            throw new IllegalArgumentException("expecting node to be string, got instead starting token: " + nameNode.asToken());
        }
        MemberAccessExpression.Builder memberAccessBuilder = MemberAccessExpression.builder().source(variable);
        JrsString value = (JrsString)nameNode;
        Tokenizer tokenizer = new Tokenizer(value.getValue());
        if (tokenizer.isIndexedAccess()) {
            IndexedAccessExpression.Builder indexedAccessBuilder = IndexedAccessExpression.builder();
            tokenizer.consumeIndexed((n, i) -> indexedAccessBuilder.source(memberAccessBuilder.name((String)n).build()).index((int)i));
            tokenizer.expectAtEof("indexed access");
            return indexedAccessBuilder.build();
        }
        if (tokenizer.isDirectIndexedAccess()) {
            IndexedAccessExpression.Builder indexedAccessBuilder = IndexedAccessExpression.builder();
            tokenizer.consumeDirectIndexed(i -> indexedAccessBuilder.source(memberAccessBuilder.directIndex(true).build()).index((int)i).build());
            tokenizer.expectAtEof("indexed access");
            return indexedAccessBuilder.build();
        }
        if (tokenizer.isIdentifier()) {
            tokenizer.consumeIdentifier(memberAccessBuilder::name);
            tokenizer.expectAtEof("member access");
            return memberAccessBuilder.build();
        }
        throw new IllegalArgumentException(String.format("Unexpected token parsing the second argument of getAttr expression: %s", tokenizer.peek()));
    }

    private static RuleExpression getReference(TreeNode node) {
        if (!node.isObject()) {
            throw new IllegalArgumentException("expecting reference object, got instead: " + node);
        }
        JrsObject obj = (JrsObject)node;
        String reference = obj.get("ref").asText();
        return new VariableReferenceExpression(reference);
    }

    public static PropertiesExpression parsePropertiesExpression(JrsObject object) {
        PropertiesExpression.Builder builder = PropertiesExpression.builder();
        Iterator fieldsIterator = object.fieldNames();
        while (fieldsIterator.hasNext()) {
            String name = (String)fieldsIterator.next();
            builder.putProperty(name, ExpressionParser.parseExpressionFrom((TreeNode)object.get(name)));
        }
        return builder.build();
    }

    private static /* synthetic */ void lambda$parseStringConcat$4(MemberAccessExpression.Builder builder, String source, String name) {
        builder.source(new VariableReferenceExpression(source)).name(name);
    }
}

