/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.codegen.poet.rules2;

import java.util.Objects;
import software.amazon.awssdk.codegen.poet.rules2.RuleExpression;
import software.amazon.awssdk.codegen.poet.rules2.RuleExpressionVisitor;
import software.amazon.awssdk.codegen.poet.rules2.RuleType;
import software.amazon.awssdk.utils.Validate;

public final class IndexedAccessExpression
implements RuleExpression {
    private final RuleType type;
    private final RuleExpression source;
    private final int index;

    IndexedAccessExpression(Builder builder) {
        this.type = builder.type;
        this.source = (RuleExpression)Validate.paramNotNull((Object)builder.source, (String)"source");
        this.index = (Integer)Validate.paramNotNull((Object)builder.index, (String)"index");
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public RuleExpression.RuleExpressionKind kind() {
        return RuleExpression.RuleExpressionKind.INDEXED_MEMBER_ACCESS;
    }

    @Override
    public StringBuilder appendTo(StringBuilder buf) {
        if (this.type == null) {
            buf.append("^UNDEFINED ");
        } else {
            buf.append("^").append(this.type).append(" ");
        }
        buf.append("(get-indexed ");
        this.source.appendTo(buf);
        return buf.append(" ").append(this.index).append(")");
    }

    @Override
    public <T> T accept(RuleExpressionVisitor<T> visitor) {
        return visitor.visitIndexedAccessExpression(this);
    }

    public RuleExpression source() {
        return this.source;
    }

    public int index() {
        return this.index;
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    @Override
    public RuleType type() {
        return this.type;
    }

    public String toString() {
        return this.appendTo(new StringBuilder()).toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IndexedAccessExpression that = (IndexedAccessExpression)o;
        if (this.index != that.index) {
            return false;
        }
        if (!Objects.equals(this.type, that.type)) {
            return false;
        }
        return this.source.equals(that.source);
    }

    public int hashCode() {
        int result = this.type != null ? this.type.hashCode() : 0;
        result = 31 * result + this.source.hashCode();
        result = 31 * result + this.index;
        return result;
    }

    public static class Builder {
        private RuleType type;
        private RuleExpression source;
        private Integer index;

        private Builder() {
        }

        private Builder(IndexedAccessExpression expr) {
            this.type = expr.type;
            this.source = expr.source;
            this.index = expr.index;
        }

        public Builder source(RuleExpression source) {
            this.source = source;
            return this;
        }

        public Builder index(int index) {
            this.index = index;
            return this;
        }

        public Builder type(RuleType type) {
            this.type = type;
            return this;
        }

        public IndexedAccessExpression build() {
            return new IndexedAccessExpression(this);
        }
    }
}

