/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.codegen.poet.waiters;

import com.fasterxml.jackson.jr.stree.JrsBoolean;
import com.fasterxml.jackson.jr.stree.JrsString;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.FieldSpec;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import com.squareup.javapoet.TypeVariableName;
import com.squareup.javapoet.WildcardTypeName;
import java.lang.reflect.Type;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.lang.model.element.Modifier;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.codegen.model.intermediate.IntermediateModel;
import software.amazon.awssdk.codegen.model.intermediate.OperationModel;
import software.amazon.awssdk.codegen.model.service.Acceptor;
import software.amazon.awssdk.codegen.model.service.WaiterDefinition;
import software.amazon.awssdk.codegen.poet.ClassSpec;
import software.amazon.awssdk.codegen.poet.PoetExtension;
import software.amazon.awssdk.codegen.poet.PoetUtils;
import software.amazon.awssdk.codegen.poet.waiters.JmesPathAcceptorGenerator;
import software.amazon.awssdk.core.ApiName;
import software.amazon.awssdk.core.internal.waiters.WaiterAttribute;
import software.amazon.awssdk.core.retry.backoff.BackoffStrategy;
import software.amazon.awssdk.core.retry.backoff.FixedDelayBackoffStrategy;
import software.amazon.awssdk.core.waiters.WaiterAcceptor;
import software.amazon.awssdk.core.waiters.WaiterOverrideConfiguration;
import software.amazon.awssdk.core.waiters.WaiterState;
import software.amazon.awssdk.utils.AttributeMap;
import software.amazon.awssdk.utils.SdkAutoCloseable;
import software.amazon.awssdk.utils.internal.CodegenNamingUtils;

public abstract class BaseWaiterClassSpec
implements ClassSpec {
    public static final String FAILURE_MESSAGE_FORMAT_FOR_PATH_MATCHER = "A waiter acceptor with the matcher (%s) was matched on parameter (%s=%s) and transitioned the waiter to failure state";
    public static final String FAILURE_MESSAGE_FORMAT_FOR_ERROR_MATCHER = "A waiter acceptor was matched on error condition (%s) and transitioned the waiter to failure state";
    private static final String WAITERS_USER_AGENT = "waiter";
    private final IntermediateModel model;
    private final String modelPackage;
    private final Map<String, WaiterDefinition> waiters;
    private final ClassName waiterClassName;
    private final JmesPathAcceptorGenerator jmesPathAcceptorGenerator;
    private final PoetExtension poetExtensions;

    public BaseWaiterClassSpec(IntermediateModel model, ClassName waiterClassName) {
        this.model = model;
        this.modelPackage = model.getMetadata().getFullModelPackageName();
        this.waiters = model.getWaiters();
        this.waiterClassName = waiterClassName;
        this.poetExtensions = new PoetExtension(model);
        this.jmesPathAcceptorGenerator = new JmesPathAcceptorGenerator(this.poetExtensions.jmesPathRuntimeClass());
    }

    @Override
    public TypeSpec poetSpec() {
        TypeSpec.Builder typeSpecBuilder = PoetUtils.createClassBuilder(this.className());
        typeSpecBuilder.addAnnotation(SdkInternalApi.class);
        typeSpecBuilder.addAnnotation(ThreadSafe.class);
        typeSpecBuilder.addModifiers(new Modifier[]{Modifier.FINAL});
        typeSpecBuilder.addSuperinterface((TypeName)this.interfaceClassName());
        typeSpecBuilder.addMethod(this.constructor());
        typeSpecBuilder.addField(FieldSpec.builder((TypeName)ParameterizedTypeName.get(WaiterAttribute.class, (Type[])new Type[]{SdkAutoCloseable.class}), (String)"CLIENT_ATTRIBUTE", (Modifier[])new Modifier[]{Modifier.PRIVATE, Modifier.STATIC, Modifier.FINAL}).initializer("new $T<>($T.class)", new Object[]{WaiterAttribute.class, SdkAutoCloseable.class}).build());
        typeSpecBuilder.addField((TypeName)this.clientClassName(), "client", new Modifier[]{Modifier.PRIVATE, Modifier.FINAL});
        typeSpecBuilder.addField((TypeName)ClassName.get(AttributeMap.class), "managedResources", new Modifier[]{Modifier.PRIVATE, Modifier.FINAL});
        typeSpecBuilder.addMethod(this.staticErrorCodeMethod());
        typeSpecBuilder.addMethods(this.waiterOperations());
        typeSpecBuilder.addMethods(this.waiterAcceptorInitializers());
        typeSpecBuilder.addMethods(this.waiterConfigInitializers());
        typeSpecBuilder.addFields(this.waitersFields());
        this.additionalTypeSpecModification(typeSpecBuilder);
        typeSpecBuilder.addMethod(this.closeMethod());
        typeSpecBuilder.addMethod(MethodSpec.methodBuilder((String)"builder").addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.STATIC}).returns((TypeName)this.interfaceClassName().nestedClass("Builder")).addStatement("return new DefaultBuilder()", new Object[0]).build());
        typeSpecBuilder.addType(this.builder());
        typeSpecBuilder.addMethod(BaseWaiterClassSpec.applyWaitersUserAgentMethod(this.poetExtensions, this.model));
        return typeSpecBuilder.build();
    }

    private MethodSpec closeMethod() {
        return MethodSpec.methodBuilder((String)"close").addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PUBLIC}).addStatement("managedResources.close()", new Object[0]).build();
    }

    protected abstract ClassName clientClassName();

    protected abstract TypeName getWaiterResponseType(OperationModel var1);

    protected abstract ClassName interfaceClassName();

    protected void additionalTypeSpecModification(TypeSpec.Builder type) {
    }

    protected void additionalConstructorInitialization(MethodSpec.Builder method) {
    }

    protected void additionalBuilderTypeSpecModification(TypeSpec.Builder builder) {
    }

    protected Optional<String> additionalWaiterConfig() {
        return Optional.empty();
    }

    private MethodSpec constructor() {
        MethodSpec.Builder ctor = MethodSpec.constructorBuilder().addModifiers(new Modifier[]{Modifier.PRIVATE}).addParameter((TypeName)this.className().nestedClass("DefaultBuilder"), "builder", new Modifier[0]);
        ctor.addStatement("$T attributeMapBuilder = $T.builder()", new Object[]{ClassName.get(AttributeMap.class).nestedClass("Builder"), AttributeMap.class});
        ctor.beginControlFlow("if (builder.client == null)", new Object[0]).addStatement("this.client = $T.builder().build()", new Object[]{this.clientClassName()}).addStatement("attributeMapBuilder.put(CLIENT_ATTRIBUTE, this.client)", new Object[0]).endControlFlow();
        ctor.beginControlFlow("else", new Object[0]).addStatement("this.client = builder.client", new Object[0]).endControlFlow();
        this.additionalConstructorInitialization(ctor);
        ctor.addStatement("managedResources = attributeMapBuilder.build()", new Object[0]);
        this.waiters.entrySet().stream().map(this::waiterFieldInitialization).forEach(arg_0 -> ((MethodSpec.Builder)ctor).addCode(arg_0));
        return ctor.build();
    }

    private List<MethodSpec> waiterConfigInitializers() {
        ArrayList<MethodSpec> initializers = new ArrayList<MethodSpec>();
        this.waiters.forEach((k, v) -> initializers.add(this.waiterConfigInitializer((String)k, (WaiterDefinition)v)));
        return initializers;
    }

    private MethodSpec waiterConfigInitializer(String waiterKey, WaiterDefinition waiterDefinition) {
        ClassName overrideConfig = ClassName.get(WaiterOverrideConfiguration.class);
        MethodSpec.Builder configMethod = MethodSpec.methodBuilder((String)(this.waiterFieldName(waiterKey) + "Config")).addModifiers(new Modifier[]{Modifier.PRIVATE, Modifier.STATIC}).addParameter((TypeName)overrideConfig, "overrideConfig", new Modifier[0]).returns((TypeName)overrideConfig);
        configMethod.addStatement("$T<$T> optionalOverrideConfig = Optional.ofNullable(overrideConfig)", new Object[]{Optional.class, WaiterOverrideConfiguration.class});
        configMethod.addStatement("int maxAttempts = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::maxAttempts).orElse($L)", new Object[]{waiterDefinition.getMaxAttempts()});
        configMethod.addStatement("$T backoffStrategy = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::backoffStrategy).orElse($T.create($T.ofSeconds($L)))", new Object[]{BackoffStrategy.class, FixedDelayBackoffStrategy.class, Duration.class, waiterDefinition.getDelay()});
        configMethod.addStatement("$T waitTimeout = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::waitTimeout).orElse(null)", new Object[]{Duration.class});
        configMethod.addStatement("return WaiterOverrideConfiguration.builder().maxAttempts(maxAttempts).backoffStrategy(backoffStrategy).waitTimeout(waitTimeout).build()", new Object[0]);
        return configMethod.build();
    }

    private CodeBlock waiterFieldInitialization(Map.Entry<String, WaiterDefinition> waiterDefinition) {
        String waiterKey = waiterDefinition.getKey();
        WaiterDefinition waiter = waiterDefinition.getValue();
        OperationModel opModel = this.operationModel(waiter);
        CodeBlock.Builder codeBlockBuilder = CodeBlock.builder();
        String waiterFieldName = this.waiterFieldName(waiterKey);
        codeBlockBuilder.add("this.$L = $T.builder($T.class).acceptors($LAcceptors()).overrideConfiguration($LConfig(builder.overrideConfiguration))", new Object[]{waiterFieldName, this.waiterClassName, ClassName.get((String)this.modelPackage, (String)opModel.getReturnType().getReturnType(), (String[])new String[0]), waiterFieldName, waiterFieldName});
        this.additionalWaiterConfig().ifPresent(x$0 -> codeBlockBuilder.add(x$0, new Object[0]));
        codeBlockBuilder.addStatement(".build()", new Object[0]);
        return codeBlockBuilder.build();
    }

    private List<FieldSpec> waitersFields() {
        return this.waiters.entrySet().stream().map(this::waiterField).collect(Collectors.toList());
    }

    private FieldSpec waiterField(Map.Entry<String, WaiterDefinition> waiterDefinition) {
        OperationModel opModel = this.operationModel(waiterDefinition.getValue());
        ClassName pojoResponse = ClassName.get((String)this.modelPackage, (String)opModel.getReturnType().getReturnType(), (String[])new String[0]);
        String fieldName = this.waiterFieldName(waiterDefinition.getKey());
        return FieldSpec.builder((TypeName)ParameterizedTypeName.get((ClassName)this.waiterClassName, (TypeName[])new TypeName[]{pojoResponse}), (String)fieldName, (Modifier[])new Modifier[0]).addModifiers(new Modifier[]{Modifier.PRIVATE, Modifier.FINAL}).build();
    }

    private TypeSpec builder() {
        TypeSpec.Builder builder = TypeSpec.classBuilder((String)"DefaultBuilder").addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.STATIC, Modifier.FINAL}).addSuperinterface((TypeName)this.interfaceClassName().nestedClass("Builder")).addField((TypeName)this.clientClassName(), "client", new Modifier[]{Modifier.PRIVATE}).addField((TypeName)ClassName.get(WaiterOverrideConfiguration.class), "overrideConfiguration", new Modifier[]{Modifier.PRIVATE});
        this.additionalBuilderTypeSpecModification(builder);
        builder.addMethods(this.builderMethods());
        builder.addMethod(MethodSpec.constructorBuilder().addModifiers(new Modifier[]{Modifier.PRIVATE}).build());
        return builder.build();
    }

    private List<MethodSpec> builderMethods() {
        ArrayList<MethodSpec> methods = new ArrayList<MethodSpec>();
        methods.add(MethodSpec.methodBuilder((String)"overrideConfiguration").addModifiers(new Modifier[]{Modifier.PUBLIC}).addAnnotation(Override.class).addParameter((TypeName)ClassName.get(WaiterOverrideConfiguration.class), "overrideConfiguration", new Modifier[0]).addStatement("this.overrideConfiguration = overrideConfiguration", new Object[0]).addStatement("return this", new Object[0]).returns((TypeName)this.interfaceClassName().nestedClass("Builder")).build());
        methods.add(MethodSpec.methodBuilder((String)"client").addModifiers(new Modifier[]{Modifier.PUBLIC}).addAnnotation(Override.class).addParameter((TypeName)this.clientClassName(), "client", new Modifier[0]).addStatement("this.client = client", new Object[0]).addStatement("return this", new Object[0]).returns((TypeName)this.interfaceClassName().nestedClass("Builder")).build());
        methods.add(MethodSpec.methodBuilder((String)"build").addModifiers(new Modifier[]{Modifier.PUBLIC}).returns((TypeName)this.interfaceClassName()).addStatement("return new $T(this)", new Object[]{this.className()}).build());
        return methods;
    }

    private List<MethodSpec> waiterOperations() {
        return this.waiters.entrySet().stream().flatMap(this::waiterOperations).sorted(Comparator.comparing(m -> m.name)).collect(Collectors.toList());
    }

    private Stream<MethodSpec> waiterOperations(Map.Entry<String, WaiterDefinition> waiterDefinition) {
        ArrayList<MethodSpec> methods = new ArrayList<MethodSpec>();
        methods.add(this.waiterOperation(waiterDefinition));
        methods.add(this.waiterOperationWithOverrideConfig(waiterDefinition));
        return methods.stream();
    }

    private MethodSpec waiterOperationWithOverrideConfig(Map.Entry<String, WaiterDefinition> waiterDefinition) {
        String waiterMethodName = waiterDefinition.getKey();
        OperationModel opModel = this.operationModel(waiterDefinition.getValue());
        ClassName overrideConfig = ClassName.get(WaiterOverrideConfiguration.class);
        ClassName requestType = ClassName.get((String)this.modelPackage, (String)opModel.getInput().getVariableType(), (String[])new String[0]);
        String waiterFieldName = this.waiterFieldName(waiterDefinition.getKey());
        MethodSpec.Builder builder = this.methodSignatureWithReturnType(waiterMethodName, opModel).addParameter((TypeName)requestType, opModel.getInput().getVariableName(), new Modifier[0]).addParameter((TypeName)overrideConfig, "overrideConfig", new Modifier[0]).addModifiers(new Modifier[]{Modifier.PUBLIC}).addAnnotation(Override.class).addStatement("return $L.$L(() -> client.$N(applyWaitersUserAgent($N)), $LConfig(overrideConfig))", new Object[]{waiterFieldName, this.waiterClassName.simpleName().equals("Waiter") ? "run" : "runAsync", CodegenNamingUtils.lowercaseFirstChar((String)waiterDefinition.getValue().getOperation()), opModel.getInput().getVariableName(), waiterFieldName});
        return builder.build();
    }

    private MethodSpec waiterOperation(Map.Entry<String, WaiterDefinition> waiterDefinition) {
        String waiterMethodName = waiterDefinition.getKey();
        OperationModel opModel = this.operationModel(waiterDefinition.getValue());
        ClassName requestType = ClassName.get((String)this.modelPackage, (String)opModel.getInput().getVariableType(), (String[])new String[0]);
        MethodSpec.Builder builder = this.methodSignatureWithReturnType(waiterMethodName, opModel).addParameter((TypeName)requestType, opModel.getInput().getVariableName(), new Modifier[0]).addModifiers(new Modifier[]{Modifier.PUBLIC}).addAnnotation(Override.class).addStatement("return $L.$L(() -> client.$N(applyWaitersUserAgent($N)))", new Object[]{this.waiterFieldName(waiterMethodName), this.waiterClassName.simpleName().equals("Waiter") ? "run" : "runAsync", CodegenNamingUtils.lowercaseFirstChar((String)waiterDefinition.getValue().getOperation()), opModel.getInput().getVariableName()});
        return builder.build();
    }

    private List<MethodSpec> waiterAcceptorInitializers() {
        ArrayList<MethodSpec> initializers = new ArrayList<MethodSpec>();
        this.waiters.forEach((k, v) -> initializers.add(this.acceptorInitializer((String)k, (WaiterDefinition)v)));
        return initializers;
    }

    private MethodSpec acceptorInitializer(String waiterKey, WaiterDefinition waiterDefinition) {
        MethodSpec.Builder acceptorsMethod = MethodSpec.methodBuilder((String)(this.waiterFieldName(waiterKey) + "Acceptors")).addModifiers(new Modifier[]{Modifier.PRIVATE, Modifier.STATIC}).returns(this.waiterAcceptorTypeName(waiterDefinition));
        acceptorsMethod.addStatement("$T result = new $T<>()", new Object[]{this.waiterAcceptorTypeName(waiterDefinition), ArrayList.class});
        for (Acceptor acceptor : waiterDefinition.getAcceptors()) {
            acceptorsMethod.addCode("result.add(", new Object[0]).addCode(this.acceptor(acceptor)).addCode(");", new Object[0]);
        }
        acceptorsMethod.addStatement("result.addAll($T.DEFAULT_ACCEPTORS)", new Object[]{this.poetExtensions.waitersRuntimeClass()});
        acceptorsMethod.addStatement("return result", new Object[0]);
        return acceptorsMethod.build();
    }

    protected String waiterFieldName(String waiterKey) {
        return CodegenNamingUtils.lowercaseFirstChar((String)waiterKey) + "Waiter";
    }

    private OperationModel operationModel(WaiterDefinition waiterDefinition) {
        return this.model.getOperation(waiterDefinition.getOperation());
    }

    private MethodSpec.Builder methodSignatureWithReturnType(String waiterMethodName, OperationModel opModel) {
        return MethodSpec.methodBuilder((String)this.getWaiterMethodName(waiterMethodName)).returns(this.getWaiterResponseType(opModel));
    }

    static MethodSpec applyWaitersUserAgentMethod(PoetExtension poetExtensions, IntermediateModel model) {
        TypeVariableName typeVariableName = TypeVariableName.get((String)"T", (TypeName[])new TypeName[]{poetExtensions.getModelClass(model.getSdkRequestBaseClassName())});
        ParameterizedTypeName parameterizedTypeName = ParameterizedTypeName.get((ClassName)ClassName.get(Consumer.class), (TypeName[])new TypeName[]{ClassName.get(AwsRequestOverrideConfiguration.Builder.class)});
        CodeBlock codeBlock = CodeBlock.builder().addStatement("$T userAgentApplier = b -> b.addApiName($T.builder().version($S).name($S).build())", new Object[]{parameterizedTypeName, ApiName.class, WAITERS_USER_AGENT, "hll"}).addStatement("$T overrideConfiguration =\n            request.overrideConfiguration().map(c -> c.toBuilder().applyMutation(userAgentApplier).build())\n            .orElse((AwsRequestOverrideConfiguration.builder().applyMutation(userAgentApplier).build()))", new Object[]{AwsRequestOverrideConfiguration.class}).addStatement("return (T) request.toBuilder().overrideConfiguration(overrideConfiguration).build()", new Object[0]).build();
        return MethodSpec.methodBuilder((String)"applyWaitersUserAgent").addModifiers(new Modifier[]{Modifier.PRIVATE}).addParameter((TypeName)typeVariableName, "request", new Modifier[0]).addTypeVariable(typeVariableName).addCode(codeBlock).returns((TypeName)typeVariableName).build();
    }

    private String getWaiterMethodName(String waiterMethodName) {
        return "waitUntil" + waiterMethodName;
    }

    private TypeName waiterAcceptorTypeName(WaiterDefinition waiterDefinition) {
        WildcardTypeName wildcardTypeName = WildcardTypeName.supertypeOf((TypeName)this.fullyQualifiedResponseType(waiterDefinition));
        return ParameterizedTypeName.get((ClassName)ClassName.get(List.class), (TypeName[])new TypeName[]{ParameterizedTypeName.get((ClassName)ClassName.get(WaiterAcceptor.class), (TypeName[])new TypeName[]{wildcardTypeName})});
    }

    private TypeName fullyQualifiedResponseType(WaiterDefinition waiterDefinition) {
        String modelPackage = this.model.getMetadata().getFullModelPackageName();
        String operationResponseType = this.model.getOperation(waiterDefinition.getOperation()).getReturnType().getReturnType();
        return ClassName.get((String)modelPackage, (String)operationResponseType, (String[])new String[0]);
    }

    private CodeBlock acceptor(Acceptor acceptor) {
        CodeBlock.Builder result = CodeBlock.builder();
        switch (acceptor.getState()) {
            case "success": {
                result.add("$T.success", new Object[]{WaiterAcceptor.class});
                break;
            }
            case "failure": {
                result.add("$T.error", new Object[]{WaiterAcceptor.class});
                break;
            }
            case "retry": {
                result.add("$T.retry", new Object[]{WaiterAcceptor.class});
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported acceptor state: " + acceptor.getState());
            }
        }
        switch (acceptor.getMatcher()) {
            case "path": {
                result.add("OnResponseAcceptor(", new Object[0]);
                result.add(this.pathAcceptorBody(acceptor));
                this.addFailureMessageForPathMatcher(acceptor, result);
                result.add(")", new Object[0]);
                break;
            }
            case "pathAll": {
                result.add("OnResponseAcceptor(", new Object[0]);
                result.add(this.pathAllAcceptorBody(acceptor));
                this.addFailureMessageForPathMatcher(acceptor, result);
                result.add(")", new Object[0]);
                break;
            }
            case "pathAny": {
                result.add("OnResponseAcceptor(", new Object[0]);
                result.add(this.pathAnyAcceptorBody(acceptor));
                this.addFailureMessageForPathMatcher(acceptor, result);
                result.add(")", new Object[0]);
                break;
            }
            case "status": {
                int expected = Integer.parseInt(acceptor.getExpected().asText());
                return CodeBlock.of((String)"new $T($L, $T.$L)", (Object[])new Object[]{this.poetExtensions.waitersRuntimeClass().nestedClass("ResponseStatusAcceptor"), expected, WaiterState.class, this.waiterState(acceptor)});
            }
            case "error": {
                if (acceptor.getExpected() instanceof JrsBoolean) {
                    result.add(this.booleanValueErrorBlock(acceptor, Boolean.parseBoolean(acceptor.getExpected().asText())).build());
                    break;
                }
                result.add("OnExceptionAcceptor(", new Object[0]);
                result.add(this.errorAcceptorBody(acceptor));
                this.addAcceptorFailureMessage(result, acceptor, () -> String.format(FAILURE_MESSAGE_FORMAT_FOR_ERROR_MATCHER, BaseWaiterClassSpec.expectedValue(acceptor)));
                result.add(")", new Object[0]);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported acceptor matcher: " + acceptor.getMatcher());
            }
        }
        return result.build();
    }

    private void addFailureMessageForPathMatcher(Acceptor acceptor, CodeBlock.Builder result) {
        this.addAcceptorFailureMessage(result, acceptor, () -> String.format(FAILURE_MESSAGE_FORMAT_FOR_PATH_MATCHER, acceptor.getMatcher(), acceptor.getArgument(), BaseWaiterClassSpec.expectedValue(acceptor)));
    }

    private void addAcceptorFailureMessage(CodeBlock.Builder result, Acceptor acceptor, Supplier<String> messageSupplier) {
        if ("failure".equals(acceptor.getState())) {
            result.add(", ", new Object[0]);
            result.add("$S", new Object[]{messageSupplier.get()});
        }
    }

    private static String expectedValue(Acceptor acceptor) {
        return acceptor.getExpected() instanceof JrsBoolean ? String.valueOf(((JrsBoolean)acceptor.getExpected()).booleanValue()) : acceptor.getExpected().asText();
    }

    private CodeBlock.Builder booleanValueErrorBlock(Acceptor acceptor, Boolean expectedBoolean) {
        CodeBlock.Builder codeBlock = CodeBlock.builder();
        if (Boolean.FALSE.equals(expectedBoolean)) {
            codeBlock.add("OnResponseAcceptor(", new Object[0]);
            codeBlock.add(this.trueForAllResponse());
        } else {
            codeBlock.add("OnExceptionAcceptor(", new Object[0]);
            codeBlock.add("error -> errorCode(error) != null", new Object[0]);
        }
        this.addAcceptorFailureMessage(codeBlock, acceptor, () -> String.format(FAILURE_MESSAGE_FORMAT_FOR_ERROR_MATCHER, BaseWaiterClassSpec.expectedValue(acceptor)));
        codeBlock.add(")", new Object[0]);
        return codeBlock;
    }

    private String waiterState(Acceptor acceptor) {
        switch (acceptor.getState()) {
            case "success": {
                return WaiterState.SUCCESS.name();
            }
            case "failure": {
                return WaiterState.FAILURE.name();
            }
            case "retry": {
                return WaiterState.RETRY.name();
            }
        }
        throw new IllegalArgumentException("Unsupported acceptor state: " + acceptor.getState());
    }

    private CodeBlock pathAcceptorBody(Acceptor acceptor) {
        String expected = acceptor.getExpected().asText();
        String expectedType = acceptor.getExpected() instanceof JrsString ? "$S" : "$L";
        return CodeBlock.builder().add("response -> {", new Object[0]).add("$1T input = new $1T(response);", new Object[]{this.poetExtensions.jmesPathRuntimeClass().nestedClass("Value")}).add("return $T.equals(", new Object[]{Objects.class}).add(this.jmesPathAcceptorGenerator.interpret(acceptor.getArgument(), "input")).add(".value(), " + expectedType + ");", new Object[]{expected}).add("}", new Object[0]).build();
    }

    private CodeBlock pathAllAcceptorBody(Acceptor acceptor) {
        String expected = acceptor.getExpected().asText();
        String expectedType = acceptor.getExpected() instanceof JrsString ? "$S" : "$L";
        return CodeBlock.builder().add("response -> {", new Object[0]).add("$1T input = new $1T(response);", new Object[]{this.poetExtensions.jmesPathRuntimeClass().nestedClass("Value")}).add("$T<$T> resultValues = ", new Object[]{List.class, Object.class}).add(this.jmesPathAcceptorGenerator.interpret(acceptor.getArgument(), "input")).add(".values();", new Object[0]).add("return !resultValues.isEmpty() && resultValues.stream().allMatch(v -> $T.equals(v, " + expectedType + "));", new Object[]{Objects.class, expected}).add("}", new Object[0]).build();
    }

    private CodeBlock pathAnyAcceptorBody(Acceptor acceptor) {
        String expected = acceptor.getExpected().asText();
        String expectedType = acceptor.getExpected() instanceof JrsString ? "$S" : "$L";
        return CodeBlock.builder().add("response -> {", new Object[0]).add("$1T input = new $1T(response);", new Object[]{this.poetExtensions.jmesPathRuntimeClass().nestedClass("Value")}).add("$T<$T> resultValues = ", new Object[]{List.class, Object.class}).add(this.jmesPathAcceptorGenerator.interpret(acceptor.getArgument(), "input")).add(".values();", new Object[0]).add("return !resultValues.isEmpty() && resultValues.stream().anyMatch(v -> $T.equals(v, " + expectedType + "));", new Object[]{Objects.class, expected}).add("}", new Object[0]).build();
    }

    private CodeBlock trueForAllResponse() {
        return CodeBlock.builder().add("response -> true", new Object[0]).build();
    }

    private CodeBlock errorAcceptorBody(Acceptor acceptor) {
        String expected = acceptor.getExpected().asText();
        String expectedType = acceptor.getExpected() instanceof JrsString ? "$S" : "$L";
        return CodeBlock.of((String)("error -> $T.equals(errorCode(error), " + expectedType + ")"), (Object[])new Object[]{Objects.class, expected});
    }

    private MethodSpec staticErrorCodeMethod() {
        return MethodSpec.methodBuilder((String)"errorCode").addModifiers(new Modifier[]{Modifier.PRIVATE, Modifier.STATIC}).returns(String.class).addParameter(Throwable.class, "error", new Modifier[0]).addCode("if (error instanceof $T) {", new Object[]{AwsServiceException.class}).addCode("return (($T) error).awsErrorDetails().errorCode();", new Object[]{AwsServiceException.class}).addCode("}", new Object[0]).addCode("return null;", new Object[0]).build();
    }
}

