/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.codegen.poet.rules;

import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeVariableName;
import java.lang.reflect.Type;
import java.util.EnumMap;
import java.util.Map;
import java.util.Optional;
import javax.lang.model.element.Modifier;
import software.amazon.awssdk.awscore.client.config.AwsClientOption;
import software.amazon.awssdk.awscore.endpoints.AccountIdEndpointMode;
import software.amazon.awssdk.awscore.endpoints.AccountIdEndpointModeResolver;
import software.amazon.awssdk.codegen.internal.Utils;
import software.amazon.awssdk.codegen.model.intermediate.IntermediateModel;
import software.amazon.awssdk.codegen.model.internal.LocalParameter;
import software.amazon.awssdk.codegen.model.rules.endpoints.BuiltInParameter;
import software.amazon.awssdk.codegen.model.rules.endpoints.ParameterModel;
import software.amazon.awssdk.core.SelectedAuthScheme;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.identity.spi.AwsCredentialsIdentity;
import software.amazon.awssdk.identity.spi.Identity;
import software.amazon.awssdk.utils.CompletableFutureUtils;
import software.amazon.awssdk.utils.internal.CodegenNamingUtils;

public final class EndpointParamsKnowledgeIndex {
    private static final Map<BuiltInParameter, LocalParameter> BUILT_IN_PARAMS_FOR_CLIENT_BUILDER = new EnumMap<BuiltInParameter, LocalParameter>(BuiltInParameter.class);
    private final IntermediateModel intermediateModel;
    private Map<BuiltInParameter, LocalParameter> parametersToGenerate = new EnumMap<BuiltInParameter, LocalParameter>(BuiltInParameter.class);

    private EndpointParamsKnowledgeIndex(IntermediateModel intermediateModel) {
        this.intermediateModel = intermediateModel;
        this.parametersToGenerate = this.builtInsForClientBuilder(intermediateModel.getEndpointRuleSetModel().getParameters());
    }

    public static EndpointParamsKnowledgeIndex of(IntermediateModel intermediateModel) {
        return new EndpointParamsKnowledgeIndex(intermediateModel);
    }

    public boolean hasAccountIdEndpointModeBuiltIn() {
        return this.parametersToGenerate.containsKey((Object)BuiltInParameter.AWS_AUTH_ACCOUNT_ID_ENDPOINT_MODE);
    }

    public Optional<MethodSpec> accountIdEndpointModeClassMethodSpec() {
        if (this.hasAccountIdEndpointModeBuiltIn()) {
            return Optional.of(this.clientClassBuilderParamSetter(this.accountIdEndpointModeBuiltInParam()));
        }
        return Optional.empty();
    }

    public Optional<MethodSpec> accountIdEndpointModeInterfaceMethodSpec() {
        if (this.hasAccountIdEndpointModeBuiltIn()) {
            return Optional.of(this.clientInterfaceBuilderParamSetter(this.accountIdEndpointModeBuiltInParam()));
        }
        return Optional.empty();
    }

    private LocalParameter accountIdEndpointModeBuiltInParam() {
        return this.parametersToGenerate.get((Object)BuiltInParameter.AWS_AUTH_ACCOUNT_ID_ENDPOINT_MODE);
    }

    private MethodSpec clientClassBuilderParamSetter(LocalParameter param) {
        String setterName = Utils.unCapitalize(CodegenNamingUtils.pascalCase((String)param.name()));
        String keyName = this.intermediateModel.getNamingStrategy().getEnumValueName(param.name());
        TypeName type = TypeName.get(param.type());
        return MethodSpec.methodBuilder((String)setterName).addModifiers(new Modifier[]{Modifier.PUBLIC}).returns((TypeName)TypeVariableName.get((String)"B")).addParameter(type, setterName, new Modifier[0]).addStatement("clientConfiguration.option($T.$L, $L)", new Object[]{AwsClientOption.class, keyName, setterName}).addStatement("return thisBuilder()", new Object[0]).build();
    }

    private MethodSpec clientInterfaceBuilderParamSetter(LocalParameter param) {
        String setterName = Utils.unCapitalize(CodegenNamingUtils.pascalCase((String)param.name()));
        TypeName type = TypeName.get(param.type());
        MethodSpec.Builder b = MethodSpec.methodBuilder((String)setterName).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.ABSTRACT}).addParameter(type, setterName, new Modifier[0]).addJavadoc(param.documentation()).returns((TypeName)TypeVariableName.get((String)"B"));
        return b.build();
    }

    public Optional<MethodSpec> resolveAccountIdEndpointModeMethod() {
        if (!this.hasAccountIdEndpointModeBuiltIn()) {
            return Optional.empty();
        }
        String name = "accountIdEndpointMode";
        String keyName = this.intermediateModel.getNamingStrategy().getEnumValueName(name);
        TypeName typeName = TypeName.get(AccountIdEndpointMode.class);
        MethodSpec.Builder builder = MethodSpec.methodBuilder((String)"resolveAccountIdEndpointMode").addModifiers(new Modifier[]{Modifier.PRIVATE}).addParameter(SdkClientConfiguration.class, "config", new Modifier[0]).returns(typeName);
        builder.addStatement("$T configuredMode = config.option($T.$L)", new Object[]{typeName, AwsClientOption.class, keyName});
        builder.beginControlFlow("if (configuredMode == null)", new Object[0]);
        builder.addCode("configuredMode = $T.create()", new Object[]{AccountIdEndpointModeResolver.class});
        builder.addCode(".profileFile(config.option($T.PROFILE_FILE_SUPPLIER))", new Object[]{SdkClientOption.class});
        builder.addCode(".profileName(config.option($T.PROFILE_NAME))", new Object[]{SdkClientOption.class});
        builder.addCode(".defaultMode($T.PREFERRED)", new Object[]{typeName});
        builder.addStatement(".resolve()", new Object[0]);
        builder.endControlFlow();
        builder.addStatement("return configuredMode", new Object[0]);
        return Optional.of(builder.build());
    }

    private Map<BuiltInParameter, LocalParameter> builtInsForClientBuilder(Map<String, ParameterModel> serviceEndpointParams) {
        EnumMap<BuiltInParameter, LocalParameter> actualParams = new EnumMap<BuiltInParameter, LocalParameter>(BuiltInParameter.class);
        serviceEndpointParams.forEach((k, v) -> {
            BuiltInParameter builtInEnum = v.getBuiltInEnum();
            if (builtInEnum != null && BUILT_IN_PARAMS_FOR_CLIENT_BUILDER.containsKey((Object)builtInEnum)) {
                actualParams.put(builtInEnum, BUILT_IN_PARAMS_FOR_CLIENT_BUILDER.get((Object)builtInEnum));
            }
        });
        return actualParams;
    }

    public Optional<MethodSpec> accountIdFromIdentityMethod() {
        if (!this.hasAccountIdEndpointModeBuiltIn()) {
            return Optional.empty();
        }
        ParameterizedTypeName paramType = ParameterizedTypeName.get((ClassName)ClassName.get(SelectedAuthScheme.class), (TypeName[])new TypeName[]{TypeVariableName.get((String)"T")});
        MethodSpec.Builder builder = MethodSpec.methodBuilder((String)"accountIdFromIdentity").addModifiers(new Modifier[]{Modifier.PRIVATE, Modifier.STATIC}).addTypeVariable(TypeVariableName.get((String)"T", (Type[])new Type[]{Identity.class})).addParameter((TypeName)paramType, "selectedAuthScheme", new Modifier[0]).returns(String.class);
        builder.addStatement("$T identity = $T.joinLikeSync(selectedAuthScheme.identity())", new Object[]{TypeVariableName.get((String)"T"), CompletableFutureUtils.class});
        builder.addStatement("$T accountId = null", new Object[]{String.class});
        builder.beginControlFlow("if (identity instanceof $T)", new Object[]{AwsCredentialsIdentity.class});
        builder.addStatement("accountId = (($T) identity).accountId().orElse(null)", new Object[]{AwsCredentialsIdentity.class});
        builder.endControlFlow();
        builder.addStatement("return accountId", new Object[0]);
        return Optional.of(builder.build());
    }

    static {
        BUILT_IN_PARAMS_FOR_CLIENT_BUILDER.put(BuiltInParameter.AWS_AUTH_ACCOUNT_ID_ENDPOINT_MODE, new LocalParameter("accountIdEndpointMode", AccountIdEndpointMode.class, CodeBlock.of((String)"Sets the behavior when account ID based endpoints are created. See {@link $T} for values", (Object[])new Object[]{AccountIdEndpointMode.class})));
    }
}

