/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.codegen.poet.builder;

import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import com.squareup.javapoet.WildcardTypeName;
import javax.lang.model.element.Modifier;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.config.AwsClientOption;
import software.amazon.awssdk.codegen.model.intermediate.IntermediateModel;
import software.amazon.awssdk.codegen.poet.ClassSpec;
import software.amazon.awssdk.codegen.poet.PoetUtils;
import software.amazon.awssdk.codegen.poet.rules.EndpointRulesSpecUtils;
import software.amazon.awssdk.codegen.utils.AuthUtils;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.identity.spi.IdentityProvider;
import software.amazon.awssdk.identity.spi.TokenIdentity;

public class SyncClientBuilderClass
implements ClassSpec {
    private final IntermediateModel model;
    private final ClassName clientInterfaceName;
    private final ClassName clientClassName;
    private final ClassName builderInterfaceName;
    private final ClassName builderClassName;
    private final ClassName builderBaseClassName;
    private final EndpointRulesSpecUtils endpointRulesSpecUtils;

    public SyncClientBuilderClass(IntermediateModel model) {
        String basePackage = model.getMetadata().getFullClientPackageName();
        this.model = model;
        this.clientInterfaceName = ClassName.get((String)basePackage, (String)model.getMetadata().getSyncInterface(), (String[])new String[0]);
        this.clientClassName = ClassName.get((String)basePackage, (String)model.getMetadata().getSyncClient(), (String[])new String[0]);
        this.builderInterfaceName = ClassName.get((String)basePackage, (String)model.getMetadata().getSyncBuilderInterface(), (String[])new String[0]);
        this.builderClassName = ClassName.get((String)basePackage, (String)model.getMetadata().getSyncBuilder(), (String[])new String[0]);
        this.builderBaseClassName = ClassName.get((String)basePackage, (String)model.getMetadata().getBaseBuilder(), (String[])new String[0]);
        this.endpointRulesSpecUtils = new EndpointRulesSpecUtils(model);
    }

    @Override
    public TypeSpec poetSpec() {
        TypeSpec.Builder builder = PoetUtils.createClassBuilder(this.builderClassName).addAnnotation(SdkInternalApi.class).addModifiers(new Modifier[]{Modifier.FINAL}).superclass((TypeName)ParameterizedTypeName.get((ClassName)this.builderBaseClassName, (TypeName[])new TypeName[]{this.builderInterfaceName, this.clientInterfaceName})).addSuperinterface((TypeName)this.builderInterfaceName).addJavadoc("Internal implementation of {@link $T}.", new Object[]{this.builderInterfaceName});
        if (this.model.getEndpointOperation().isPresent()) {
            builder.addMethod(this.endpointDiscoveryEnabled());
            if (this.model.getCustomizationConfig().isEnableEndpointDiscoveryMethodRequired()) {
                builder.addMethod(this.enableEndpointDiscovery());
            }
        }
        builder.addMethod(this.endpointProviderMethod());
        if (AuthUtils.usesBearerAuth(this.model)) {
            builder.addMethod(this.tokenProviderMethodImpl());
        }
        builder.addMethod(this.buildClientMethod());
        return builder.build();
    }

    private MethodSpec endpointDiscoveryEnabled() {
        return MethodSpec.methodBuilder((String)"endpointDiscoveryEnabled").addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PUBLIC}).returns((TypeName)this.builderClassName).addParameter(Boolean.TYPE, "endpointDiscoveryEnabled", new Modifier[0]).addStatement("this.endpointDiscoveryEnabled = endpointDiscoveryEnabled", new Object[0]).addStatement("return this", new Object[0]).build();
    }

    private MethodSpec enableEndpointDiscovery() {
        return MethodSpec.methodBuilder((String)"enableEndpointDiscovery").addAnnotation(Override.class).addAnnotation(Deprecated.class).addJavadoc("@deprecated Use {@link #endpointDiscoveryEnabled($T)} instead.", new Object[]{Boolean.TYPE}).addModifiers(new Modifier[]{Modifier.PUBLIC}).returns((TypeName)this.builderClassName).addStatement("endpointDiscoveryEnabled = true", new Object[0]).addStatement("return this", new Object[0]).build();
    }

    private MethodSpec endpointProviderMethod() {
        return MethodSpec.methodBuilder((String)"endpointProvider").addModifiers(new Modifier[]{Modifier.PUBLIC}).addAnnotation(Override.class).returns((TypeName)this.className()).addParameter((TypeName)this.endpointRulesSpecUtils.providerInterfaceName(), "endpointProvider", new Modifier[0]).addStatement("clientConfiguration.option($T.ENDPOINT_PROVIDER, endpointProvider)", new Object[]{SdkClientOption.class}).addStatement("return this", new Object[0]).build();
    }

    private MethodSpec buildClientMethod() {
        MethodSpec.Builder builder = MethodSpec.methodBuilder((String)"buildClient").addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PROTECTED, Modifier.FINAL}).returns((TypeName)this.clientInterfaceName).addStatement("$T clientConfiguration = super.syncClientConfiguration()", new Object[]{SdkClientConfiguration.class}).addStatement("this.validateClientOptions(clientConfiguration)", new Object[0]);
        builder.addStatement("$1T client = new $2T(clientConfiguration)", new Object[]{this.clientInterfaceName, this.clientClassName});
        if (this.model.syncClientDecoratorClassName().isPresent()) {
            builder.addStatement("return new $T().decorate(client, clientConfiguration)", new Object[]{PoetUtils.classNameFromFqcn(this.model.syncClientDecoratorClassName().get())});
        } else {
            builder.addStatement("return client", new Object[0]);
        }
        return builder.build();
    }

    private MethodSpec tokenProviderMethodImpl() {
        ParameterizedTypeName tokenProviderTypeName = ParameterizedTypeName.get((ClassName)ClassName.get(IdentityProvider.class), (TypeName[])new TypeName[]{WildcardTypeName.subtypeOf(TokenIdentity.class)});
        return MethodSpec.methodBuilder((String)"tokenProvider").addModifiers(new Modifier[]{Modifier.PUBLIC}).addAnnotation(Override.class).addParameter((TypeName)tokenProviderTypeName, "tokenProvider", new Modifier[0]).returns((TypeName)this.builderClassName).addStatement("clientConfiguration.option($T.TOKEN_IDENTITY_PROVIDER, tokenProvider)", new Object[]{AwsClientOption.class}).addStatement("return this", new Object[0]).build();
    }

    @Override
    public ClassName className() {
        return this.builderClassName;
    }
}

