/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.codegen.poet.auth.scheme;

import com.squareup.javapoet.MethodSpec;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.BiConsumer;
import software.amazon.awssdk.codegen.model.service.AuthType;
import software.amazon.awssdk.codegen.poet.auth.scheme.AuthSchemeSpecUtils;
import software.amazon.awssdk.http.auth.aws.scheme.AwsV4AuthScheme;
import software.amazon.awssdk.http.auth.aws.signer.AwsV4HttpSigner;
import software.amazon.awssdk.http.auth.scheme.BearerAuthScheme;
import software.amazon.awssdk.http.auth.scheme.NoAuthAuthScheme;
import software.amazon.awssdk.utils.Validate;

public final class AuthSchemeCodegenMetadata {
    static final AuthSchemeCodegenMetadata SIGV4 = AuthSchemeCodegenMetadata.builder().schemeId("aws.auth#sigv4").authSchemeClass(AwsV4AuthScheme.class).addProperty(SignerPropertyValueProvider.access$000().containingClass(AwsV4HttpSigner.class).fieldName("SERVICE_SIGNING_NAME").valueEmitter((spec, utils) -> spec.addCode("$S", new Object[]{utils.signingName()})).build()).addProperty(SignerPropertyValueProvider.access$000().containingClass(AwsV4HttpSigner.class).fieldName("REGION_NAME").valueEmitter((spec, utils) -> spec.addCode("$L", new Object[]{"params.region().id()"})).build()).build();
    static final AuthSchemeCodegenMetadata SIGV4_UNSIGNED_BODY = SIGV4.toBuilder().addProperty(SignerPropertyValueProvider.access$000().containingClass(AwsV4HttpSigner.class).fieldName("PAYLOAD_SIGNING_ENABLED").valueEmitter((spec, utils) -> spec.addCode("$L", new Object[]{false})).build()).build();
    static final AuthSchemeCodegenMetadata S3 = SIGV4.toBuilder().addProperty(SignerPropertyValueProvider.access$000().containingClass(AwsV4HttpSigner.class).fieldName("DOUBLE_URL_ENCODE").valueEmitter((spec, utils) -> spec.addCode("$L", new Object[]{"false"})).build()).addProperty(SignerPropertyValueProvider.access$000().containingClass(AwsV4HttpSigner.class).fieldName("NORMALIZE_PATH").valueEmitter((spec, utils) -> spec.addCode("$L", new Object[]{"false"})).build()).addProperty(SignerPropertyValueProvider.access$000().containingClass(AwsV4HttpSigner.class).fieldName("PAYLOAD_SIGNING_ENABLED").valueEmitter((spec, utils) -> spec.addCode("$L", new Object[]{false})).build()).build();
    static final AuthSchemeCodegenMetadata S3V4 = SIGV4.toBuilder().addProperty(SignerPropertyValueProvider.access$000().containingClass(AwsV4HttpSigner.class).fieldName("DOUBLE_URL_ENCODE").valueEmitter((spec, utils) -> spec.addCode("$L", new Object[]{"false"})).build()).addProperty(SignerPropertyValueProvider.access$000().containingClass(AwsV4HttpSigner.class).fieldName("NORMALIZE_PATH").valueEmitter((spec, utils) -> spec.addCode("$L", new Object[]{"false"})).build()).build();
    static final AuthSchemeCodegenMetadata BEARER = AuthSchemeCodegenMetadata.builder().schemeId("smithy.api#httpBearerAuth").authSchemeClass(BearerAuthScheme.class).build();
    static final AuthSchemeCodegenMetadata NO_AUTH = AuthSchemeCodegenMetadata.builder().schemeId("smithy.api#noAuth").authSchemeClass(NoAuthAuthScheme.class).build();
    private final String schemeId;
    private final List<SignerPropertyValueProvider> properties;
    private final Class<?> authSchemeClass;

    private AuthSchemeCodegenMetadata(Builder builder) {
        this.schemeId = (String)Validate.paramNotNull((Object)builder.schemeId, (String)"schemeId");
        this.properties = Collections.unmodifiableList((List)Validate.paramNotNull((Object)builder.properties, (String)"properties"));
        this.authSchemeClass = (Class)Validate.paramNotNull((Object)builder.authSchemeClass, (String)"authSchemeClass");
    }

    public String schemeId() {
        return this.schemeId;
    }

    public Class<?> authSchemeClass() {
        return this.authSchemeClass;
    }

    public List<SignerPropertyValueProvider> properties() {
        return this.properties;
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    private static Builder builder() {
        return new Builder();
    }

    public static AuthSchemeCodegenMetadata fromAuthType(AuthType type) {
        switch (type) {
            case BEARER: {
                return BEARER;
            }
            case NONE: {
                return NO_AUTH;
            }
            case V4: {
                return SIGV4;
            }
            case V4_UNSIGNED_BODY: {
                return SIGV4_UNSIGNED_BODY;
            }
            case S3: {
                return S3;
            }
            case S3V4: {
                return S3V4;
            }
        }
        throw new IllegalArgumentException("Unknown auth type: " + (Object)((Object)type));
    }

    static class SignerPropertyValueProvider {
        private final Class<?> containingClass;
        private final String fieldName;
        private final BiConsumer<MethodSpec.Builder, AuthSchemeSpecUtils> valueEmitter;

        SignerPropertyValueProvider(Builder builder) {
            this.containingClass = (Class)Validate.paramNotNull((Object)builder.containingClass, (String)"containingClass");
            this.valueEmitter = (BiConsumer)Validate.paramNotNull((Object)builder.valueEmitter, (String)"valueEmitter");
            this.fieldName = (String)Validate.paramNotNull((Object)builder.fieldName, (String)"fieldName");
        }

        public Class<?> containingClass() {
            return this.containingClass;
        }

        public String fieldName() {
            return this.fieldName;
        }

        public void emitValue(MethodSpec.Builder spec, AuthSchemeSpecUtils utils) {
            this.valueEmitter.accept(spec, utils);
        }

        private static Builder builder() {
            return new Builder();
        }

        static /* synthetic */ Builder access$000() {
            return SignerPropertyValueProvider.builder();
        }

        static class Builder {
            private Class<?> containingClass;
            private String fieldName;
            private BiConsumer<MethodSpec.Builder, AuthSchemeSpecUtils> valueEmitter;

            Builder() {
            }

            public Builder containingClass(Class<?> containingClass) {
                this.containingClass = containingClass;
                return this;
            }

            public Builder fieldName(String fieldName) {
                this.fieldName = fieldName;
                return this;
            }

            public Builder valueEmitter(BiConsumer<MethodSpec.Builder, AuthSchemeSpecUtils> valueEmitter) {
                this.valueEmitter = valueEmitter;
                return this;
            }

            public SignerPropertyValueProvider build() {
                return new SignerPropertyValueProvider(this);
            }
        }
    }

    private static class Builder {
        private String schemeId;
        private List<SignerPropertyValueProvider> properties = new ArrayList<SignerPropertyValueProvider>();
        private Class<?> authSchemeClass;

        Builder() {
        }

        Builder(AuthSchemeCodegenMetadata other) {
            this.schemeId = other.schemeId;
            this.properties.addAll(other.properties);
            this.authSchemeClass = other.authSchemeClass;
        }

        public Builder schemeId(String schemeId) {
            this.schemeId = schemeId;
            return this;
        }

        public Builder addProperty(SignerPropertyValueProvider property) {
            this.properties.add(property);
            return this;
        }

        public Builder authSchemeClass(Class<?> authSchemeClass) {
            this.authSchemeClass = authSchemeClass;
            return this;
        }

        public AuthSchemeCodegenMetadata build() {
            return new AuthSchemeCodegenMetadata(this);
        }
    }
}

