/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.codegen.poet.common;

import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.FieldSpec;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import javax.lang.model.element.Modifier;
import software.amazon.awssdk.codegen.model.intermediate.ShapeModel;
import software.amazon.awssdk.codegen.poet.ClassSpec;
import software.amazon.awssdk.codegen.poet.PoetUtils;
import software.amazon.awssdk.utils.internal.EnumUtils;

public abstract class AbstractEnumClass
implements ClassSpec {
    private static final String VALUE = "value";
    private static final String VALUE_MAP = "VALUE_MAP";
    private static final String UNKNOWN_TO_SDK_VERSION = "UNKNOWN_TO_SDK_VERSION";
    private final ShapeModel shape;

    public AbstractEnumClass(ShapeModel shape) {
        this.shape = shape;
    }

    @Override
    public final TypeSpec poetSpec() {
        TypeSpec.Builder enumBuilder = PoetUtils.createEnumBuilder(this.className()).addField(this.valueMapField()).addField(String.class, VALUE, new Modifier[]{Modifier.PRIVATE, Modifier.FINAL}).addMethod(PoetUtils.toStringBuilder().addStatement("return $T.valueOf($N)", new Object[]{String.class, VALUE}).build()).addMethod(this.fromValueSpec()).addMethod(this.knownValuesSpec()).addMethod(this.createConstructor());
        this.addDeprecated(enumBuilder);
        this.addJavadoc(enumBuilder);
        this.addEnumConstants(enumBuilder);
        enumBuilder.addEnumConstant(UNKNOWN_TO_SDK_VERSION, TypeSpec.anonymousClassBuilder((String)"null", (Object[])new Object[0]).build());
        return enumBuilder.build();
    }

    protected final ShapeModel getShape() {
        return this.shape;
    }

    protected abstract void addDeprecated(TypeSpec.Builder var1);

    protected abstract void addJavadoc(TypeSpec.Builder var1);

    protected abstract void addEnumConstants(TypeSpec.Builder var1);

    private FieldSpec valueMapField() {
        ParameterizedTypeName mapType = ParameterizedTypeName.get((ClassName)ClassName.get(Map.class), (TypeName[])new TypeName[]{ClassName.get(String.class), this.className()});
        return FieldSpec.builder((TypeName)mapType, (String)VALUE_MAP, (Modifier[])new Modifier[0]).addModifiers(new Modifier[]{Modifier.PRIVATE, Modifier.STATIC, Modifier.FINAL}).initializer("$1T.uniqueIndex($2T.class, $2T::toString)", new Object[]{EnumUtils.class, this.className()}).build();
    }

    private MethodSpec createConstructor() {
        return MethodSpec.constructorBuilder().addModifiers(new Modifier[]{Modifier.PRIVATE}).addParameter(String.class, VALUE, new Modifier[0]).addStatement("this.$1N = $1N", new Object[]{VALUE}).build();
    }

    private MethodSpec fromValueSpec() {
        return MethodSpec.methodBuilder((String)"fromValue").returns((TypeName)this.className()).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.STATIC}).addJavadoc("Use this in place of valueOf to convert the raw string returned by the service into the enum value.\n\n@param $N real value\n@return $T corresponding to the value\n", new Object[]{VALUE, this.className()}).addParameter(String.class, VALUE, new Modifier[0]).beginControlFlow("if ($N == null)", new Object[]{VALUE}).addStatement("return null", new Object[0]).endControlFlow().addStatement("return $N.getOrDefault($N, $N)", new Object[]{VALUE_MAP, VALUE, UNKNOWN_TO_SDK_VERSION}).build();
    }

    private MethodSpec knownValuesSpec() {
        return MethodSpec.methodBuilder((String)"knownValues").returns((TypeName)ParameterizedTypeName.get((ClassName)ClassName.get(Set.class), (TypeName[])new TypeName[]{this.className()})).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.STATIC}).addJavadoc("Use this in place of {@link #values()} to return a {@link Set} of all values known to the SDK.\nThis will return all known enum values except {@link #$N}.\n\n@return a {@link $T} of known {@link $T}s", new Object[]{UNKNOWN_TO_SDK_VERSION, Set.class, this.className()}).addStatement("$1T<$2T> knownValues = $3T.allOf($2T.class)", new Object[]{Set.class, this.className(), EnumSet.class}).addStatement("knownValues.remove($N)", new Object[]{UNKNOWN_TO_SDK_VERSION}).addStatement("return knownValues", new Object[0]).build();
    }
}

