/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.codegen.poet.paginators;

import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.FieldSpec;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import java.util.Collections;
import java.util.Iterator;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.lang.model.element.Modifier;
import software.amazon.awssdk.codegen.model.intermediate.IntermediateModel;
import software.amazon.awssdk.codegen.model.intermediate.MemberModel;
import software.amazon.awssdk.codegen.model.service.PaginatorDefinition;
import software.amazon.awssdk.codegen.poet.PoetUtils;
import software.amazon.awssdk.codegen.poet.paginators.PaginatorsClassSpec;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;

public class SyncResponseClassSpec
extends PaginatorsClassSpec {
    protected static final String ITERATOR_METHOD = "iterator";

    public SyncResponseClassSpec(IntermediateModel model, String c2jOperationName, PaginatorDefinition paginatorDefinition) {
        super(model, c2jOperationName, paginatorDefinition);
    }

    @Override
    public TypeSpec poetSpec() {
        TypeSpec.Builder specBuilder = TypeSpec.classBuilder((ClassName)this.className()).addModifiers(new Modifier[]{Modifier.PUBLIC}).addAnnotation(PoetUtils.generatedAnnotation()).addSuperinterface(this.getSyncResponseInterface()).addFields((Iterable)this.fields().collect(Collectors.toList())).addMethod(this.constructor()).addMethod(this.iteratorMethod()).addMethods(this.getMethodSpecsForResultKeyList()).addJavadoc(this.paginationDocs.getDocsForSyncResponseClass(this.getClientInterfaceName()), new Object[0]).addType(this.nextPageFetcherClass().build());
        return specBuilder.build();
    }

    @Override
    public ClassName className() {
        return this.poetExtensions.getResponseClassForPaginatedSyncOperation(this.c2jOperationName);
    }

    private TypeName getSyncResponseInterface() {
        return ParameterizedTypeName.get((ClassName)ClassName.get(SdkIterable.class), (TypeName[])new TypeName[]{this.responseType()});
    }

    protected ClassName getClientInterfaceName() {
        return this.poetExtensions.getClientClass(this.model.getMetadata().getSyncInterface());
    }

    protected Stream<FieldSpec> fields() {
        return Stream.of(this.syncClientInterfaceField(), this.requestClassField(), this.syncPageFetcherField());
    }

    protected FieldSpec syncClientInterfaceField() {
        return FieldSpec.builder((TypeName)this.getClientInterfaceName(), (String)"client", (Modifier[])new Modifier[]{Modifier.PRIVATE, Modifier.FINAL}).build();
    }

    private FieldSpec syncPageFetcherField() {
        return FieldSpec.builder(SyncPageFetcher.class, (String)"nextPageFetcher", (Modifier[])new Modifier[]{Modifier.PRIVATE, Modifier.FINAL}).build();
    }

    protected MethodSpec constructor() {
        return MethodSpec.constructorBuilder().addModifiers(new Modifier[]{Modifier.PUBLIC}).addParameter((TypeName)this.getClientInterfaceName(), "client", new Modifier[0]).addParameter((TypeName)this.requestType(), "firstRequest", new Modifier[0]).addStatement("this.$L = $L", new Object[]{"client", "client"}).addStatement("this.$L = $L", new Object[]{"firstRequest", "firstRequest"}).addStatement("this.$L = new $L()", new Object[]{"nextPageFetcher", this.nextPageFetcherClassName()}).build();
    }

    protected MethodSpec iteratorMethod() {
        return MethodSpec.methodBuilder((String)ITERATOR_METHOD).addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PUBLIC}).returns((TypeName)ParameterizedTypeName.get((ClassName)ClassName.get(Iterator.class), (TypeName[])new TypeName[]{this.responseType()})).addStatement("return $1T.builder().$2L($3L).build()", new Object[]{PaginatedResponsesIterator.class, "nextPageFetcher", this.nextPageFetcherArgument()}).build();
    }

    protected String nextPageFetcherArgument() {
        return "nextPageFetcher";
    }

    private Iterable<MethodSpec> getMethodSpecsForResultKeyList() {
        if (this.paginatorDefinition.getResultKey() != null) {
            return this.paginatorDefinition.getResultKey().stream().map(this::getMethodsSpecForSingleResultKey).filter(Objects::nonNull).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }

    private MethodSpec getMethodsSpecForSingleResultKey(String resultKey) {
        MemberModel resultKeyModel = this.memberModelForResponseMember(resultKey);
        if (!resultKeyModel.isList() && !resultKeyModel.isMap()) {
            return null;
        }
        TypeName resultKeyType = this.getTypeForResultKey(resultKey);
        return MethodSpec.methodBuilder((String)resultKeyModel.getFluentGetterMethodName()).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.FINAL}).returns((TypeName)ParameterizedTypeName.get((ClassName)ClassName.get(SdkIterable.class), (TypeName[])new TypeName[]{resultKeyType})).addCode("$T getIterator = ", new Object[]{ParameterizedTypeName.get((ClassName)ClassName.get(Function.class), (TypeName[])new TypeName[]{this.responseType(), ParameterizedTypeName.get((ClassName)ClassName.get(Iterator.class), (TypeName[])new TypeName[]{resultKeyType})})}).addCode(this.getIteratorLambdaBlock(resultKey, resultKeyModel)).addCode("\n", new Object[0]).addStatement("return $T.<$T, $T>builder().pagesIterable(this).itemIteratorFunction(getIterator).build()", new Object[]{PaginatedItemsIterable.class, this.responseType(), resultKeyType}).addJavadoc(CodeBlock.builder().add("Returns an iterable to iterate through the paginated {@link $T#$L()} member. The returned iterable is used to iterate through the results across all response pages and not a single page.\n", new Object[]{this.responseType(), resultKeyModel.getFluentGetterMethodName()}).add("\n", new Object[0]).add("This method is useful if you are interested in iterating over the paginated member in the response pages instead of the top level pages. Similar to iteration over pages, this method internally makes service calls to get the next list of results until the iteration stops or there are no more results.", new Object[0]).build()).build();
    }

    protected TypeSpec.Builder nextPageFetcherClass() {
        return TypeSpec.classBuilder((String)this.nextPageFetcherClassName()).addModifiers(new Modifier[]{Modifier.PRIVATE}).addSuperinterface((TypeName)ParameterizedTypeName.get((ClassName)ClassName.get(SyncPageFetcher.class), (TypeName[])new TypeName[]{this.responseType()})).addMethod(MethodSpec.methodBuilder((String)"hasNextPage").addModifiers(new Modifier[]{Modifier.PUBLIC}).addAnnotation(Override.class).addParameter((TypeName)this.responseType(), "previousPage", new Modifier[0]).returns(Boolean.TYPE).addStatement(this.hasNextPageMethodBody()).build()).addMethod(MethodSpec.methodBuilder((String)"nextPage").addModifiers(new Modifier[]{Modifier.PUBLIC}).addAnnotation(Override.class).addParameter((TypeName)this.responseType(), "previousPage", new Modifier[0]).returns((TypeName)this.responseType()).addCode(this.nextPageMethodBody()).build());
    }
}

