/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.codegen.poet.model;

import com.squareup.javapoet.AnnotationSpec;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterSpec;
import com.squareup.javapoet.TypeName;
import java.beans.Transient;
import java.util.Collections;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.lang.model.element.Modifier;
import software.amazon.awssdk.codegen.model.intermediate.IntermediateModel;
import software.amazon.awssdk.codegen.model.intermediate.MemberModel;
import software.amazon.awssdk.codegen.model.intermediate.ShapeModel;
import software.amazon.awssdk.codegen.poet.PoetExtensions;
import software.amazon.awssdk.codegen.poet.model.MemberSetters;
import software.amazon.awssdk.codegen.poet.model.ServiceModelCopiers;
import software.amazon.awssdk.codegen.poet.model.TypeProvider;
import software.amazon.awssdk.core.SdkBytes;

abstract class AbstractMemberSetters
implements MemberSetters {
    protected final PoetExtensions poetExtensions;
    private final ShapeModel shapeModel;
    private final MemberModel memberModel;
    private final TypeProvider typeProvider;
    private final ServiceModelCopiers serviceModelCopiers;

    AbstractMemberSetters(IntermediateModel intermediateModel, ShapeModel shapeModel, MemberModel memberModel, TypeProvider typeProvider) {
        this.shapeModel = shapeModel;
        this.memberModel = memberModel;
        this.typeProvider = typeProvider;
        this.serviceModelCopiers = new ServiceModelCopiers(intermediateModel);
        this.poetExtensions = new PoetExtensions(intermediateModel);
    }

    protected MethodSpec.Builder fluentAbstractSetterDeclaration(ParameterSpec parameter, TypeName returnType) {
        return this.fluentSetterDeclaration(parameter, returnType).addModifiers(new Modifier[]{Modifier.ABSTRACT});
    }

    protected MethodSpec.Builder fluentAbstractSetterDeclaration(String methodName, ParameterSpec parameter, TypeName returnType) {
        return this.setterDeclaration(methodName, parameter, returnType).addModifiers(new Modifier[]{Modifier.ABSTRACT});
    }

    protected MethodSpec.Builder fluentDefaultSetterDeclaration(ParameterSpec parameter, TypeName returnType) {
        return this.fluentSetterDeclaration(parameter, returnType).addModifiers(new Modifier[]{Modifier.DEFAULT});
    }

    protected MethodSpec.Builder fluentSetterBuilder(TypeName returnType) {
        return this.fluentSetterBuilder(this.memberAsParameter(), returnType);
    }

    protected MethodSpec.Builder fluentSetterBuilder(String methodName, TypeName returnType) {
        return this.fluentSetterBuilder(methodName, this.memberAsParameter(), returnType);
    }

    protected MethodSpec.Builder fluentSetterBuilder(ParameterSpec setterParam, TypeName returnType) {
        return this.fluentSetterBuilder(this.memberModel().getFluentSetterMethodName(), setterParam, returnType);
    }

    protected MethodSpec.Builder fluentSetterBuilder(String methodName, ParameterSpec setterParam, TypeName returnType) {
        return MethodSpec.methodBuilder((String)methodName).addParameter(setterParam).addAnnotation(Override.class).addAnnotations(this.maybeTransient(methodName)).returns(returnType).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.FINAL});
    }

    private Iterable<AnnotationSpec> maybeTransient(String methodName) {
        if (methodName.startsWith("set")) {
            return Collections.singleton(AnnotationSpec.builder(Transient.class).build());
        }
        return Collections.emptyList();
    }

    protected MethodSpec.Builder beanStyleSetterBuilder() {
        return this.beanStyleSetterBuilder(this.memberAsBeanStyleParameter(), this.memberModel().getBeanStyleSetterMethodName());
    }

    protected MethodSpec.Builder deprecatedBeanStyleSetterBuilder() {
        return this.beanStyleSetterBuilder(this.memberAsBeanStyleParameter(), this.memberModel().getDeprecatedBeanStyleSetterMethodName());
    }

    protected MethodSpec.Builder beanStyleSetterBuilder(ParameterSpec setterParam, String methodName) {
        return MethodSpec.methodBuilder((String)methodName).addParameter(setterParam).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.FINAL});
    }

    protected CodeBlock copySetterBody() {
        return this.copySetterBody("this.$1N = $2T.$3N($1N)", "this.$1N = $1N", this.serviceModelCopiers.copyMethodName());
    }

    protected CodeBlock fluentSetterWithEnumCollectionsParameterMethodBody() {
        return this.copySetterBody("this.$1N = $2T.$3N($1N)", "this.$1N = $1N", this.serviceModelCopiers.enumToStringCopyMethodName());
    }

    protected CodeBlock copySetterBodyWithModeledEnumParameter() {
        return this.copySetterBody("this.$1N = $2T.$3N($1N)", "this.$1N = $1N", this.serviceModelCopiers.enumToStringCopyMethodName());
    }

    protected CodeBlock copySetterBuilderBody() {
        if (this.memberModel.hasBuilder()) {
            return this.copySetterBody("this.$1N = $1N != null ? $2T.$3N($1N.build()) : null", "this.$1N = $1N != null ? $1N.build() : null", this.serviceModelCopiers.copyMethodName());
        }
        if (this.memberModel.containsBuildable()) {
            return this.copySetterBody("this.$1N = $2T.$3N($1N)", null, this.serviceModelCopiers.copyFromBuilderMethodName());
        }
        return this.copySetterBody();
    }

    protected CodeBlock beanCopySetterBody() {
        if (this.memberModel.isSdkBytesType()) {
            return this.sdkBytesSetter();
        }
        if (this.memberModel.isList() && this.memberModel.getListModel().getListMemberModel().isSdkBytesType()) {
            return this.sdkBytesListSetter();
        }
        if (this.memberModel.isMap() && this.memberModel.getMapModel().getValueModel().isSdkBytesType()) {
            return this.sdkBytesMapValueSetter();
        }
        return this.copySetterBuilderBody();
    }

    private CodeBlock sdkBytesSetter() {
        return CodeBlock.of((String)"$1N($2N == null ? null : $3T.fromByteBuffer($2N));", (Object[])new Object[]{this.memberModel.getFluentSetterMethodName(), this.fieldName(), SdkBytes.class});
    }

    private CodeBlock sdkBytesListSetter() {
        return CodeBlock.of((String)"$1N($2N == null ? null : $2N.stream().map($3T::fromByteBuffer).collect($4T.toList()));", (Object[])new Object[]{this.memberModel.getFluentSetterMethodName(), this.fieldName(), SdkBytes.class, Collectors.class});
    }

    private CodeBlock sdkBytesMapValueSetter() {
        return CodeBlock.of((String)"$1N($2N == null ? null : $2N.entrySet().stream().collect($4T.toMap(e -> e.getKey(), e -> $3T.fromByteBuffer(e.getValue()))));", (Object[])new Object[]{this.memberModel.getFluentSetterMethodName(), this.fieldName(), SdkBytes.class, Collectors.class});
    }

    protected ParameterSpec memberAsParameter() {
        return ParameterSpec.builder((TypeName)this.typeProvider.parameterType(this.memberModel), (String)this.fieldName(), (Modifier[])new Modifier[0]).build();
    }

    protected ParameterSpec memberAsBeanStyleParameter() {
        TypeName type = this.typeProvider.typeName(this.memberModel, new TypeProvider.TypeNameOptions().shapeTransformation(TypeProvider.ShapeTransformation.USE_BUILDER_IMPL).useSubtypeWildcardsForCollections(true).useCollectionForList(true).useByteBufferTypes(true));
        return ParameterSpec.builder((TypeName)type, (String)this.fieldName(), (Modifier[])new Modifier[0]).build();
    }

    protected ShapeModel shapeModel() {
        return this.shapeModel;
    }

    protected MemberModel memberModel() {
        return this.memberModel;
    }

    protected String fieldName() {
        return this.memberModel.getVariable().getVariableName();
    }

    private MethodSpec.Builder fluentSetterDeclaration(ParameterSpec parameter, TypeName returnType) {
        return this.setterDeclaration(this.memberModel().getFluentSetterMethodName(), parameter, returnType);
    }

    private MethodSpec.Builder setterDeclaration(String methodName, ParameterSpec parameter, TypeName returnType) {
        return MethodSpec.methodBuilder((String)methodName).addModifiers(new Modifier[]{Modifier.PUBLIC}).addParameter(parameter).returns(returnType);
    }

    private CodeBlock copySetterBody(String copyAssignment, String regularAssignment, String copyMethodName) {
        Optional<ClassName> copierClass;
        CodeBlock.Builder body = CodeBlock.builder();
        if (this.shapeModel.isUnion()) {
            body.addStatement("Object oldValue = this.$N", new Object[]{this.fieldName()});
        }
        if ((copierClass = this.serviceModelCopiers.copierClassFor(this.memberModel)).isPresent()) {
            body.addStatement(copyAssignment, new Object[]{this.fieldName(), copierClass.get(), copyMethodName});
        } else {
            body.addStatement(regularAssignment, new Object[]{this.fieldName()});
        }
        if (this.shapeModel.isUnion()) {
            body.addStatement("handleUnionValueChange(Type.$N, oldValue, this.$N)", new Object[]{this.memberModel.getUnionEnumTypeName(), this.fieldName()});
        }
        return body.build();
    }
}

