/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.codegen.poet;

import com.squareup.javapoet.ClassName;
import software.amazon.awssdk.codegen.internal.Utils;
import software.amazon.awssdk.codegen.model.intermediate.IntermediateModel;
import software.amazon.awssdk.codegen.model.intermediate.OperationModel;
import software.amazon.awssdk.codegen.model.intermediate.ShapeModel;
import software.amazon.awssdk.codegen.model.intermediate.ShapeType;

public class PoetExtensions {
    private final IntermediateModel model;

    public PoetExtensions(IntermediateModel model) {
        this.model = model;
    }

    public ClassName getModelClass(String className) {
        return ClassName.get((String)this.model.getMetadata().getFullModelPackageName(), (String)className, (String[])new String[0]);
    }

    public ClassName getTransformClass(String className) {
        return ClassName.get((String)this.model.getMetadata().getFullTransformPackageName(), (String)className, (String[])new String[0]);
    }

    public ClassName getRequestTransformClass(String className) {
        return ClassName.get((String)this.model.getMetadata().getFullRequestTransformPackageName(), (String)className, (String[])new String[0]);
    }

    public ClassName getClientClass(String className) {
        return ClassName.get((String)this.model.getMetadata().getFullClientPackageName(), (String)className, (String[])new String[0]);
    }

    public ClassName getResponseClassForPaginatedSyncOperation(String operationName) {
        return ClassName.get((String)this.model.getMetadata().getFullPaginatorsPackageName(), (String)(operationName + "Iterable"), (String[])new String[0]);
    }

    public ClassName getSyncWaiterInterface() {
        return ClassName.get((String)this.model.getMetadata().getFullWaitersPackageName(), (String)(this.model.getMetadata().getServiceName() + "Waiter"), (String[])new String[0]);
    }

    public ClassName getSyncWaiterClass() {
        return ClassName.get((String)this.model.getMetadata().getFullWaitersPackageName(), (String)("Default" + this.model.getMetadata().getServiceName() + "Waiter"), (String[])new String[0]);
    }

    public ClassName getAsyncWaiterInterface() {
        return ClassName.get((String)this.model.getMetadata().getFullWaitersPackageName(), (String)(this.model.getMetadata().getServiceName() + "AsyncWaiter"), (String[])new String[0]);
    }

    public ClassName getAsyncWaiterClass() {
        return ClassName.get((String)this.model.getMetadata().getFullWaitersPackageName(), (String)("Default" + this.model.getMetadata().getServiceName() + "AsyncWaiter"), (String[])new String[0]);
    }

    public ClassName getResponseClassForPaginatedAsyncOperation(String operationName) {
        return ClassName.get((String)this.model.getMetadata().getFullPaginatorsPackageName(), (String)(operationName + "Publisher"), (String[])new String[0]);
    }

    public ClassName getResponseMetadataClass() {
        return ClassName.get((String)this.model.getMetadata().getFullModelPackageName(), (String)(this.model.getSdkResponseBaseClassName() + "Metadata"), (String[])new String[0]);
    }

    public String getApiName(OperationModel operation) {
        return Utils.capitalize(operation.getOperationName());
    }

    public ClassName responsePojoType(OperationModel operation) {
        return this.getModelClass(operation.getOutputShape().getShapeName());
    }

    public ClassName eventStreamResponseHandlerType(OperationModel operation) {
        return this.getModelClass(this.getApiName(operation) + "ResponseHandler");
    }

    public ClassName eventStreamResponseHandlerBuilderType(OperationModel operation) {
        return this.eventStreamResponseHandlerType(operation).nestedClass("Builder");
    }

    public ClassName eventStreamResponseHandlerVisitorType(OperationModel operation) {
        return this.eventStreamResponseHandlerType(operation).nestedClass("Visitor");
    }

    public ClassName eventStreamResponseHandlerVisitorBuilderType(OperationModel operation) {
        return this.eventStreamResponseHandlerVisitorType(operation).nestedClass("Builder");
    }

    public ClassName getModelClassFromShape(ShapeModel shapeModel) {
        return this.getModelClass(shapeModel.getShapeName());
    }

    public boolean isResponse(ShapeModel shapeModel) {
        return shapeModel.getShapeType() == ShapeType.Response;
    }

    public boolean isRequest(ShapeModel shapeModel) {
        return shapeModel.getShapeType() == ShapeType.Request;
    }
}

