/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.codegen.model.intermediate;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import software.amazon.awssdk.codegen.internal.DocumentationUtils;
import software.amazon.awssdk.codegen.model.intermediate.DocumentationModel;
import software.amazon.awssdk.codegen.model.intermediate.EndpointDiscovery;
import software.amazon.awssdk.codegen.model.intermediate.EnumModel;
import software.amazon.awssdk.codegen.model.intermediate.HasDeprecation;
import software.amazon.awssdk.codegen.model.intermediate.MemberModel;
import software.amazon.awssdk.codegen.model.intermediate.ShapeMarshaller;
import software.amazon.awssdk.codegen.model.intermediate.ShapeType;
import software.amazon.awssdk.codegen.model.intermediate.ShapeUnmarshaller;
import software.amazon.awssdk.codegen.model.intermediate.VariableModel;
import software.amazon.awssdk.codegen.model.intermediate.customization.ShapeCustomizationInfo;
import software.amazon.awssdk.codegen.model.service.XmlNamespace;
import software.amazon.awssdk.utils.StringUtils;

public class ShapeModel
extends DocumentationModel
implements HasDeprecation {
    private String c2jName;
    private String shapeName;
    private boolean deprecated;
    private String deprecatedMessage;
    private String type;
    private List<String> required;
    private boolean hasPayloadMember;
    private boolean hasHeaderMember;
    private boolean hasStatusCodeMember;
    private boolean hasStreamingMember;
    private boolean hasRequiresLengthMember;
    private boolean wrapper;
    private boolean simpleMethod;
    private String requestSignerClassFqcn;
    private EndpointDiscovery endpointDiscovery;
    private List<MemberModel> members;
    private List<EnumModel> enums;
    private VariableModel variable;
    private ShapeMarshaller marshaller;
    private ShapeUnmarshaller unmarshaller;
    private String errorCode;
    private Integer httpStatusCode;
    private ShapeCustomizationInfo customization = new ShapeCustomizationInfo();
    private boolean isEventStream;
    private boolean isEvent;
    private XmlNamespace xmlNamespace;
    private boolean document;

    public ShapeModel() {
    }

    public ShapeModel(String c2jName) {
        this.c2jName = c2jName;
    }

    public String getShapeName() {
        return this.shapeName;
    }

    public void setShapeName(String shapeName) {
        this.shapeName = shapeName;
    }

    @Override
    public boolean isDeprecated() {
        return this.deprecated;
    }

    public void setDeprecated(boolean deprecated) {
        this.deprecated = deprecated;
    }

    public String getDeprecatedMessage() {
        return this.deprecatedMessage;
    }

    public void setDeprecatedMessage(String deprecatedMessage) {
        this.deprecatedMessage = deprecatedMessage;
    }

    public String getC2jName() {
        return this.c2jName;
    }

    public void setC2jName(String c2jName) {
        this.c2jName = c2jName;
    }

    public String getType() {
        return this.type;
    }

    @JsonIgnore
    public void setType(ShapeType shapeType) {
        this.setType(shapeType.getValue());
    }

    public void setType(String type) {
        this.type = type;
    }

    @JsonIgnore
    public ShapeType getShapeType() {
        return ShapeType.fromValue(this.type);
    }

    public ShapeModel withType(String type) {
        this.type = type;
        return this;
    }

    public List<String> getRequired() {
        return this.required;
    }

    public void setRequired(List<String> required) {
        this.required = required;
    }

    public boolean isHasPayloadMember() {
        return this.hasPayloadMember;
    }

    public void setHasPayloadMember(boolean hasPayloadMember) {
        this.hasPayloadMember = hasPayloadMember;
    }

    public ShapeModel withHasPayloadMember(boolean hasPayloadMember) {
        this.setHasPayloadMember(hasPayloadMember);
        return this;
    }

    @JsonIgnore
    public MemberModel getPayloadMember() {
        MemberModel payloadMember = null;
        for (MemberModel member : this.members) {
            if (!member.getHttp().getIsPayload()) continue;
            if (payloadMember == null) {
                payloadMember = member;
                continue;
            }
            throw new IllegalStateException(String.format("Only one payload member can be explicitly set on %s. This is likely an error in the C2J model", this.c2jName));
        }
        return payloadMember;
    }

    @JsonIgnore
    public List<MemberModel> getUnboundMembers() {
        ArrayList<MemberModel> unboundMembers = new ArrayList<MemberModel>();
        if (this.members != null) {
            for (MemberModel member : this.members) {
                if (member.getHttp().getLocation() != null || member.getHttp().getIsPayload()) continue;
                if (this.hasPayloadMember) {
                    throw new IllegalStateException(String.format("C2J Shape %s has both an explicit payload member and unbound (no explicit location) member, %s. This is undefined behavior, verify the correctness of the C2J model.", this.c2jName, member.getName()));
                }
                unboundMembers.add(member);
            }
        }
        return unboundMembers;
    }

    @JsonIgnore
    public List<MemberModel> getUnboundEventMembers() {
        if (this.members == null) {
            return new ArrayList<MemberModel>();
        }
        return this.members.stream().filter(m -> !m.isEventHeader()).filter(m -> !m.isEventPayload()).collect(Collectors.toList());
    }

    public boolean hasPayloadMembers() {
        return this.hasPayloadMember || this.getExplicitEventPayloadMember() != null || this.hasImplicitPayloadMembers();
    }

    public boolean hasImplicitPayloadMembers() {
        return !this.getUnboundMembers().isEmpty() || this.hasImplicitEventPayloadMembers();
    }

    public boolean hasImplicitEventPayloadMembers() {
        return this.isEvent() && !this.getUnboundEventMembers().isEmpty();
    }

    public MemberModel getExplicitEventPayloadMember() {
        if (this.members == null) {
            return null;
        }
        return this.members.stream().filter(MemberModel::isEventPayload).findFirst().orElse(null);
    }

    public boolean hasNoEventPayload() {
        return this.members == null || this.members.stream().allMatch(MemberModel::isEventHeader);
    }

    public boolean isHasStreamingMember() {
        return this.hasStreamingMember;
    }

    public void setHasStreamingMember(boolean hasStreamingMember) {
        this.hasStreamingMember = hasStreamingMember;
    }

    public ShapeModel withHasStreamingMember(boolean hasStreamingMember) {
        this.setHasStreamingMember(hasStreamingMember);
        return this;
    }

    public boolean isHasRequiresLengthMember() {
        return this.hasRequiresLengthMember;
    }

    public void setHasRequiresLengthMember(boolean hasRequiresLengthMember) {
        this.hasRequiresLengthMember = hasRequiresLengthMember;
    }

    public ShapeModel withHasRequiresLengthMember(boolean hasRequiresLengthMember) {
        this.setHasRequiresLengthMember(hasRequiresLengthMember);
        return this;
    }

    public boolean isHasHeaderMember() {
        return this.hasHeaderMember;
    }

    public void setHasHeaderMember(boolean hasHeaderMember) {
        this.hasHeaderMember = hasHeaderMember;
    }

    public ShapeModel withHasHeaderMember(boolean hasHeaderMember) {
        this.setHasHeaderMember(hasHeaderMember);
        return this;
    }

    public boolean isHasStatusCodeMember() {
        return this.hasStatusCodeMember;
    }

    public void setHasStatusCodeMember(boolean hasStatusCodeMember) {
        this.hasStatusCodeMember = hasStatusCodeMember;
    }

    public boolean isWrapper() {
        return this.wrapper;
    }

    public void setWrapper(boolean wrapper) {
        this.wrapper = wrapper;
    }

    public boolean isSimpleMethod() {
        return this.simpleMethod;
    }

    public void setSimpleMethod(boolean simpleMethod) {
        this.simpleMethod = simpleMethod;
    }

    public ShapeModel withHasStatusCodeMember(boolean hasStatusCodeMember) {
        this.setHasStatusCodeMember(hasStatusCodeMember);
        return this;
    }

    public MemberModel getMemberByVariableName(String memberVariableName) {
        for (MemberModel memberModel : this.members) {
            if (!memberModel.getVariable().getVariableName().equals(memberVariableName)) continue;
            return memberModel;
        }
        throw new IllegalArgumentException("Unknown member variable name: " + memberVariableName);
    }

    public MemberModel getMemberByName(String memberName) {
        for (MemberModel memberModel : this.members) {
            if (!memberModel.getName().equals(memberName)) continue;
            return memberModel;
        }
        return null;
    }

    public MemberModel getMemberByC2jName(String memberName) {
        for (MemberModel memberModel : this.members) {
            if (!memberModel.getC2jName().equals(memberName)) continue;
            return memberModel;
        }
        return null;
    }

    public List<MemberModel> getMembers() {
        if (this.members == null) {
            return Collections.emptyList();
        }
        return this.members;
    }

    public List<MemberModel> getNonStreamingMembers() {
        return this.getMembers().stream().filter(m -> !m.getHttp().getIsStreaming()).filter(m -> m.getShape() == null || !m.getShape().isEventStream).collect(Collectors.toList());
    }

    public void setMembers(List<MemberModel> members) {
        this.members = members;
    }

    public void addMember(MemberModel member) {
        if (this.members == null) {
            this.members = new ArrayList<MemberModel>();
        }
        this.members.add(member);
    }

    public List<EnumModel> getEnums() {
        return this.enums;
    }

    public void setEnums(List<EnumModel> enums) {
        this.enums = enums;
    }

    public void addEnum(EnumModel enumModel) {
        if (this.enums == null) {
            this.enums = new ArrayList<EnumModel>();
        }
        this.enums.add(enumModel);
    }

    public VariableModel getVariable() {
        return this.variable;
    }

    public void setVariable(VariableModel variable) {
        this.variable = variable;
    }

    public ShapeMarshaller getMarshaller() {
        return this.marshaller;
    }

    public void setMarshaller(ShapeMarshaller marshaller) {
        this.marshaller = marshaller;
    }

    public ShapeUnmarshaller getUnmarshaller() {
        return this.unmarshaller;
    }

    public void setUnmarshaller(ShapeUnmarshaller unmarshaller) {
        this.unmarshaller = unmarshaller;
    }

    public ShapeCustomizationInfo getCustomization() {
        return this.customization;
    }

    public void setCustomization(ShapeCustomizationInfo customization) {
        this.customization = customization;
    }

    public Map<String, MemberModel> getMembersAsMap() {
        HashMap<String, MemberModel> shapeMembers = new HashMap<String, MemberModel>();
        List<MemberModel> memberModels = this.getMembers();
        if (memberModels != null) {
            for (MemberModel model : memberModels) {
                shapeMembers.put(model.getName(), model);
            }
        }
        return shapeMembers;
    }

    public MemberModel tryFindMemberModelByC2jName(String memberC2jName, boolean ignoreCase) {
        String expectedName;
        List<MemberModel> memberModels = this.getMembers();
        String string = expectedName = ignoreCase ? StringUtils.lowerCase((String)memberC2jName) : memberC2jName;
        if (memberModels != null) {
            for (MemberModel member : memberModels) {
                String actualName = ignoreCase ? StringUtils.lowerCase((String)member.getC2jName()) : member.getC2jName();
                if (!expectedName.equals(actualName)) continue;
                return member;
            }
        }
        return null;
    }

    public MemberModel findMemberModelByC2jName(String memberC2jName) {
        MemberModel model = this.tryFindMemberModelByC2jName(memberC2jName, false);
        if (model == null) {
            throw new IllegalArgumentException(memberC2jName + " member (c2j name) does not exist in the shape.");
        }
        return model;
    }

    public boolean removeMemberByC2jName(String memberC2jName, boolean ignoreCase) {
        MemberModel model = this.tryFindMemberModelByC2jName(memberC2jName, ignoreCase);
        return model == null ? false : this.members.remove(model);
    }

    public EnumModel findEnumModelByValue(String enumValue) {
        if (this.enums != null) {
            for (EnumModel enumModel : this.enums) {
                if (!enumValue.equals(enumModel.getValue())) continue;
                return enumModel;
            }
        }
        return null;
    }

    @JsonIgnore
    public String getDocumentationShapeName() {
        switch (this.getShapeType()) {
            case Request: {
                return DocumentationUtils.removeFromEnd(this.shapeName, "Request");
            }
            case Response: {
                return DocumentationUtils.removeFromEnd(this.shapeName, "Response");
            }
        }
        return this.c2jName;
    }

    public String toString() {
        return this.shapeName;
    }

    public String getErrorCode() {
        return this.errorCode;
    }

    public void setErrorCode(String errorCode) {
        this.errorCode = errorCode;
    }

    public Integer getHttpStatusCode() {
        return this.httpStatusCode;
    }

    public void setHttpStatusCode(Integer httpStatusCode) {
        this.httpStatusCode = httpStatusCode;
    }

    public boolean isRequestSignerAware() {
        return this.requestSignerClassFqcn != null;
    }

    public String getRequestSignerClassFqcn() {
        return this.requestSignerClassFqcn;
    }

    public void setRequestSignerClassFqcn(String authorizerClass) {
        this.requestSignerClassFqcn = authorizerClass;
    }

    public EndpointDiscovery getEndpointDiscovery() {
        return this.endpointDiscovery;
    }

    public void setEndpointDiscovery(EndpointDiscovery endpointDiscovery) {
        this.endpointDiscovery = endpointDiscovery;
    }

    public boolean isEventStream() {
        return this.isEventStream;
    }

    public ShapeModel withIsEventStream(boolean isEventStream) {
        this.isEventStream = isEventStream;
        return this;
    }

    public boolean isEvent() {
        return this.isEvent;
    }

    public ShapeModel withIsEvent(boolean isEvent) {
        this.isEvent = isEvent;
        return this;
    }

    public XmlNamespace getXmlNamespace() {
        return this.xmlNamespace;
    }

    public ShapeModel withXmlNamespace(XmlNamespace xmlNamespace) {
        this.xmlNamespace = xmlNamespace;
        return this;
    }

    public void setXmlNamespace(XmlNamespace xmlNamespace) {
        this.xmlNamespace = xmlNamespace;
    }

    public boolean isDocument() {
        return this.document;
    }

    public ShapeModel withIsDocument(boolean document) {
        this.document = document;
        return this;
    }
}

