/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.codegen.poet.client.specs;

import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.codegen.model.intermediate.IntermediateModel;
import software.amazon.awssdk.codegen.model.intermediate.OperationModel;
import software.amazon.awssdk.codegen.poet.PoetExtensions;
import software.amazon.awssdk.codegen.poet.client.specs.QueryProtocolSpec;
import software.amazon.awssdk.core.Response;
import software.amazon.awssdk.core.client.handler.ClientExecutionParams;
import software.amazon.awssdk.core.http.HttpResponseHandler;
import software.amazon.awssdk.protocols.xml.AwsXmlProtocolFactory;
import software.amazon.awssdk.protocols.xml.XmlOperationMetadata;
import software.amazon.awssdk.utils.CompletableFutureUtils;

public final class XmlProtocolSpec
extends QueryProtocolSpec {
    private final IntermediateModel model;

    public XmlProtocolSpec(IntermediateModel model, PoetExtensions poetExtensions) {
        super(model, poetExtensions);
        this.model = model;
    }

    @Override
    protected Class<?> protocolFactoryClass() {
        if (this.model.getCustomizationConfig().getCustomProtocolFactoryFqcn() != null) {
            try {
                return Class.forName(this.model.getCustomizationConfig().getCustomProtocolFactoryFqcn());
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException("Could not find custom protocol factory class", e);
            }
        }
        return AwsXmlProtocolFactory.class;
    }

    @Override
    public CodeBlock responseHandler(IntermediateModel model, OperationModel opModel) {
        if (opModel.hasStreamingOutput()) {
            return this.streamingResponseHandler(opModel);
        }
        ClassName responseType = this.poetExtensions.getModelClass(opModel.getReturnType().getReturnType());
        ParameterizedTypeName handlerType = ParameterizedTypeName.get((ClassName)ClassName.get(HttpResponseHandler.class), (TypeName[])new TypeName[]{ParameterizedTypeName.get((ClassName)ClassName.get(Response.class), (TypeName[])new TypeName[]{responseType})});
        return CodeBlock.builder().addStatement("\n\n$T responseHandler = protocolFactory.createCombinedResponseHandler($T::builder,new $T().withHasStreamingSuccessResponse($L))", new Object[]{handlerType, responseType, XmlOperationMetadata.class, opModel.hasStreamingOutput()}).build();
    }

    private CodeBlock streamingResponseHandler(OperationModel opModel) {
        ClassName responseType = this.poetExtensions.getModelClass(opModel.getReturnType().getReturnType());
        return CodeBlock.builder().addStatement("\n\n$T<$T> responseHandler = protocolFactory.createResponseHandler($T::builder,new $T().withHasStreamingSuccessResponse($L))", new Object[]{HttpResponseHandler.class, responseType, responseType, XmlOperationMetadata.class, opModel.hasStreamingOutput()}).build();
    }

    @Override
    public Optional<CodeBlock> errorResponseHandler(OperationModel opModel) {
        return opModel.hasStreamingOutput() ? this.streamingErrorResponseHandler(opModel) : Optional.empty();
    }

    private Optional<CodeBlock> streamingErrorResponseHandler(OperationModel opModel) {
        return super.errorResponseHandler(opModel);
    }

    @Override
    public CodeBlock executionHandler(OperationModel opModel) {
        if (opModel.hasStreamingOutput()) {
            return this.streamingExecutionHandler(opModel);
        }
        ClassName responseType = this.poetExtensions.getModelClass(opModel.getReturnType().getReturnType());
        ClassName requestType = this.poetExtensions.getModelClass(opModel.getInput().getVariableType());
        ClassName marshaller = this.poetExtensions.getTransformClass(opModel.getInputShape().getShapeName() + "Marshaller");
        CodeBlock.Builder codeBlock = CodeBlock.builder().add("\n\nreturn clientHandler.execute(new $T<$T, $T>().withOperationName(\"$N\")\n.withCombinedResponseHandler($N).withMetricCollector(apiCallMetricCollector)\n" + this.hostPrefixExpression(opModel) + this.discoveredEndpoint(opModel) + ".withInput($L)", new Object[]{ClientExecutionParams.class, requestType, responseType, opModel.getOperationName(), "responseHandler", opModel.getInput().getVariableName()});
        codeBlock.add(".withMetricCollector($N)", new Object[]{"apiCallMetricCollector"});
        if (opModel.hasStreamingInput()) {
            return codeBlock.add(".withRequestBody(requestBody)", new Object[0]).add(".withMarshaller($L));", new Object[]{this.syncStreamingMarshaller(this.intermediateModel, opModel, marshaller)}).build();
        }
        return codeBlock.add(".withMarshaller(new $T(protocolFactory)) $L);", new Object[]{marshaller, opModel.hasStreamingOutput() ? ", responseTransformer" : ""}).build();
    }

    private CodeBlock streamingExecutionHandler(OperationModel opModel) {
        return super.executionHandler(opModel);
    }

    @Override
    public CodeBlock asyncExecutionHandler(IntermediateModel intermediateModel, OperationModel opModel) {
        if (opModel.hasStreamingOutput()) {
            return this.asyncStreamingExecutionHandler(intermediateModel, opModel);
        }
        ClassName pojoResponseType = this.poetExtensions.getModelClass(opModel.getReturnType().getReturnType());
        ClassName requestType = this.poetExtensions.getModelClass(opModel.getInput().getVariableType());
        ClassName marshaller = this.poetExtensions.getRequestTransformClass(opModel.getInputShape().getShapeName() + "Marshaller");
        String asyncRequestBody = opModel.hasStreamingInput() ? ".withAsyncRequestBody(requestBody)" : "";
        TypeName executeFutureValueType = this.executeFutureValueType(opModel, this.poetExtensions);
        CodeBlock.Builder builder = CodeBlock.builder().add("\n\n$T<$T> executeFuture = clientHandler.execute(new $T<$T, $T>()\n.withOperationName(\"$N\")\n.withMarshaller($L).withCombinedResponseHandler($N)" + this.hostPrefixExpression(opModel) + asyncRequestBody + ".withInput($L) $L);", new Object[]{CompletableFuture.class, executeFutureValueType, ClientExecutionParams.class, requestType, pojoResponseType, opModel.getOperationName(), this.asyncMarshaller(intermediateModel, opModel, marshaller, "protocolFactory"), "responseHandler", opModel.getInput().getVariableName(), opModel.hasStreamingOutput() ? ", asyncResponseTransformer" : ""});
        builder.addStatement("$T requestOverrideConfig = $L.overrideConfiguration().orElse(null)", new Object[]{AwsRequestOverrideConfiguration.class, opModel.getInput().getVariableName()});
        String whenCompleteFutureName = "whenCompleteFuture";
        builder.addStatement("$T $N = null", new Object[]{ParameterizedTypeName.get((ClassName)ClassName.get(CompletableFuture.class), (TypeName[])new TypeName[]{executeFutureValueType}), whenCompleteFutureName});
        if (opModel.hasStreamingOutput()) {
            builder.addStatement("$N = executeFuture$L", new Object[]{whenCompleteFutureName, this.streamingOutputWhenComplete("asyncResponseTransformer")});
        } else {
            builder.addStatement("$N = executeFuture$L", new Object[]{whenCompleteFutureName, this.publishMetricsWhenComplete()});
        }
        builder.addStatement("return $T.forwardExceptionTo($N, executeFuture)", new Object[]{CompletableFutureUtils.class, whenCompleteFutureName});
        return builder.build();
    }

    private CodeBlock asyncStreamingExecutionHandler(IntermediateModel intermediateModel, OperationModel opModel) {
        return super.asyncExecutionHandler(intermediateModel, opModel);
    }
}

