/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.codegen.poet.model;

import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.FieldSpec;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import com.squareup.javapoet.WildcardTypeName;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import javax.lang.model.element.Modifier;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.codegen.model.intermediate.IntermediateModel;
import software.amazon.awssdk.codegen.model.intermediate.MemberModel;
import software.amazon.awssdk.codegen.model.intermediate.ShapeModel;
import software.amazon.awssdk.codegen.model.intermediate.ShapeType;
import software.amazon.awssdk.codegen.poet.PoetExtensions;
import software.amazon.awssdk.codegen.poet.model.AccessorsFactory;
import software.amazon.awssdk.codegen.poet.model.AwsServiceBaseRequestSpec;
import software.amazon.awssdk.codegen.poet.model.AwsServiceBaseResponseSpec;
import software.amazon.awssdk.codegen.poet.model.ExceptionProperties;
import software.amazon.awssdk.codegen.poet.model.TypeProvider;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.utils.builder.CopyableBuilder;

class ModelBuilderSpecs {
    private final IntermediateModel intermediateModel;
    private final ShapeModel shapeModel;
    private final TypeProvider typeProvider;
    private final PoetExtensions poetExtensions;
    private final AccessorsFactory accessorsFactory;

    ModelBuilderSpecs(IntermediateModel intermediateModel, ShapeModel shapeModel, TypeProvider typeProvider) {
        this.intermediateModel = intermediateModel;
        this.shapeModel = shapeModel;
        this.typeProvider = typeProvider;
        this.poetExtensions = new PoetExtensions(this.intermediateModel);
        this.accessorsFactory = new AccessorsFactory(this.shapeModel, this.intermediateModel, this.typeProvider, this.poetExtensions);
    }

    public ClassName builderInterfaceName() {
        return this.classToBuild().nestedClass("Builder");
    }

    public ClassName builderImplName() {
        return this.classToBuild().nestedClass("BuilderImpl");
    }

    public TypeSpec builderInterface() {
        TypeSpec.Builder builder = TypeSpec.interfaceBuilder((ClassName)this.builderInterfaceName()).addSuperinterfaces(this.builderSuperInterfaces()).addModifiers(new Modifier[]{Modifier.PUBLIC});
        this.shapeModel.getNonStreamingMembers().forEach(m -> {
            builder.addMethods(this.accessorsFactory.fluentSetterDeclarations((MemberModel)m, (TypeName)this.builderInterfaceName()));
            builder.addMethods(this.accessorsFactory.convenienceSetterDeclarations((MemberModel)m, (TypeName)this.builderInterfaceName()));
        });
        if (this.isException()) {
            builder.addSuperinterface((TypeName)this.parentExceptionBuilder().nestedClass("Builder"));
            builder.addMethods(ExceptionProperties.builderInterfaceMethods(this.builderInterfaceName()));
        }
        if (this.isRequest()) {
            builder.addMethod(MethodSpec.methodBuilder((String)"overrideConfiguration").returns((TypeName)this.builderInterfaceName()).addAnnotation(Override.class).addParameter(AwsRequestOverrideConfiguration.class, "overrideConfiguration", new Modifier[0]).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.ABSTRACT}).build());
            builder.addMethod(MethodSpec.methodBuilder((String)"overrideConfiguration").addAnnotation(Override.class).returns((TypeName)this.builderInterfaceName()).addParameter((TypeName)ParameterizedTypeName.get(Consumer.class, (Type[])new Type[]{AwsRequestOverrideConfiguration.Builder.class}), "builderConsumer", new Modifier[0]).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.ABSTRACT}).build());
        }
        return builder.build();
    }

    private ClassName parentExceptionBuilder() {
        String customExceptionBase = this.intermediateModel.getCustomizationConfig().getSdkModeledExceptionBaseClassName();
        if (customExceptionBase != null) {
            return this.poetExtensions.getModelClass(customExceptionBase);
        }
        return this.poetExtensions.getModelClass(this.intermediateModel.getSdkModeledExceptionBaseClassName());
    }

    public TypeSpec beanStyleBuilder() {
        TypeSpec.Builder builderClassBuilder = TypeSpec.classBuilder((ClassName)this.builderImplName()).addSuperinterface((TypeName)this.builderInterfaceName()).superclass(this.builderImplSuperClass()).addModifiers(new Modifier[]{Modifier.STATIC, Modifier.FINAL});
        if (this.isException()) {
            builderClassBuilder.superclass((TypeName)this.parentExceptionBuilder().nestedClass("BuilderImpl"));
        }
        builderClassBuilder.addFields(this.fields());
        builderClassBuilder.addMethod(this.noargConstructor());
        builderClassBuilder.addMethod(this.modelCopyConstructor());
        builderClassBuilder.addMethods(this.accessors());
        builderClassBuilder.addMethod(this.buildMethod());
        builderClassBuilder.addMethod(this.sdkFieldsMethod());
        return builderClassBuilder.build();
    }

    private MethodSpec sdkFieldsMethod() {
        ParameterizedTypeName sdkFieldType = ParameterizedTypeName.get((ClassName)ClassName.get(SdkField.class), (TypeName[])new TypeName[]{WildcardTypeName.subtypeOf((TypeName)ClassName.get(Object.class))});
        return MethodSpec.methodBuilder((String)"sdkFields").addModifiers(new Modifier[]{Modifier.PUBLIC}).addAnnotation(Override.class).returns((TypeName)ParameterizedTypeName.get((ClassName)ClassName.get(List.class), (TypeName[])new TypeName[]{sdkFieldType})).addCode("return SDK_FIELDS;", new Object[0]).build();
    }

    private TypeName builderImplSuperClass() {
        if (this.isRequest()) {
            return new AwsServiceBaseRequestSpec(this.intermediateModel).className().nestedClass("BuilderImpl");
        }
        if (this.isResponse()) {
            return new AwsServiceBaseResponseSpec(this.intermediateModel).className().nestedClass("BuilderImpl");
        }
        return ClassName.OBJECT;
    }

    private List<FieldSpec> fields() {
        List<FieldSpec> fields = this.shapeModel.getNonStreamingMembers().stream().map(m -> {
            FieldSpec fieldSpec = this.typeProvider.asField((MemberModel)m, Modifier.PRIVATE);
            if (m.isList() && this.typeProvider.useAutoConstructLists()) {
                fieldSpec = fieldSpec.toBuilder().initializer("$T.getInstance()", new Object[]{DefaultSdkAutoConstructList.class}).build();
            } else if (m.isMap() && this.typeProvider.useAutoConstructMaps()) {
                fieldSpec = fieldSpec.toBuilder().initializer("$T.getInstance()", new Object[]{DefaultSdkAutoConstructMap.class}).build();
            }
            return fieldSpec;
        }).collect(Collectors.toList());
        return fields;
    }

    private MethodSpec noargConstructor() {
        MethodSpec.Builder ctorBuilder = MethodSpec.constructorBuilder().addModifiers(new Modifier[]{Modifier.PRIVATE});
        return ctorBuilder.build();
    }

    private MethodSpec modelCopyConstructor() {
        MethodSpec.Builder copyBuilderCtor = MethodSpec.constructorBuilder().addModifiers(new Modifier[]{Modifier.PRIVATE}).addParameter((TypeName)this.classToBuild(), "model", new Modifier[0]);
        if (this.isRequest() || this.isResponse() || this.isException()) {
            copyBuilderCtor.addCode("super(model);", new Object[0]);
        }
        this.shapeModel.getNonStreamingMembers().forEach(m -> {
            String name = m.getVariable().getVariableName();
            copyBuilderCtor.addStatement("$N(model.$N)", new Object[]{m.getFluentSetterMethodName(), name});
        });
        return copyBuilderCtor.build();
    }

    private List<MethodSpec> accessors() {
        ArrayList<MethodSpec> accessors = new ArrayList<MethodSpec>();
        this.shapeModel.getNonStreamingMembers().forEach(m -> {
            accessors.add(this.accessorsFactory.beanStyleGetter((MemberModel)m));
            accessors.addAll(this.accessorsFactory.fluentSetters((MemberModel)m, (TypeName)this.builderInterfaceName()));
            accessors.addAll(this.accessorsFactory.beanStyleSetters((MemberModel)m));
            accessors.addAll(this.accessorsFactory.convenienceSetters((MemberModel)m, (TypeName)this.builderInterfaceName()));
        });
        if (this.isException()) {
            accessors.addAll(ExceptionProperties.builderImplMethods(this.builderImplName()));
        }
        if (this.isRequest()) {
            accessors.add(MethodSpec.methodBuilder((String)"overrideConfiguration").addAnnotation(Override.class).returns((TypeName)this.builderInterfaceName()).addParameter(AwsRequestOverrideConfiguration.class, "overrideConfiguration", new Modifier[0]).addModifiers(new Modifier[]{Modifier.PUBLIC}).addStatement("super.overrideConfiguration(overrideConfiguration)", new Object[0]).addStatement("return this", new Object[0]).build());
            accessors.add(MethodSpec.methodBuilder((String)"overrideConfiguration").addAnnotation(Override.class).returns((TypeName)this.builderInterfaceName()).addParameter((TypeName)ParameterizedTypeName.get(Consumer.class, (Type[])new Type[]{AwsRequestOverrideConfiguration.Builder.class}), "builderConsumer", new Modifier[0]).addModifiers(new Modifier[]{Modifier.PUBLIC}).addStatement("super.overrideConfiguration(builderConsumer)", new Object[0]).addStatement("return this", new Object[0]).build());
        }
        return accessors;
    }

    private MethodSpec buildMethod() {
        return MethodSpec.methodBuilder((String)"build").addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PUBLIC}).returns((TypeName)this.classToBuild()).addStatement("return new $T(this)", new Object[]{this.classToBuild()}).build();
    }

    private ClassName classToBuild() {
        return this.poetExtensions.getModelClass(this.shapeModel.getShapeName());
    }

    private boolean isException() {
        return this.shapeModel.getShapeType() == ShapeType.Exception;
    }

    private boolean isRequest() {
        return this.shapeModel.getShapeType() == ShapeType.Request;
    }

    private boolean isResponse() {
        return this.shapeModel.getShapeType() == ShapeType.Response;
    }

    private List<TypeName> builderSuperInterfaces() {
        ArrayList<TypeName> superInterfaces = new ArrayList<TypeName>();
        if (this.isRequest()) {
            superInterfaces.add((TypeName)new AwsServiceBaseRequestSpec(this.intermediateModel).className().nestedClass("Builder"));
        }
        if (this.isResponse()) {
            superInterfaces.add((TypeName)new AwsServiceBaseResponseSpec(this.intermediateModel).className().nestedClass("Builder"));
        }
        superInterfaces.add((TypeName)ClassName.get(SdkPojo.class));
        superInterfaces.add((TypeName)ParameterizedTypeName.get((ClassName)ClassName.get(CopyableBuilder.class), (TypeName[])new TypeName[]{this.classToBuild().nestedClass("Builder"), this.classToBuild()}));
        return superInterfaces;
    }
}

