/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.codegen.poet.model;

import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.FieldSpec;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.WildcardTypeName;
import java.io.InputStream;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import javax.lang.model.element.Modifier;
import software.amazon.awssdk.codegen.model.intermediate.IntermediateModel;
import software.amazon.awssdk.codegen.model.intermediate.ListModel;
import software.amazon.awssdk.codegen.model.intermediate.MapModel;
import software.amazon.awssdk.codegen.model.intermediate.MemberModel;
import software.amazon.awssdk.codegen.poet.PoetExtensions;
import software.amazon.awssdk.core.SdkBytes;

public class TypeProvider {
    private final IntermediateModel intermediateModel;
    private final PoetExtensions poetExtensions;

    public TypeProvider(IntermediateModel intermediateModel) {
        this.intermediateModel = intermediateModel;
        this.poetExtensions = new PoetExtensions(this.intermediateModel);
    }

    public ClassName listImplClassName() {
        return ClassName.get(ArrayList.class);
    }

    public boolean useAutoConstructLists() {
        return this.intermediateModel.getCustomizationConfig().isUseAutoConstructList();
    }

    public boolean useAutoConstructMaps() {
        return this.intermediateModel.getCustomizationConfig().isUseAutoConstructMap();
    }

    public TypeName enumReturnType(MemberModel memberModel) {
        return this.fieldType(memberModel, true);
    }

    public TypeName returnType(MemberModel memberModel) {
        if (memberModel.getVariable().getVariableType().endsWith("SdkBytes")) {
            return TypeName.get(SdkBytes.class);
        }
        return this.fieldType(memberModel, false);
    }

    public TypeName fieldType(MemberModel memberModel) {
        return this.fieldType(memberModel, false);
    }

    private TypeName fieldType(MemberModel memberModel, boolean preserveEnumType) {
        if (memberModel.isSimple()) {
            boolean isEnumMember = memberModel.getEnumType() != null;
            return preserveEnumType && isEnumMember ? this.poetExtensions.getModelClass(memberModel.getEnumType()) : this.getTypeNameForSimpleType(memberModel.getVariable().getVariableType());
        }
        if (memberModel.isList()) {
            TypeName elementType = this.fieldType(memberModel.getListModel().getListMemberModel(), preserveEnumType);
            return ParameterizedTypeName.get((ClassName)ClassName.get(List.class), (TypeName[])new TypeName[]{elementType});
        }
        if (memberModel.isMap()) {
            TypeName keyType = this.fieldType(memberModel.getMapModel().getKeyModel(), preserveEnumType);
            TypeName valueType = this.fieldType(memberModel.getMapModel().getValueModel(), preserveEnumType);
            return ParameterizedTypeName.get((ClassName)ClassName.get(Map.class), (TypeName[])new TypeName[]{keyType, valueType});
        }
        return this.poetExtensions.getModelClass(memberModel.getC2jShape());
    }

    public TypeName parameterType(MemberModel memberModel) {
        return this.parameterType(memberModel, false);
    }

    public TypeName parameterType(MemberModel memberModel, boolean preserveEnum) {
        if (memberModel.isList()) {
            return this.listParameterType(memberModel.getListModel(), preserveEnum);
        }
        if (memberModel.isMap()) {
            MapModel mapModel = memberModel.getMapModel();
            TypeName keyType = this.mapKeyParameterType(mapModel, preserveEnum);
            TypeName valueType = this.mapValueParameterType(mapModel, preserveEnum);
            return ParameterizedTypeName.get((ClassName)ClassName.get(Map.class), (TypeName[])new TypeName[]{keyType, valueType});
        }
        return this.fieldType(memberModel, preserveEnum);
    }

    public TypeName mapEntryWithConcreteTypes(MapModel mapModel) {
        TypeName keyType = this.fieldType(mapModel.getKeyModel());
        TypeName valueType = this.fieldType(mapModel.getValueModel());
        return ParameterizedTypeName.get((ClassName)ClassName.get(Map.Entry.class), (TypeName[])new TypeName[]{keyType, valueType});
    }

    public TypeName getTypeNameForSimpleType(String simpleType) {
        return (TypeName)Stream.of(String.class, Boolean.class, Integer.class, Long.class, Short.class, Byte.class, BigInteger.class, Double.class, Float.class, BigDecimal.class, SdkBytes.class, InputStream.class, Instant.class).filter(cls -> cls.getName().equals(simpleType) || cls.getSimpleName().equals(simpleType)).map(ClassName::get).findFirst().orElseThrow(() -> new RuntimeException("Unsupported simple fieldType " + simpleType));
    }

    public FieldSpec asField(MemberModel memberModel, Modifier ... modifiers) {
        FieldSpec.Builder builder = FieldSpec.builder((TypeName)this.fieldType(memberModel), (String)memberModel.getVariable().getVariableName(), (Modifier[])new Modifier[0]);
        if (modifiers != null) {
            builder.addModifiers(modifiers);
        }
        return builder.build();
    }

    private TypeName listParameterType(ListModel listModel, boolean preserveEnum) {
        MemberModel elementModel = listModel.getListMemberModel();
        TypeName listElementType = this.parameterType(elementModel, preserveEnum);
        if (TypeProvider.isContainerType(elementModel)) {
            listElementType = WildcardTypeName.subtypeOf((TypeName)listElementType);
        }
        return ParameterizedTypeName.get((ClassName)ClassName.get(Collection.class), (TypeName[])new TypeName[]{listElementType});
    }

    private TypeName mapKeyParameterType(MapModel mapModel, boolean preserveEnum) {
        MemberModel keyModel = mapModel.getKeyModel();
        Object keyType = mapModel.getKeyModel().isSimple() ? (preserveEnum && keyModel.getEnumType() != null ? this.poetExtensions.getModelClass(keyModel.getEnumType()) : this.getTypeNameForSimpleType(keyModel.getVariable().getVariableType())) : this.parameterType(keyModel, preserveEnum);
        return keyType;
    }

    private TypeName mapValueParameterType(MapModel mapModel, boolean preserveEnum) {
        TypeName valueType = this.parameterType(mapModel.getValueModel(), preserveEnum);
        if (mapModel.getValueModel().isList()) {
            valueType = WildcardTypeName.subtypeOf((TypeName)valueType);
        }
        return valueType;
    }

    private static boolean isContainerType(MemberModel m) {
        return m.isList() || m.isMap();
    }
}

