/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.codegen.model.intermediate;

import software.amazon.awssdk.codegen.model.intermediate.Protocol;
import software.amazon.awssdk.codegen.model.service.AuthType;
import software.amazon.awssdk.utils.StringUtils;

public class Metadata {
    private String apiVersion;
    private Protocol protocol;
    private String documentation;
    private String defaultEndpoint;
    private String defaultRegion;
    private String defaultEndpointWithoutHttpProtocol;
    private String syncInterface;
    private String syncClient;
    private String syncBuilderInterface;
    private String syncBuilder;
    private String asyncInterface;
    private String asyncClient;
    private String asyncBuilderInterface;
    private String asyncBuilder;
    private String baseBuilderInterface;
    private String baseBuilder;
    private String rootPackageName;
    private String clientPackageName;
    private String modelPackageName;
    private String transformPackageName;
    private String requestTransformPackageName;
    private String paginatorsPackageName;
    private String authPolicyPackageName;
    private String serviceAbbreviation;
    private String serviceFullName;
    private String serviceName;
    private String baseExceptionName;
    private String contentType;
    private String jsonVersion;
    private String endpointPrefix;
    private String signingName;
    private boolean requiresIamSigners;
    private boolean requiresApiKey;
    private String uid;
    private AuthType authType;
    private String baseRequestName;
    private String baseResponseName;
    private boolean supportsH2;
    private String serviceId;

    public String getApiVersion() {
        return this.apiVersion;
    }

    public void setApiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
    }

    public Metadata withApiVersion(String apiVersion) {
        this.setApiVersion(apiVersion);
        return this;
    }

    public Protocol getProtocol() {
        return this.protocol;
    }

    public void setProtocol(Protocol protocol) {
        this.protocol = protocol;
    }

    public Metadata withProtocol(Protocol protocol) {
        this.setProtocol(protocol);
        return this;
    }

    public String getDocumentation() {
        return this.documentation;
    }

    public void setDocumentation(String documentation) {
        this.documentation = documentation;
    }

    public Metadata withDocumentation(String documentation) {
        this.setDocumentation(documentation);
        return this;
    }

    public String getDefaultEndpoint() {
        return this.defaultEndpoint;
    }

    public void setDefaultEndpoint(String defaultEndpoint) {
        this.defaultEndpoint = defaultEndpoint;
    }

    public Metadata withDefaultEndpoint(String defaultEndpoint) {
        this.setDefaultEndpoint(defaultEndpoint);
        return this;
    }

    public String getDefaultRegion() {
        return this.defaultRegion;
    }

    public void setDefaultRegion(String defaultRegion) {
        this.defaultRegion = defaultRegion;
    }

    public Metadata withDefaultRegion(String defaultRegion) {
        this.setDefaultRegion(defaultRegion);
        return this;
    }

    public String getDefaultEndpointWithoutHttpProtocol() {
        return this.defaultEndpointWithoutHttpProtocol;
    }

    public void setDefaultEndpointWithoutHttpProtocol(String defaultEndpointWithoutHttpProtocol) {
        this.defaultEndpointWithoutHttpProtocol = defaultEndpointWithoutHttpProtocol;
    }

    public Metadata withDefaultEndpointWithoutHttpProtocol(String defaultEndpointWithoutHttpProtocol) {
        this.setDefaultEndpointWithoutHttpProtocol(defaultEndpointWithoutHttpProtocol);
        return this;
    }

    public String getSyncInterface() {
        return this.syncInterface;
    }

    public void setSyncInterface(String syncInterface) {
        this.syncInterface = syncInterface;
    }

    public Metadata withSyncInterface(String syncInterface) {
        this.setSyncInterface(syncInterface);
        return this;
    }

    public String getSyncClient() {
        return this.syncClient;
    }

    public void setSyncClient(String syncClient) {
        this.syncClient = syncClient;
    }

    public Metadata withSyncClient(String syncClient) {
        this.setSyncClient(syncClient);
        return this;
    }

    public String getSyncBuilderInterface() {
        return this.syncBuilderInterface;
    }

    public void setSyncBuilderInterface(String syncBuilderInterface) {
        this.syncBuilderInterface = syncBuilderInterface;
    }

    public Metadata withSyncBuilderInterface(String syncBuilderInterface) {
        this.syncBuilderInterface = syncBuilderInterface;
        return this;
    }

    public String getSyncBuilder() {
        return this.syncBuilder;
    }

    public void setSyncBuilder(String syncBuilder) {
        this.syncBuilder = syncBuilder;
    }

    public Metadata withSyncBuilder(String syncBuilder) {
        this.syncBuilder = syncBuilder;
        return this;
    }

    public String getAsyncInterface() {
        return this.asyncInterface;
    }

    public void setAsyncInterface(String asyncInterface) {
        this.asyncInterface = asyncInterface;
    }

    public Metadata withAsyncInterface(String asyncInterface) {
        this.setAsyncInterface(asyncInterface);
        return this;
    }

    public String getAsyncClient() {
        return this.asyncClient;
    }

    public void setAsyncClient(String asyncClient) {
        this.asyncClient = asyncClient;
    }

    public Metadata withAsyncClient(String asyncClient) {
        this.setAsyncClient(asyncClient);
        return this;
    }

    public String getAsyncBuilderInterface() {
        return this.asyncBuilderInterface;
    }

    public void setAsyncBuilderInterface(String asyncBuilderInterface) {
        this.asyncBuilderInterface = asyncBuilderInterface;
    }

    public Metadata withAsyncBuilderInterface(String asyncBuilderInterface) {
        this.asyncBuilderInterface = asyncBuilderInterface;
        return this;
    }

    public String getBaseBuilderInterface() {
        return this.baseBuilderInterface;
    }

    public void setBaseBuilderInterface(String baseBuilderInterface) {
        this.baseBuilderInterface = baseBuilderInterface;
    }

    public Metadata withBaseBuilderInterface(String baseBuilderInterface) {
        this.baseBuilderInterface = baseBuilderInterface;
        return this;
    }

    public String getBaseBuilder() {
        return this.baseBuilder;
    }

    public void setBaseBuilder(String baseBuilder) {
        this.baseBuilder = baseBuilder;
    }

    public Metadata withBaseBuilder(String baseBuilder) {
        this.baseBuilder = baseBuilder;
        return this;
    }

    public String getAsyncBuilder() {
        return this.asyncBuilder;
    }

    public void setAsyncBuilder(String asyncBuilder) {
        this.asyncBuilder = asyncBuilder;
    }

    public Metadata withAsyncBuilder(String asyncBuilder) {
        this.asyncBuilder = asyncBuilder;
        return this;
    }

    public String getBaseExceptionName() {
        return this.baseExceptionName;
    }

    public void setBaseExceptionName(String baseExceptionName) {
        this.baseExceptionName = baseExceptionName;
    }

    public Metadata withBaseExceptionName(String baseExceptionName) {
        this.setBaseExceptionName(baseExceptionName);
        return this;
    }

    public String getRootPackageName() {
        return this.rootPackageName;
    }

    public void setRootPackageName(String rootPackageName) {
        this.rootPackageName = rootPackageName;
    }

    public Metadata withRootPackageName(String rootPackageName) {
        this.setRootPackageName(rootPackageName);
        return this;
    }

    public String getFullClientPackageName() {
        return this.joinPackageNames(this.rootPackageName, this.getClientPackageName());
    }

    public String getClientPackageName() {
        return this.clientPackageName;
    }

    public void setClientPackageName(String clientPackageName) {
        this.clientPackageName = clientPackageName;
    }

    public Metadata withClientPackageName(String clientPackageName) {
        this.setClientPackageName(clientPackageName);
        return this;
    }

    public String getFullModelPackageName() {
        return this.joinPackageNames(this.rootPackageName, this.getModelPackageName());
    }

    public String getModelPackageName() {
        return this.modelPackageName;
    }

    public void setModelPackageName(String modelPackageName) {
        this.modelPackageName = modelPackageName;
    }

    public Metadata withModelPackageName(String modelPackageName) {
        this.setModelPackageName(modelPackageName);
        return this;
    }

    public String getFullTransformPackageName() {
        return this.joinPackageNames(this.rootPackageName, this.getTransformPackageName());
    }

    public String getTransformPackageName() {
        return this.transformPackageName;
    }

    public void setTransformPackageName(String transformPackageName) {
        this.transformPackageName = transformPackageName;
    }

    public Metadata withTransformPackageName(String transformPackageName) {
        this.setTransformPackageName(transformPackageName);
        return this;
    }

    public String getFullRequestTransformPackageName() {
        return this.joinPackageNames(this.rootPackageName, this.getRequestTransformPackageName());
    }

    public String getRequestTransformPackageName() {
        return this.requestTransformPackageName;
    }

    public void setRequestTransformPackageName(String requestTransformPackageName) {
        this.requestTransformPackageName = requestTransformPackageName;
    }

    public Metadata withRequestTransformPackageName(String requestTransformPackageName) {
        this.setRequestTransformPackageName(requestTransformPackageName);
        return this;
    }

    public String getFullPaginatorsPackageName() {
        return this.joinPackageNames(this.rootPackageName, this.getPaginatorsPackageName());
    }

    public String getPaginatorsPackageName() {
        return this.paginatorsPackageName;
    }

    public void setPaginatorsPackageName(String paginatorsPackageName) {
        this.paginatorsPackageName = paginatorsPackageName;
    }

    public Metadata withPaginatorsPackageName(String paginatorsPackageName) {
        this.setPaginatorsPackageName(paginatorsPackageName);
        return this;
    }

    public String getFullAuthPolicyPackageName() {
        return this.joinPackageNames(this.rootPackageName, this.getAuthPolicyPackageName());
    }

    public String getAuthPolicyPackageName() {
        return this.authPolicyPackageName;
    }

    public void setAuthPolicyPackageName(String authPolicyPackageName) {
        this.authPolicyPackageName = authPolicyPackageName;
    }

    public Metadata withAuthPolicyPackageName(String authPolicyPackageName) {
        this.setAuthPolicyPackageName(authPolicyPackageName);
        return this;
    }

    public void setServiceAbbreviation(String serviceAbbreviation) {
        this.serviceAbbreviation = serviceAbbreviation;
    }

    public Metadata withServiceAbbreviation(String serviceAbbreviation) {
        this.setServiceAbbreviation(serviceAbbreviation);
        return this;
    }

    public void setServiceFullName(String serviceFullName) {
        this.serviceFullName = serviceFullName;
    }

    public Metadata withServiceFullName(String serviceFullName) {
        this.setServiceFullName(serviceFullName);
        return this;
    }

    public String getDescriptiveServiceName() {
        if (this.serviceAbbreviation != null) {
            return this.serviceAbbreviation;
        }
        return this.serviceFullName;
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public void setServiceName(String serviceName) {
        this.serviceName = serviceName;
    }

    public Metadata withServiceName(String serviceName) {
        this.setServiceName(serviceName);
        return this;
    }

    public String getJsonVersion() {
        return this.jsonVersion;
    }

    public void setJsonVersion(String jsonVersion) {
        this.jsonVersion = jsonVersion;
    }

    public Metadata withJsonVersion(String jsonVersion) {
        this.setJsonVersion(jsonVersion);
        return this;
    }

    public boolean isIonProtocol() {
        return this.protocol == Protocol.ION;
    }

    public boolean isCborProtocol() {
        return this.protocol == Protocol.CBOR;
    }

    public boolean isJsonProtocol() {
        return this.protocol == Protocol.CBOR || this.protocol == Protocol.ION || this.protocol == Protocol.AWS_JSON || this.protocol == Protocol.API_GATEWAY || this.protocol == Protocol.REST_JSON;
    }

    public boolean isXmlProtocol() {
        return this.protocol == Protocol.EC2 || this.protocol == Protocol.QUERY || this.protocol == Protocol.REST_XML;
    }

    public static boolean isNotRestProtocol(String protocol) {
        switch (Protocol.fromValue(protocol)) {
            case API_GATEWAY: 
            case REST_JSON: 
            case REST_XML: {
                return false;
            }
        }
        return true;
    }

    public String getEndpointPrefix() {
        return this.endpointPrefix;
    }

    public void setEndpointPrefix(String endpointPrefix) {
        this.endpointPrefix = endpointPrefix;
    }

    public Metadata withEndpointPrefix(String endpointPrefix) {
        this.setEndpointPrefix(endpointPrefix);
        return this;
    }

    public String getSigningName() {
        return this.signingName;
    }

    public void setSigningName(String signingName) {
        this.signingName = signingName;
    }

    public Metadata withSigningName(String signingName) {
        this.setSigningName(signingName);
        return this;
    }

    public void setContentType(String contentType) {
        this.contentType = contentType;
    }

    public String getContentType() {
        return this.contentType;
    }

    public boolean isRequiresIamSigners() {
        return this.requiresIamSigners;
    }

    public void setRequiresIamSigners(boolean requiresIamSigners) {
        this.requiresIamSigners = requiresIamSigners;
    }

    public boolean isRequiresApiKey() {
        return this.requiresApiKey;
    }

    public Metadata withRequiresApiKey(boolean requiresApiKey) {
        this.requiresApiKey = requiresApiKey;
        return this;
    }

    public String getUid() {
        return this.uid;
    }

    public void setUid(String uid) {
        this.uid = uid;
    }

    public Metadata withUid(String uid) {
        this.setUid(uid);
        return this;
    }

    public AuthType getAuthType() {
        return this.authType;
    }

    public void setAuthType(AuthType authType) {
        this.authType = authType;
    }

    public Metadata withAuthType(AuthType authType) {
        this.authType = authType;
        return this;
    }

    public String getBaseRequestName() {
        return this.baseRequestName;
    }

    public Metadata withBaseRequestName(String baseRequestName) {
        this.baseRequestName = baseRequestName;
        return this;
    }

    public String getBaseResponseName() {
        return this.baseResponseName;
    }

    public Metadata withBaseResponseName(String baseResponseName) {
        this.baseResponseName = baseResponseName;
        return this;
    }

    private String joinPackageNames(String lhs, String rhs) {
        return StringUtils.isBlank((CharSequence)rhs) ? lhs : lhs + '.' + rhs;
    }

    public boolean supportsH2() {
        return this.supportsH2;
    }

    public void setSupportsH2(boolean supportsH2) {
        this.supportsH2 = supportsH2;
    }

    public Metadata withSupportsH2(boolean supportsH2) {
        this.setSupportsH2(supportsH2);
        return this;
    }

    public String getServiceId() {
        return this.serviceId;
    }

    public void setServiceId(String serviceId) {
        this.serviceId = serviceId;
    }

    public Metadata withServiceId(String serviceId) {
        this.setServiceId(serviceId);
        return this;
    }
}

