/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.codegen.poet.client;

import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.CodeBlock;
import java.util.Optional;
import software.amazon.awssdk.codegen.model.intermediate.OperationModel;
import software.amazon.awssdk.codegen.model.intermediate.ShapeModel;
import software.amazon.awssdk.http.HttpResponseHandler;

public final class ClientClassUtils {
    private ClientClassUtils() {
    }

    protected static Optional<CodeBlock> getCustomResponseHandler(OperationModel operationModel, ClassName returnType) {
        Optional<CodeBlock> customUnmarshaller = Optional.ofNullable(operationModel.getOutputShape()).map(ShapeModel::getCustomization).flatMap(c -> Optional.ofNullable(c.getCustomUnmarshallerFqcn()));
        return customUnmarshaller.map(unmarshaller -> {
            if (operationModel.hasStreamingOutput()) {
                throw new UnsupportedOperationException("Custom unmarshallers cannot be applied to streaming operations yet.");
            }
            return CodeBlock.builder().add("$T<$T> responseHandler = (response, __) -> new $T().unmarshall(response);", new Object[]{HttpResponseHandler.class, returnType, ClassName.bestGuess((String)unmarshaller)}).build();
        });
    }
}

