/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.codegen.poet.builder;

import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.FieldSpec;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import com.squareup.javapoet.TypeVariableName;
import javax.lang.model.element.Modifier;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.auth.Aws4Signer;
import software.amazon.awssdk.auth.QueryStringSigner;
import software.amazon.awssdk.auth.StaticSignerProvider;
import software.amazon.awssdk.client.builder.DefaultClientBuilder;
import software.amazon.awssdk.codegen.internal.Utils;
import software.amazon.awssdk.codegen.model.intermediate.IntermediateModel;
import software.amazon.awssdk.codegen.model.service.AuthType;
import software.amazon.awssdk.codegen.poet.ClassSpec;
import software.amazon.awssdk.codegen.poet.PoetUtils;
import software.amazon.awssdk.config.defaults.ClientConfigurationDefaults;
import software.amazon.awssdk.config.defaults.ServiceBuilderConfigurationDefaults;
import software.amazon.awssdk.runtime.auth.SignerProvider;
import software.amazon.awssdk.utils.AttributeMap;

public class BaseClientBuilderClass
implements ClassSpec {
    private final IntermediateModel model;
    private final ClassName builderInterfaceName;
    private final ClassName builderClassName;
    private final String basePackage;

    public BaseClientBuilderClass(IntermediateModel model) {
        this.model = model;
        this.basePackage = model.getMetadata().getFullClientPackageName();
        this.builderInterfaceName = ClassName.get((String)this.basePackage, (String)model.getMetadata().getBaseBuilderInterface(), (String[])new String[0]);
        this.builderClassName = ClassName.get((String)this.basePackage, (String)model.getMetadata().getBaseBuilder(), (String[])new String[0]);
    }

    @Override
    public TypeSpec poetSpec() {
        TypeSpec.Builder builder = PoetUtils.createClassBuilder(this.builderClassName).addModifiers(new Modifier[]{Modifier.ABSTRACT}).addAnnotation(SdkInternalApi.class).addTypeVariable(PoetUtils.createBoundedTypeVariableName("B", this.builderInterfaceName, "B", "C")).addTypeVariable(TypeVariableName.get((String)"C")).superclass((TypeName)PoetUtils.createParameterizedTypeName(DefaultClientBuilder.class, "B", "C")).addJavadoc("Internal base class for {@link $T} and {@link $T}.", new Object[]{ClassName.get((String)this.basePackage, (String)this.model.getMetadata().getSyncBuilder(), (String[])new String[0]), ClassName.get((String)this.basePackage, (String)this.model.getMetadata().getAsyncBuilder(), (String[])new String[0])});
        if (this.model.getCustomizationConfig().getServiceSpecificClientConfigClass() != null) {
            ClassName advancedConfiguration = ClassName.get((String)this.basePackage, (String)this.model.getCustomizationConfig().getServiceSpecificClientConfigClass(), (String[])new String[0]);
            builder.addField(FieldSpec.builder((TypeName)advancedConfiguration, (String)"advancedConfiguration", (Modifier[])new Modifier[0]).addModifiers(new Modifier[]{Modifier.PRIVATE}).build());
        }
        builder.addMethod(this.serviceEndpointPrefixMethod());
        builder.addMethod(this.serviceDefaultsMethod());
        builder.addMethod(this.defaultSignerProviderMethod());
        if (this.model.getCustomizationConfig().getServiceSpecificClientConfigClass() != null) {
            builder.addMethod(this.setAdvancedConfigurationMethod()).addMethod(this.getAdvancedConfigurationMethod()).addMethod(this.beanStyleSetAdvancedConfigurationMethod());
        }
        if (this.model.getCustomizationConfig().getServiceSpecificHttpConfig() != null) {
            builder.addMethod(this.serviceSpecificHttpConfigMethod());
        }
        return builder.build();
    }

    private MethodSpec serviceEndpointPrefixMethod() {
        return MethodSpec.methodBuilder((String)"serviceEndpointPrefix").addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PROTECTED, Modifier.FINAL}).returns(String.class).addCode("return $S;", new Object[]{this.model.getMetadata().getEndpointPrefix()}).build();
    }

    private MethodSpec serviceDefaultsMethod() {
        String requestHandlerDirectory = Utils.packageToDirectory(this.model.getMetadata().getFullClientPackageName());
        String requestHandlerPath = String.format("%s/execution.interceptors", requestHandlerDirectory);
        boolean crc32FromCompressedDataEnabled = this.model.getCustomizationConfig().isCalculateCrc32FromCompressedData();
        return MethodSpec.methodBuilder((String)"serviceDefaults").addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PROTECTED, Modifier.FINAL}).returns(ClientConfigurationDefaults.class).addCode("return $T.builder()\n", new Object[]{ServiceBuilderConfigurationDefaults.class}).addCode("         .defaultSignerProvider(this::defaultSignerProvider)\n", new Object[0]).addCode("         .addRequestHandlerPath($S)\n", new Object[]{requestHandlerPath}).addCode("         .crc32FromCompressedDataEnabled($L)\n", new Object[]{crc32FromCompressedDataEnabled}).addCode("         .build();\n", new Object[0]).build();
    }

    private MethodSpec setAdvancedConfigurationMethod() {
        ClassName advancedConfiguration = ClassName.get((String)this.basePackage, (String)this.model.getCustomizationConfig().getServiceSpecificClientConfigClass(), (String[])new String[0]);
        return MethodSpec.methodBuilder((String)"advancedConfiguration").addModifiers(new Modifier[]{Modifier.PUBLIC}).returns((TypeName)TypeVariableName.get((String)"B")).addParameter((TypeName)advancedConfiguration, "advancedConfiguration", new Modifier[0]).addStatement("this.advancedConfiguration = advancedConfiguration", new Object[0]).addStatement("return thisBuilder()", new Object[0]).build();
    }

    private MethodSpec getAdvancedConfigurationMethod() {
        ClassName advancedConfiguration = ClassName.get((String)this.basePackage, (String)this.model.getCustomizationConfig().getServiceSpecificClientConfigClass(), (String[])new String[0]);
        return MethodSpec.methodBuilder((String)"advancedConfiguration").addModifiers(new Modifier[]{Modifier.PROTECTED}).returns((TypeName)advancedConfiguration).addStatement("return advancedConfiguration", new Object[0]).build();
    }

    private MethodSpec beanStyleSetAdvancedConfigurationMethod() {
        ClassName advancedConfiguration = ClassName.get((String)this.basePackage, (String)this.model.getCustomizationConfig().getServiceSpecificClientConfigClass(), (String[])new String[0]);
        return MethodSpec.methodBuilder((String)"setAdvancedConfiguration").addModifiers(new Modifier[]{Modifier.PUBLIC}).addParameter((TypeName)advancedConfiguration, "advancedConfiguration", new Modifier[0]).addStatement("advancedConfiguration(advancedConfiguration)", new Object[0]).build();
    }

    private MethodSpec serviceSpecificHttpConfigMethod() {
        return MethodSpec.methodBuilder((String)"serviceSpecificHttpConfig").addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PROTECTED, Modifier.FINAL}).returns(AttributeMap.class).addCode("return $L;", new Object[]{this.model.getCustomizationConfig().getServiceSpecificHttpConfig()}).build();
    }

    private MethodSpec defaultSignerProviderMethod() {
        return MethodSpec.methodBuilder((String)"defaultSignerProvider").returns(SignerProvider.class).addModifiers(new Modifier[]{Modifier.PRIVATE}).addCode(this.signerDefinitionMethodBody()).build();
    }

    private CodeBlock signerDefinitionMethodBody() {
        AuthType authType = this.model.getMetadata().getAuthType();
        switch (authType) {
            case V4: {
                return this.v4SignerDefinitionMethodBody();
            }
            case V2: {
                return this.v2SignerDefinitionMethodBody();
            }
            case S3: {
                return this.s3SignerDefinitionMethodBody();
            }
        }
        throw new UnsupportedOperationException("Unsupported signer type: " + (Object)((Object)authType));
    }

    private CodeBlock v4SignerDefinitionMethodBody() {
        return CodeBlock.of((String)"$T signer = new $T();\nsigner.setServiceName($S);\nsigner.setRegionName(signingRegion().value());\nreturn new $T(signer);\n", (Object[])new Object[]{Aws4Signer.class, Aws4Signer.class, this.model.getMetadata().getSigningName(), StaticSignerProvider.class});
    }

    private CodeBlock v2SignerDefinitionMethodBody() {
        return CodeBlock.of((String)"return new $T(new $T());\n", (Object[])new Object[]{StaticSignerProvider.class, QueryStringSigner.class});
    }

    private CodeBlock s3SignerDefinitionMethodBody() {
        return CodeBlock.of((String)"$T signer = new $T();\nsigner.setServiceName(\"$L\");\nsigner.setRegionName(signingRegion().value());\nreturn new $T(signer);\n", (Object[])new Object[]{ClassName.get((String)"software.amazon.awssdk.services.s3", (String)"AwsS3V4Signer", (String[])new String[0]), ClassName.get((String)"software.amazon.awssdk.services.s3", (String)"AwsS3V4Signer", (String[])new String[0]), this.model.getMetadata().getSigningName(), StaticSignerProvider.class});
    }

    @Override
    public ClassName className() {
        return this.builderClassName;
    }
}

