/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.codegen.poet.model;

import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.WildcardTypeName;
import java.io.InputStream;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import software.amazon.awssdk.codegen.model.intermediate.IntermediateModel;
import software.amazon.awssdk.codegen.model.intermediate.ListModel;
import software.amazon.awssdk.codegen.model.intermediate.MapModel;
import software.amazon.awssdk.codegen.model.intermediate.MemberModel;
import software.amazon.awssdk.codegen.poet.PoetExtensions;

class TypeProvider {
    private final PoetExtensions poetExtensions;

    TypeProvider(IntermediateModel intermediateModel) {
        this.poetExtensions = new PoetExtensions(intermediateModel);
    }

    public ClassName listImplClassName() {
        return ClassName.get(ArrayList.class);
    }

    public ClassName mapImplClassName() {
        return ClassName.get(HashMap.class);
    }

    public TypeName fieldType(MemberModel memberModel) {
        if (memberModel.isSimple()) {
            return this.getTypeNameForSimpleType(memberModel.getVariable().getSimpleType());
        }
        if (memberModel.isList()) {
            ListModel listModel = memberModel.getListModel();
            TypeName elementType = this.fieldType(listModel.getListMemberModel());
            return ParameterizedTypeName.get((ClassName)ClassName.get(List.class), (TypeName[])new TypeName[]{elementType});
        }
        if (memberModel.isMap()) {
            MapModel mapModel = memberModel.getMapModel();
            TypeName keyType = mapModel.isKeySimple() ? this.getTypeNameForSimpleType(mapModel.getKeyType()) : this.fieldType(mapModel.getKeyModel());
            TypeName valueType = this.fieldType(mapModel.getValueModel());
            return ParameterizedTypeName.get((ClassName)ClassName.get(Map.class), (TypeName[])new TypeName[]{keyType, valueType});
        }
        return this.poetExtensions.getModelClass(memberModel.getC2jShape());
    }

    public TypeName parameterType(MemberModel memberModel) {
        if (memberModel.isList()) {
            ListModel listModel = memberModel.getListModel();
            MemberModel elementModel = listModel.getListMemberModel();
            TypeName listElementType = this.parameterType(elementModel);
            if (elementModel.isList()) {
                listElementType = WildcardTypeName.subtypeOf((TypeName)listElementType);
            }
            return ParameterizedTypeName.get((ClassName)ClassName.get(Collection.class), (TypeName[])new TypeName[]{listElementType});
        }
        if (memberModel.isMap()) {
            MapModel mapModel = memberModel.getMapModel();
            TypeName keyType = mapModel.isKeySimple() ? this.getTypeNameForSimpleType(mapModel.getKeyType()) : this.parameterType(mapModel.getKeyModel());
            TypeName valueType = this.parameterType(mapModel.getValueModel());
            if (mapModel.getValueModel().isList()) {
                valueType = WildcardTypeName.subtypeOf((TypeName)valueType);
            }
            return ParameterizedTypeName.get((ClassName)ClassName.get(Map.class), (TypeName[])new TypeName[]{keyType, valueType});
        }
        return this.fieldType(memberModel);
    }

    public TypeName mapEntryType(MapModel mapModel) {
        TypeName keyType = mapModel.isKeySimple() ? this.getTypeNameForSimpleType(mapModel.getKeyType()) : this.parameterType(mapModel.getKeyModel());
        TypeName valueType = this.parameterType(mapModel.getValueModel());
        if (mapModel.getValueModel().isList()) {
            valueType = WildcardTypeName.subtypeOf((TypeName)valueType);
        }
        return ParameterizedTypeName.get((ClassName)ClassName.get(Map.Entry.class), (TypeName[])new TypeName[]{keyType, valueType});
    }

    public TypeName getTypeNameForSimpleType(String simpleType) {
        return (TypeName)Stream.of(String.class, Boolean.class, Integer.class, Long.class, Short.class, Byte.class, BigInteger.class, Double.class, Float.class, BigDecimal.class, ByteBuffer.class, InputStream.class, Instant.class).filter(cls -> cls.getName().equals(simpleType) || cls.getSimpleName().equals(simpleType)).map(ClassName::get).findFirst().orElseThrow(() -> new RuntimeException("Unsupported simple fieldType " + simpleType));
    }
}

