/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.codegen.poet.builder;

import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import javax.lang.model.element.Modifier;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.codegen.model.intermediate.IntermediateModel;
import software.amazon.awssdk.codegen.poet.ClassSpec;
import software.amazon.awssdk.codegen.poet.PoetUtils;

public class SyncClientBuilderClass
implements ClassSpec {
    private final String basePackage;
    private final IntermediateModel model;
    private final ClassName clientInterfaceName;
    private final ClassName clientClassName;
    private final ClassName builderInterfaceName;
    private final ClassName builderClassName;
    private final ClassName builderBaseClassName;

    public SyncClientBuilderClass(IntermediateModel model) {
        this.model = model;
        this.basePackage = model.getMetadata().getFullClientPackageName();
        this.clientInterfaceName = ClassName.get((String)this.basePackage, (String)model.getMetadata().getSyncInterface(), (String[])new String[0]);
        this.clientClassName = ClassName.get((String)this.basePackage, (String)model.getMetadata().getSyncClient(), (String[])new String[0]);
        this.builderInterfaceName = ClassName.get((String)this.basePackage, (String)model.getMetadata().getSyncBuilderInterface(), (String[])new String[0]);
        this.builderClassName = ClassName.get((String)this.basePackage, (String)model.getMetadata().getSyncBuilder(), (String[])new String[0]);
        this.builderBaseClassName = ClassName.get((String)this.basePackage, (String)model.getMetadata().getBaseBuilder(), (String[])new String[0]);
    }

    @Override
    public TypeSpec poetSpec() {
        TypeSpec.Builder builder = PoetUtils.createClassBuilder(this.builderClassName).addAnnotation(SdkInternalApi.class).addModifiers(new Modifier[]{Modifier.FINAL}).superclass((TypeName)ParameterizedTypeName.get((ClassName)this.builderBaseClassName, (TypeName[])new TypeName[]{this.builderInterfaceName, this.clientInterfaceName})).addSuperinterface((TypeName)this.builderInterfaceName).addJavadoc("Internal implementation of {@link $T}.", new Object[]{this.builderInterfaceName}).addMethod(this.buildClientMethod());
        return builder.build();
    }

    private MethodSpec buildClientMethod() {
        String advancedConfigParam = this.model.getCustomizationConfig().getServiceSpecificClientConfigClass() != null ? ", advancedConfiguration()" : "";
        return MethodSpec.methodBuilder((String)"buildClient").addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PROTECTED, Modifier.FINAL}).returns((TypeName)this.clientInterfaceName).addCode("return new $T(super.syncClientConfiguration().asLegacySyncClientParams() $L);", new Object[]{this.clientClassName, advancedConfigParam}).build();
    }

    @Override
    public ClassName className() {
        return this.builderClassName;
    }
}

