/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.codegen.model.config.customization;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.codegen.model.config.ConstructorFormsWrapper;
import software.amazon.awssdk.codegen.model.config.customization.ConvenienceTypeOverload;
import software.amazon.awssdk.codegen.model.config.customization.DeprecatedSuppression;
import software.amazon.awssdk.codegen.model.config.customization.MetadataConfig;
import software.amazon.awssdk.codegen.model.config.customization.OperationModifier;
import software.amazon.awssdk.codegen.model.config.customization.ShapeModifier;
import software.amazon.awssdk.codegen.model.config.customization.ShapeSubstitution;
import software.amazon.awssdk.codegen.model.config.customization.SimpleMethodFormsWrapper;
import software.amazon.awssdk.codegen.model.config.customization.StringOverloadForByteBufferMember;
import software.amazon.awssdk.codegen.model.config.customization.StringOverloadForInputStreamMember;
import software.amazon.awssdk.codegen.model.config.templates.CodeGenTemplatesConfig;

public class CustomizationConfig {
    public static final CustomizationConfig DEFAULT = new CustomizationConfig();
    private final List<ConvenienceTypeOverload> convenienceTypeOverloads = new ArrayList<ConvenienceTypeOverload>();
    private String requestMetrics;
    private boolean serviceClientHoldInputStream;
    private List<String> operationsWithResponseStreamContentLengthValidation;
    private String customExceptionUnmarshallerImpl;
    private String customResponseMetadataClassName;
    private boolean skipInterfaceAdditions;
    private String customServiceNameForRequest;
    private boolean requiredParamValidationEnabled;
    private String serviceSpecificClientConfigClass;
    private String serviceSpecificEndpointBuilderClass;
    private Map<String, ConstructorFormsWrapper> additionalShapeConstructors;
    private Map<String, SimpleMethodFormsWrapper> simpleMethods;
    private Map<String, String> renameShapes;
    private MetadataConfig customServiceMetadata;
    private CodeGenTemplatesConfig customCodeTemplates;
    private Map<String, OperationModifier> operationModifiers;
    private Map<String, ShapeSubstitution> shapeSubstitutions;
    private Map<String, ShapeModifier> shapeModifiers;
    private String customErrorCodeFieldName;
    private boolean useModeledOutputShapeNames;
    private String sdkModeledExceptionBaseClassName;
    private String customSignerProvider;
    private boolean calculateCrc32FromCompressedData;
    private String customFileHeader;
    private boolean skipSmokeTests;
    private String presignersFqcn;
    private Set<DeprecatedSuppression> deprecatedSuppressions;
    private String shareModelsWith;
    private String serviceSpecificHttpConfig;
    private List<String> blacklistedSimpleMethods = new ArrayList<String>();
    private List<String> verifiedSimpleMethods = new ArrayList<String>();

    private CustomizationConfig() {
    }

    public String getRequestMetrics() {
        return this.requestMetrics;
    }

    public void setRequestMetrics(String requestMetrics) {
        this.requestMetrics = requestMetrics;
    }

    public boolean isServiceClientHoldInputStream() {
        return this.serviceClientHoldInputStream;
    }

    public void setServiceClientHoldInputStream(boolean serviceClientHoldInputStream) {
        this.serviceClientHoldInputStream = serviceClientHoldInputStream;
    }

    public List<String> getOperationsWithResponseStreamContentLengthValidation() {
        return this.operationsWithResponseStreamContentLengthValidation;
    }

    public void setOperationsWithResponseStreamContentLengthValidation(List<String> operationsWithResponseStreamContentLengthValidation) {
        this.operationsWithResponseStreamContentLengthValidation = operationsWithResponseStreamContentLengthValidation;
    }

    public String getCustomExceptionUnmarshallerImpl() {
        return this.customExceptionUnmarshallerImpl;
    }

    public void setCustomExceptionUnmarshallerImpl(String customExceptionUnmarshallerImpl) {
        this.customExceptionUnmarshallerImpl = customExceptionUnmarshallerImpl;
    }

    public String getCustomResponseMetadataClassName() {
        return this.customResponseMetadataClassName;
    }

    public void setCustomResponseMetadataClassName(String customResponseMetadataClassName) {
        this.customResponseMetadataClassName = customResponseMetadataClassName;
    }

    public boolean isSkipInterfaceAdditions() {
        return this.skipInterfaceAdditions;
    }

    public void setSkipInterfaceAdditions(boolean skipInterfaceAdditions) {
        this.skipInterfaceAdditions = skipInterfaceAdditions;
    }

    public String getCustomServiceNameForRequest() {
        return this.customServiceNameForRequest;
    }

    public void setCustomServiceNameForRequest(String customServiceNameForRequest) {
        this.customServiceNameForRequest = customServiceNameForRequest;
    }

    public CodeGenTemplatesConfig getCustomCodeTemplates() {
        return this.customCodeTemplates;
    }

    public void setCustomCodeTemplates(CodeGenTemplatesConfig customCodeTemplates) {
        this.customCodeTemplates = customCodeTemplates;
    }

    public Map<String, ConstructorFormsWrapper> getAdditionalShapeConstructors() {
        return this.additionalShapeConstructors;
    }

    public void setAdditionalShapeConstructors(Map<String, ConstructorFormsWrapper> additionalConstructors) {
        this.additionalShapeConstructors = additionalConstructors;
    }

    public Map<String, OperationModifier> getOperationModifiers() {
        return this.operationModifiers;
    }

    public void setOperationModifiers(Map<String, OperationModifier> operationModifiers) {
        this.operationModifiers = operationModifiers;
    }

    public Map<String, String> getRenameShapes() {
        return this.renameShapes;
    }

    public void setRenameShapes(Map<String, String> renameShapes) {
        this.renameShapes = renameShapes;
    }

    public Map<String, ShapeSubstitution> getShapeSubstitutions() {
        return this.shapeSubstitutions;
    }

    public void setShapeSubstitutions(Map<String, ShapeSubstitution> shapeSubstitutions) {
        this.shapeSubstitutions = shapeSubstitutions;
    }

    public Map<String, ShapeModifier> getShapeModifiers() {
        return this.shapeModifiers;
    }

    public void setShapeModifiers(Map<String, ShapeModifier> shapeModifiers) {
        this.shapeModifiers = shapeModifiers;
    }

    public Map<String, SimpleMethodFormsWrapper> getSimpleMethods() {
        return this.simpleMethods;
    }

    public void setSimpleMethods(Map<String, SimpleMethodFormsWrapper> simpleMethods) {
        this.simpleMethods = simpleMethods;
    }

    public boolean isRequiredParamValidationEnabled() {
        return this.requiredParamValidationEnabled;
    }

    public void setRequiredParamValidationEnabled(boolean requiredParamValidationEnabled) {
        this.requiredParamValidationEnabled = requiredParamValidationEnabled;
    }

    public String getServiceSpecificClientConfigClass() {
        return this.serviceSpecificClientConfigClass;
    }

    public void setServiceSpecificClientConfigClass(String serviceSpecificClientConfig) {
        this.serviceSpecificClientConfigClass = serviceSpecificClientConfig;
    }

    public String getServiceSpecificEndpointBuilderClass() {
        return this.serviceSpecificEndpointBuilderClass;
    }

    public void setServiceSpecificEndpointBuilderClass(String serviceSpecificEndpointBuilderClass) {
        this.serviceSpecificEndpointBuilderClass = serviceSpecificEndpointBuilderClass;
    }

    public void setStringOverloadForInputStreamMember(StringOverloadForInputStreamMember stringOverloadForInputStreamMember) {
        this.convenienceTypeOverloads.add(stringOverloadForInputStreamMember.getConvenienceTypeOverload());
    }

    public void setStringOverloadForByteBufferMember(StringOverloadForByteBufferMember stringOverloadForByteBufferMember) {
        this.convenienceTypeOverloads.add(stringOverloadForByteBufferMember.getConvenienceTypeOverload());
    }

    public List<ConvenienceTypeOverload> getConvenienceTypeOverloads() {
        return this.convenienceTypeOverloads;
    }

    public void setConvenienceTypeOverloads(List<ConvenienceTypeOverload> convenienceTypeOverloads) {
        this.convenienceTypeOverloads.addAll(convenienceTypeOverloads);
    }

    public MetadataConfig getCustomServiceMetadata() {
        return this.customServiceMetadata;
    }

    public void setCustomServiceMetadata(MetadataConfig metadataConfig) {
        this.customServiceMetadata = metadataConfig;
    }

    public String getCustomErrorCodeFieldName() {
        return this.customErrorCodeFieldName;
    }

    public void setCustomErrorCodeFieldName(String customErrorCodeFieldName) {
        this.customErrorCodeFieldName = customErrorCodeFieldName;
    }

    public boolean useModeledOutputShapeNames() {
        return this.useModeledOutputShapeNames;
    }

    public void setUseModeledOutputShapeNames(boolean useModeledOutputShapeNames) {
        this.useModeledOutputShapeNames = useModeledOutputShapeNames;
    }

    public String getSdkModeledExceptionBaseClassName() {
        return this.sdkModeledExceptionBaseClassName;
    }

    public void setSdkModeledExceptionBaseClassName(String sdkModeledExceptionBaseClassName) {
        this.sdkModeledExceptionBaseClassName = sdkModeledExceptionBaseClassName;
    }

    public String getCustomSignerProvider() {
        return this.customSignerProvider;
    }

    public void setCustomSignerProvider(String customSignerProvider) {
        this.customSignerProvider = customSignerProvider;
    }

    public boolean isCalculateCrc32FromCompressedData() {
        return this.calculateCrc32FromCompressedData;
    }

    public void setCalculateCrc32FromCompressedData(boolean calculateCrc32FromCompressedData) {
        this.calculateCrc32FromCompressedData = calculateCrc32FromCompressedData;
    }

    public String getCustomFileHeader() {
        return this.customFileHeader;
    }

    public void setCustomFileHeader(String customFileHeader) {
        this.customFileHeader = customFileHeader;
    }

    public boolean isSkipSmokeTests() {
        return this.skipSmokeTests;
    }

    public void setSkipSmokeTests(boolean skipSmokeTests) {
        this.skipSmokeTests = skipSmokeTests;
    }

    public String getPresignersFqcn() {
        return this.presignersFqcn;
    }

    public void setPresignersFqcn(String presignersFqcn) {
        this.presignersFqcn = presignersFqcn;
    }

    public Set<DeprecatedSuppression> getDeprecatedSuppressions() {
        return this.deprecatedSuppressions;
    }

    public void setDeprecatedSuppressions(Set<DeprecatedSuppression> deprecatedSuppressions) {
        this.deprecatedSuppressions = deprecatedSuppressions;
    }

    public boolean emitClientMutationMethods() {
        return !this.shouldSuppress(DeprecatedSuppression.ClientMutationMethods);
    }

    public boolean emitClientConstructors() {
        return !this.shouldSuppress(DeprecatedSuppression.ClientConstructors);
    }

    private boolean shouldSuppress(DeprecatedSuppression suppression) {
        return this.deprecatedSuppressions != null && this.deprecatedSuppressions.contains((Object)suppression);
    }

    public String getShareModelsWith() {
        return this.shareModelsWith;
    }

    public void setShareModelsWith(String shareModelsWith) {
        this.shareModelsWith = shareModelsWith;
    }

    public String getServiceSpecificHttpConfig() {
        return this.serviceSpecificHttpConfig;
    }

    public void setServiceSpecificHttpConfig(String serviceSpecificHttpConfig) {
        this.serviceSpecificHttpConfig = serviceSpecificHttpConfig;
    }

    public List<String> getBlacklistedSimpleMethods() {
        return this.blacklistedSimpleMethods;
    }

    public void setBlacklistedSimpleMethods(List<String> blackListedSimpleMethods) {
        this.blacklistedSimpleMethods = blackListedSimpleMethods;
    }

    public List<String> getVerifiedSimpleMethods() {
        return this.verifiedSimpleMethods;
    }

    public void setVerifiedSimpleMethods(List<String> verifiedSimpleMethods) {
        this.verifiedSimpleMethods = verifiedSimpleMethods;
    }
}

