/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.codegen.customization.processors;

import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.codegen.customization.CodegenCustomizationProcessor;
import software.amazon.awssdk.codegen.internal.Utils;
import software.amazon.awssdk.codegen.model.config.customization.ShapeSubstitution;
import software.amazon.awssdk.codegen.model.intermediate.IntermediateModel;
import software.amazon.awssdk.codegen.model.intermediate.MemberModel;
import software.amazon.awssdk.codegen.model.intermediate.ShapeModel;
import software.amazon.awssdk.codegen.model.service.ErrorMap;
import software.amazon.awssdk.codegen.model.service.Member;
import software.amazon.awssdk.codegen.model.service.Operation;
import software.amazon.awssdk.codegen.model.service.ServiceModel;
import software.amazon.awssdk.codegen.model.service.Shape;

final class ShapeSubstitutionsProcessor
implements CodegenCustomizationProcessor {
    private static Logger log = LoggerFactory.getLogger(ShapeSubstitutionsProcessor.class);
    private final Map<String, ShapeSubstitution> shapeSubstitutions;
    private final Map<String, Map<String, String>> substitutedShapeMemberReferences = new HashMap<String, Map<String, String>>();
    private final Map<String, Map<String, String>> substitutedListMemberReferences = new HashMap<String, Map<String, String>>();

    ShapeSubstitutionsProcessor(Map<String, ShapeSubstitution> shapeSubstitutions) {
        this.shapeSubstitutions = shapeSubstitutions;
    }

    @Override
    public void preprocess(ServiceModel serviceModel) {
        if (this.shapeSubstitutions == null) {
            return;
        }
        for (String string : this.shapeSubstitutions.keySet()) {
            if (serviceModel.getShapes().containsKey(string)) continue;
            throw new IllegalStateException("shapeSubstitution customization found for shape " + string + ", which does not exist in the service model.");
        }
        for (Operation operation : serviceModel.getOperations().values()) {
            this.preprocessAssertNoSubstitutedShapeReferenceInOperation(operation);
        }
        for (Map.Entry entry : serviceModel.getShapes().entrySet()) {
            String shapeName = (String)entry.getKey();
            Shape shape = (Shape)entry.getValue();
            this.preprocessSubstituteShapeReferencesInShape(shapeName, shape, serviceModel);
        }
    }

    @Override
    public void postprocess(IntermediateModel intermediateModel) {
        if (this.shapeSubstitutions == null) {
            return;
        }
        for (ShapeModel shapeModel : intermediateModel.getShapes().values()) {
            this.postprocessHandleEmitAsMember(shapeModel, intermediateModel);
        }
    }

    private void preprocessAssertNoSubstitutedShapeReferenceInOperation(Operation operation) {
        String outputShape;
        String inputShape;
        if (operation.getInput() != null && operation.getInput().getShape() != null && this.shapeSubstitutions.containsKey(inputShape = operation.getInput().getShape())) {
            throw new IllegalStateException("shapeSubstitution customization found for shape " + inputShape + ", but this shape is referenced as the input for operation " + operation.getName());
        }
        if (operation.getOutput() != null && operation.getOutput().getShape() != null && this.shapeSubstitutions.containsKey(outputShape = operation.getOutput().getShape())) {
            throw new IllegalStateException("shapeSubstitution customization found for shape " + outputShape + ", but this shape is referenced as the output for operation " + operation.getName());
        }
        if (operation.getErrors() != null) {
            for (ErrorMap error : operation.getErrors()) {
                String errorShape = error.getShape();
                if (!this.shapeSubstitutions.containsKey(errorShape)) continue;
                throw new IllegalStateException("shapeSubstitution customization found for shape " + errorShape + ", but this shape is referenced as an error for operation " + operation.getName());
            }
        }
    }

    private void preprocessSubstituteShapeReferencesInShape(String shapeName, Shape shape, ServiceModel serviceModel) {
        String mapValShape;
        if (shape.getMembers() != null) {
            for (Map.Entry<String, Member> entry : shape.getMembers().entrySet()) {
                String memberName = entry.getKey();
                Member member = entry.getValue();
                String memberShapeName = member.getShape();
                Shape memberShape = serviceModel.getShapes().get(memberShapeName);
                if (Utils.isListShape(memberShape)) {
                    Member nestedListMember = memberShape.getListMember();
                    String nestedListMemberOriginalShape = nestedListMember.getShape();
                    ShapeSubstitution appliedSubstitutionOnListMember = this.substitueMemberShape(nestedListMember);
                    if (appliedSubstitutionOnListMember == null || appliedSubstitutionOnListMember.getEmitFromMember() == null) continue;
                    this.trackListMemberSubstitution(shapeName, memberName, nestedListMemberOriginalShape);
                    continue;
                }
                ShapeSubstitution appliedSubstitution = this.substitueMemberShape(member);
                if (appliedSubstitution == null || appliedSubstitution.getEmitFromMember() == null) continue;
                this.trackShapeMemberSubstitution(shapeName, memberName, memberShapeName);
            }
        } else if (shape.getMapKeyType() != null) {
            String mapKeyShape = shape.getMapKeyType().getShape();
            if (this.shapeSubstitutions.containsKey(mapKeyShape)) {
                throw new IllegalStateException("shapeSubstitution customization found for shape " + mapKeyShape + ", but this shape is the key for a map shape.");
            }
        } else if (shape.getMapValueType() != null && this.shapeSubstitutions.containsKey(mapValShape = shape.getMapValueType().getShape())) {
            throw new IllegalStateException("shapeSubstitution customization found for shape " + mapValShape + ", but this shape is the value for a map shape.");
        }
    }

    private ShapeSubstitution substitueMemberShape(Member member) {
        ShapeSubstitution substitute = this.shapeSubstitutions.get(member.getShape());
        if (substitute != null) {
            member.setShape(substitute.getEmitAsShape());
            return substitute;
        }
        return null;
    }

    private void postprocessHandleEmitAsMember(ShapeModel shape, IntermediateModel intermediateModel) {
        MemberModel emitFromMember;
        ShapeModel parentShape;
        String parentShapeC2jName;
        for (Map.Entry<String, Map<String, String>> ref : this.substitutedShapeMemberReferences.entrySet()) {
            parentShapeC2jName = ref.getKey();
            Map<String, String> memberOriginalShapeMap = ref.getValue();
            parentShape = Utils.findShapeModelByC2jName(intermediateModel, parentShapeC2jName);
            for (Map.Entry<String, String> entry : memberOriginalShapeMap.entrySet()) {
                String memberC2jName = entry.getKey();
                String originalShapeC2jName = entry.getValue();
                MemberModel member = parentShape.findMemberModelByC2jName(memberC2jName);
                ShapeModel originalShape = Utils.findShapeModelByC2jName(intermediateModel, originalShapeC2jName);
                emitFromMember = originalShape.findMemberModelByC2jName(this.shapeSubstitutions.get(originalShapeC2jName).getEmitFromMember());
                if (!this.shouldSkipAddingMarshallingPath(this.shapeSubstitutions.get(originalShapeC2jName), parentShapeC2jName)) {
                    member.getHttp().setAdditionalMarshallingPath(emitFromMember.getHttp().getMarshallLocationName());
                }
                member.getHttp().setAdditionalUnmarshallingPath(emitFromMember.getHttp().getUnmarshallLocationName());
            }
        }
        for (Map.Entry<String, Map<String, String>> ref : this.substitutedListMemberReferences.entrySet()) {
            parentShapeC2jName = ref.getKey();
            Map<String, String> nestedListMemberOriginalShapeMap = ref.getValue();
            parentShape = Utils.findShapeModelByC2jName(intermediateModel, parentShapeC2jName);
            for (Map.Entry<String, String> entry : nestedListMemberOriginalShapeMap.entrySet()) {
                String listTypeMemberC2jName = entry.getKey();
                String nestedListMemberOriginalShapeC2jName = entry.getValue();
                MemberModel listTypeMember = parentShape.findMemberModelByC2jName(listTypeMemberC2jName);
                ShapeModel nestedListMemberOriginalShape = Utils.findShapeModelByC2jName(intermediateModel, nestedListMemberOriginalShapeC2jName);
                emitFromMember = nestedListMemberOriginalShape.findMemberModelByC2jName(this.shapeSubstitutions.get(nestedListMemberOriginalShapeC2jName).getEmitFromMember());
                if (!this.shouldSkipAddingMarshallingPath(this.shapeSubstitutions.get(nestedListMemberOriginalShapeC2jName), parentShapeC2jName)) {
                    listTypeMember.getListModel().setMemberAdditionalMarshallingPath(emitFromMember.getHttp().getMarshallLocationName());
                }
                listTypeMember.getListModel().setMemberAdditionalUnmarshallingPath(emitFromMember.getHttp().getUnmarshallLocationName());
            }
        }
    }

    private void trackShapeMemberSubstitution(String shapeName, String memberName, String originalShape) {
        log.info("{} -> ({} -> {})", new Object[]{shapeName, memberName, originalShape});
        if (!this.substitutedShapeMemberReferences.containsKey(shapeName)) {
            this.substitutedShapeMemberReferences.put(shapeName, new HashMap());
        }
        this.substitutedShapeMemberReferences.get(shapeName).put(memberName, originalShape);
    }

    private void trackListMemberSubstitution(String shapeName, String listTypeMemberName, String nestedListMemberOriginalShape) {
        log.info("{} -> ({} -> {})", new Object[]{shapeName, listTypeMemberName, nestedListMemberOriginalShape});
        if (!this.substitutedListMemberReferences.containsKey(shapeName)) {
            this.substitutedListMemberReferences.put(shapeName, new HashMap());
        }
        this.substitutedListMemberReferences.get(shapeName).put(listTypeMemberName, nestedListMemberOriginalShape);
    }

    private boolean shouldSkipAddingMarshallingPath(ShapeSubstitution substitutionConfig, String parentShapeName) {
        return substitutionConfig.getSkipMarshallPathForShapes() == null ? false : substitutionConfig.getSkipMarshallPathForShapes().contains(parentShapeName);
    }
}

