/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.codegen.emitters.tasks;

import freemarker.template.Template;
import java.util.List;
import java.util.stream.Collectors;
import software.amazon.awssdk.codegen.emitters.FreemarkerGeneratorTask;
import software.amazon.awssdk.codegen.emitters.GeneratorTask;
import software.amazon.awssdk.codegen.emitters.GeneratorTaskParams;
import software.amazon.awssdk.codegen.emitters.tasks.BaseGeneratorTasks;
import software.amazon.awssdk.codegen.model.intermediate.Metadata;
import software.amazon.awssdk.codegen.model.intermediate.ShapeModel;
import software.amazon.awssdk.codegen.model.intermediate.ShapeType;
import software.amazon.awssdk.utils.FunctionalUtils;
import software.amazon.awssdk.utils.ImmutableMap;

public class UnmarshallerGeneratorTasks
extends BaseGeneratorTasks {
    private final String transformClassDir;
    private final Metadata metadata;

    public UnmarshallerGeneratorTasks(GeneratorTaskParams dependencies) {
        super(dependencies);
        this.transformClassDir = dependencies.getPathProvider().getTransformDirectory();
        this.metadata = dependencies.getModel().getMetadata();
    }

    @Override
    protected List<GeneratorTask> createTasks() throws Exception {
        this.info("Emitting unmarshaller classes");
        return this.model.getShapes().entrySet().stream().filter(e -> this.shouldGenerate((ShapeModel)e.getValue())).map(FunctionalUtils.safeFunction(e -> this.createTask((String)e.getKey(), (ShapeModel)e.getValue()))).collect(Collectors.toList());
    }

    private GeneratorTask createTask(String javaShapeName, ShapeModel shapeModel) throws Exception {
        Template template = this.freemarker.getModelUnmarshallerTemplate();
        ShapeType shapeType = shapeModel.getShapeType();
        ImmutableMap dataModel = ImmutableMap.builder().put((Object)"fileHeader", (Object)this.model.getFileHeader()).put((Object)"shape", (Object)shapeModel).put((Object)"metadata", (Object)this.metadata).put((Object)"transformPackage", (Object)this.model.getMetadata().getFullTransformPackageName()).put((Object)"exceptionUnmarshallerImpl", (Object)this.model.getExceptionUnmarshallerImpl()).build();
        switch (shapeType) {
            case Response: 
            case Model: {
                return new FreemarkerGeneratorTask(this.transformClassDir, javaShapeName + "Unmarshaller", template, dataModel);
            }
            case Exception: {
                return new FreemarkerGeneratorTask(this.transformClassDir, javaShapeName + "Unmarshaller", this.freemarker.getExceptionUnmarshallerTemplate(), dataModel);
            }
        }
        throw new IllegalStateException(shapeModel.getC2jName() + " is not supported for unmarshaller generation");
    }

    private boolean shouldGenerate(ShapeModel shapeModel) {
        if (shapeModel.getCustomization().isSkipGeneratingUnmarshaller()) {
            this.info("Skip generating unmarshaller class for " + shapeModel.getShapeName());
            return false;
        }
        return this.shouldGenerate(shapeModel.getShapeType());
    }

    private boolean shouldGenerate(ShapeType shapeType) {
        switch (shapeType) {
            case Response: 
            case Model: {
                return true;
            }
            case Exception: {
                return !this.metadata.isJsonProtocol();
            }
        }
        return false;
    }
}

