/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.codegen.poet.paginators;

import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.FieldSpec;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.TypeName;
import java.security.InvalidParameterException;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import javax.lang.model.element.Modifier;
import software.amazon.awssdk.codegen.docs.PaginationDocs;
import software.amazon.awssdk.codegen.model.intermediate.IntermediateModel;
import software.amazon.awssdk.codegen.model.intermediate.MemberModel;
import software.amazon.awssdk.codegen.model.intermediate.OperationModel;
import software.amazon.awssdk.codegen.model.intermediate.ShapeModel;
import software.amazon.awssdk.codegen.model.service.PaginatorDefinition;
import software.amazon.awssdk.codegen.poet.ClassSpec;
import software.amazon.awssdk.codegen.poet.PoetExtensions;
import software.amazon.awssdk.codegen.poet.model.TypeProvider;

public abstract class PaginatorsClassSpec
implements ClassSpec {
    protected static final String CLIENT_MEMBER = "client";
    protected static final String REQUEST_MEMBER = "firstRequest";
    protected static final String NEXT_PAGE_FETCHER_MEMBER = "nextPageFetcher";
    protected static final String HAS_NEXT_PAGE_METHOD = "hasNextPage";
    protected static final String NEXT_PAGE_METHOD = "nextPage";
    protected static final String RESUME_METHOD = "resume";
    protected static final String PREVIOUS_PAGE_METHOD_ARGUMENT = "previousPage";
    protected static final String RESPONSE_LITERAL = "response";
    protected static final String LAST_SUCCESSFUL_PAGE_LITERAL = "lastSuccessfulPage";
    protected final IntermediateModel model;
    protected final String c2jOperationName;
    protected final PaginatorDefinition paginatorDefinition;
    protected final PoetExtensions poetExtensions;
    protected final TypeProvider typeProvider;
    protected final OperationModel operationModel;
    protected final PaginationDocs paginationDocs;

    public PaginatorsClassSpec(IntermediateModel model, String c2jOperationName, PaginatorDefinition paginatorDefinition) {
        this.model = model;
        this.c2jOperationName = c2jOperationName;
        this.paginatorDefinition = paginatorDefinition;
        this.poetExtensions = new PoetExtensions(model);
        this.typeProvider = new TypeProvider(model);
        this.operationModel = model.getOperation(c2jOperationName);
        this.paginationDocs = new PaginationDocs(model, this.operationModel);
    }

    protected ClassName requestType() {
        return this.poetExtensions.getModelClass(this.operationModel.getInput().getVariableType());
    }

    protected ClassName responseType() {
        return this.poetExtensions.getModelClass(this.operationModel.getReturnType().getReturnType());
    }

    protected FieldSpec requestClassField() {
        return FieldSpec.builder((TypeName)this.requestType(), (String)REQUEST_MEMBER, (Modifier[])new Modifier[]{Modifier.PRIVATE, Modifier.FINAL}).build();
    }

    protected String nextPageFetcherClassName() {
        return this.operationModel.getReturnType().getReturnType() + "Fetcher";
    }

    protected MethodSpec.Builder resumeMethodBuilder() {
        return MethodSpec.methodBuilder((String)RESUME_METHOD).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.FINAL}).addParameter((TypeName)this.responseType(), LAST_SUCCESSFUL_PAGE_LITERAL, new Modifier[]{Modifier.FINAL}).returns((TypeName)this.className()).addCode(CodeBlock.builder().beginControlFlow("if ($L.$L($L))", new Object[]{NEXT_PAGE_FETCHER_MEMBER, HAS_NEXT_PAGE_METHOD, LAST_SUCCESSFUL_PAGE_LITERAL}).addStatement("return new $T($L, $L)", new Object[]{this.className(), CLIENT_MEMBER, this.constructRequestFromLastPage(LAST_SUCCESSFUL_PAGE_LITERAL)}).endControlFlow().build()).addJavadoc(CodeBlock.builder().add("<p>A helper method to resume the pages in case of unexpected failures. The method takes the last successful response page as input and returns an instance of {@link $T} that can be used to retrieve the consecutive pages that follows the input page.</p>", new Object[]{this.className()}).build());
    }

    protected TypeName getTypeForResultKey(String singleResultKey) {
        MemberModel resultKeyModel = this.memberModelForResponseMember(singleResultKey);
        if (resultKeyModel == null) {
            throw new InvalidParameterException("MemberModel is not found for result key: " + singleResultKey);
        }
        if (resultKeyModel.isList()) {
            return this.typeProvider.fieldType(resultKeyModel.getListModel().getListMemberModel());
        }
        if (resultKeyModel.isMap()) {
            return this.typeProvider.mapEntryWithConcreteTypes(resultKeyModel.getMapModel());
        }
        throw new IllegalArgumentException(String.format("Key %s in paginated operation %s should be either a list or a map", singleResultKey, this.c2jOperationName));
    }

    protected MemberModel memberModelForResponseMember(String input) {
        String[] hierarchy = input.split("\\.");
        if (hierarchy.length < 1) {
            throw new IllegalArgumentException(String.format("Error when splitting value %s for operation %s", input, this.c2jOperationName));
        }
        ShapeModel shape = this.operationModel.getOutputShape();
        for (int i = 0; i < hierarchy.length - 1; ++i) {
            shape = shape.findMemberModelByC2jName(hierarchy[i]).getShape();
        }
        return shape.getMemberByC2jName(hierarchy[hierarchy.length - 1]);
    }

    protected String hasNextPageMethodBody() {
        String body = this.paginatorDefinition.getMoreResults() != null ? String.format("return %s.%s.booleanValue()", PREVIOUS_PAGE_METHOD_ARGUMENT, this.fluentGetterMethodForResponseMember(this.paginatorDefinition.getMoreResults())) : String.format("return %s.%s != null", PREVIOUS_PAGE_METHOD_ARGUMENT, this.fluentGetterMethodsForOutputToken().get(0));
        return body;
    }

    protected CodeBlock nextPageMethodBody() {
        return CodeBlock.builder().beginControlFlow("if ($L == null)", new Object[]{PREVIOUS_PAGE_METHOD_ARGUMENT}).addStatement("return $L.$L($L)", new Object[]{CLIENT_MEMBER, this.operationModel.getMethodName(), REQUEST_MEMBER}).endControlFlow().addStatement(this.codeToGetNextPageIfOldResponseIsNotNull(), new Object[0]).build();
    }

    private String codeToGetNextPageIfOldResponseIsNotNull() {
        StringBuilder sb = new StringBuilder();
        sb.append(String.format("return %s.%s(%s)", CLIENT_MEMBER, this.operationModel.getMethodName(), this.constructRequestFromLastPage(PREVIOUS_PAGE_METHOD_ARGUMENT)));
        return sb.toString();
    }

    protected String constructRequestFromLastPage(String responsePage) {
        StringBuilder sb = new StringBuilder();
        sb.append(String.format("%s.toBuilder()", REQUEST_MEMBER));
        List<String> requestSetterNames = this.fluentSetterMethodNamesForInputToken();
        List<String> responseGetterMethods = this.fluentGetterMethodsForOutputToken();
        for (int i = 0; i < this.paginatorDefinition.getInputToken().size(); ++i) {
            sb.append(String.format(".%s(%s.%s)", requestSetterNames.get(i), responsePage, responseGetterMethods.get(i)));
        }
        sb.append(".build()");
        return sb.toString();
    }

    private List<String> fluentSetterMethodNamesForInputToken() {
        return this.paginatorDefinition.getInputToken().stream().map(this::fluentSetterNameForSingleInputToken).collect(Collectors.toList());
    }

    private String fluentSetterNameForSingleInputToken(String inputToken) {
        return this.operationModel.getInputShape().findMemberModelByC2jName(inputToken).getFluentSetterMethodName();
    }

    private List<String> fluentGetterMethodsForOutputToken() {
        return this.paginatorDefinition.getOutputToken().stream().map(this::fluentGetterMethodForResponseMember).collect(Collectors.toList());
    }

    private String fluentGetterMethodForResponseMember(String member) {
        String[] hierarchy = member.split("\\.");
        if (hierarchy.length < 1) {
            throw new IllegalArgumentException(String.format("Error when splitting member %s for operation %s", member, this.c2jOperationName));
        }
        ShapeModel parentShape = this.operationModel.getOutputShape();
        StringBuilder getterMethod = new StringBuilder();
        for (String str : hierarchy) {
            getterMethod.append(".").append(parentShape.findMemberModelByC2jName(str).getFluentGetterMethodName()).append("()");
            parentShape = parentShape.findMemberModelByC2jName(str).getShape();
        }
        return getterMethod.substring(1);
    }

    protected CodeBlock getIteratorLambdaBlock(String resultKey, MemberModel resultKeyModel) {
        String conditionalStatement = this.getConditionalStatementforIteratorLambda(resultKey);
        String fluentGetter = this.fluentGetterMethodForResponseMember(resultKey);
        CodeBlock iteratorBlock = null;
        if (resultKeyModel.isList()) {
            iteratorBlock = CodeBlock.builder().addStatement("return $L.$L.iterator()", new Object[]{RESPONSE_LITERAL, fluentGetter}).build();
        } else if (resultKeyModel.isMap()) {
            iteratorBlock = CodeBlock.builder().addStatement("return $L.$L.entrySet().iterator()", new Object[]{RESPONSE_LITERAL, fluentGetter}).build();
        }
        CodeBlock conditionalBlock = CodeBlock.builder().beginControlFlow("if ($L)", new Object[]{conditionalStatement}).add(iteratorBlock).endControlFlow().addStatement("return $T.emptyIterator()", new Object[]{TypeName.get(Collections.class)}).build();
        return CodeBlock.builder().add("$L -> { $L };", new Object[]{RESPONSE_LITERAL, conditionalBlock}).build();
    }

    private String getConditionalStatementforIteratorLambda(String resultKey) {
        String[] hierarchy = resultKey.split("\\.");
        if (hierarchy.length < 1) {
            throw new IllegalArgumentException(String.format("Error when splitting member %s for operation %s", resultKey, this.c2jOperationName));
        }
        String currentFluentMethod = RESPONSE_LITERAL;
        ShapeModel parentShape = this.operationModel.getOutputShape();
        StringBuilder conditionStatement = new StringBuilder(String.format("%s != null", currentFluentMethod));
        for (String str : hierarchy) {
            currentFluentMethod = String.format("%s.%s()", currentFluentMethod, parentShape.findMemberModelByC2jName(str).getFluentGetterMethodName());
            conditionStatement.append(" && ");
            conditionStatement.append(String.format("%s != null", currentFluentMethod));
            parentShape = parentShape.findMemberModelByC2jName(str).getShape();
        }
        return conditionStatement.toString();
    }
}

