/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.codegen.poet.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.squareup.javapoet.AnnotationSpec;
import com.squareup.javapoet.ArrayTypeName;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterSpec;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import java.util.ArrayList;
import java.util.List;
import javax.lang.model.element.Modifier;
import software.amazon.awssdk.codegen.model.intermediate.IntermediateModel;
import software.amazon.awssdk.codegen.model.intermediate.MemberModel;
import software.amazon.awssdk.codegen.model.intermediate.ShapeModel;
import software.amazon.awssdk.codegen.poet.PoetExtensions;
import software.amazon.awssdk.codegen.poet.model.AbstractMemberSetters;
import software.amazon.awssdk.codegen.poet.model.ServiceModelCopiers;
import software.amazon.awssdk.codegen.poet.model.TypeProvider;

class ListSetters
extends AbstractMemberSetters {
    private final TypeProvider typeProvider;
    private final ServiceModelCopiers serviceModelCopiers;
    private final PoetExtensions poetExtensions;

    public ListSetters(IntermediateModel intermediateModel, ShapeModel shapeModel, MemberModel memberModel, TypeProvider typeProvider) {
        super(intermediateModel, shapeModel, memberModel, typeProvider);
        this.typeProvider = typeProvider;
        this.serviceModelCopiers = new ServiceModelCopiers(intermediateModel);
        this.poetExtensions = new PoetExtensions(intermediateModel);
    }

    @Override
    public List<MethodSpec> fluentDeclarations(TypeName returnType) {
        ArrayList<MethodSpec> fluentDeclarations = new ArrayList<MethodSpec>();
        fluentDeclarations.add(this.fluentSetterDeclaration(this.memberAsParameter(), returnType).addJavadoc("$L", new Object[]{this.memberModel().getFluentSetterDocumentation()}).build());
        fluentDeclarations.add(this.fluentSetterDeclaration(ParameterSpec.builder((TypeName)this.asArray(), (String)this.fieldName(), (Modifier[])new Modifier[0]).build(), returnType).addJavadoc("$L", new Object[]{this.memberModel().getVarargSetterDocumentation()}).varargs(true).build());
        if (this.memberModel().getEnumType() != null) {
            fluentDeclarations.add(this.fluentSetterDeclaration(ParameterSpec.builder((TypeName)this.asArrayOfModeledEnum(), (String)this.fieldName(), (Modifier[])new Modifier[0]).build(), returnType).varargs(true).addJavadoc("$L", new Object[]{this.memberModel().getVarargSetterDocumentation()}).build());
        }
        return fluentDeclarations;
    }

    @Override
    public List<MethodSpec> fluent(TypeName returnType) {
        ArrayList<MethodSpec> fluent = new ArrayList<MethodSpec>();
        fluent.add(this.fluentCopySetter(returnType));
        fluent.add(this.fluentVarargToListSetter(returnType));
        if (this.memberModel().getEnumType() != null) {
            fluent.add(this.fluentEnumVarargToListSetter(returnType));
        }
        return fluent;
    }

    @Override
    public List<MethodSpec> beanStyle() {
        ArrayList<MethodSpec> beanStyle = new ArrayList<MethodSpec>();
        beanStyle.add(this.beanStyleCopySetter());
        beanStyle.add(this.beanStyleVarargToListSetter());
        if (this.memberModel().getEnumType() != null) {
            beanStyle.add(this.beanStyleEnumVarargToListSetter());
        }
        return beanStyle;
    }

    private MethodSpec fluentCopySetter(TypeName returnType) {
        return this.fluentSetterBuilder(returnType).addCode(this.copySetterBody().toBuilder().addStatement("return this", new Object[0]).build()).build();
    }

    private MethodSpec beanStyleCopySetter() {
        MethodSpec.Builder builder = this.beanStyleSetterBuilder().addCode(this.copySetterBody());
        if (this.annotateJsonProperty()) {
            builder.addAnnotation(AnnotationSpec.builder(JsonProperty.class).addMember("value", "$S", new Object[]{this.memberModel().getHttp().getMarshallLocationName()}).build());
        }
        return builder.build();
    }

    private MethodSpec fluentVarargToListSetter(TypeName returnType) {
        return this.fluentSetterBuilder(ParameterSpec.builder((TypeName)this.asArray(), (String)this.fieldName(), (Modifier[])new Modifier[0]).build(), returnType).varargs(true).addAnnotation(SafeVarargs.class).addCode(this.varargToListBody().toBuilder().addStatement("return this", new Object[0]).build()).build();
    }

    private MethodSpec beanStyleVarargToListSetter() {
        return this.beanStyleSetterBuilder(ParameterSpec.builder((TypeName)this.asArray(), (String)this.fieldName(), (Modifier[])new Modifier[0]).build()).varargs(true).addAnnotation(SafeVarargs.class).addCode(this.varargToListBody()).build();
    }

    private MethodSpec fluentEnumVarargToListSetter(TypeName returnType) {
        return this.fluentSetterBuilder(ParameterSpec.builder((TypeName)this.asArrayOfModeledEnum(), (String)this.fieldName(), (Modifier[])new Modifier[0]).build(), returnType).varargs(true).addAnnotation(SafeVarargs.class).addCode(this.enumVarargToListBody().toBuilder().addStatement("return this", new Object[0]).build()).build();
    }

    private MethodSpec beanStyleEnumVarargToListSetter() {
        return this.beanStyleSetterBuilder(ParameterSpec.builder((TypeName)this.asArrayOfModeledEnum(), (String)this.fieldName(), (Modifier[])new Modifier[0]).build()).varargs(true).addAnnotation(SafeVarargs.class).addCode(this.enumVarargToListBody()).build();
    }

    private CodeBlock varargToListBody() {
        CodeBlock.Builder builder = CodeBlock.builder().beginControlFlow("if (this.$N == null)", new Object[]{this.fieldName()}).addStatement("this.$N = new $T<>($N.length)", new Object[]{this.fieldName(), this.typeProvider.listImplClassName(), this.fieldName()}).endControlFlow().beginControlFlow("for ($T e: $N)", new Object[]{this.listElementType(), this.fieldName()});
        this.serviceModelCopiers.copierClassFor(this.elementModel()).map(copierClass -> builder.addStatement("this.$N.add($T.$N(e))", new Object[]{this.fieldName(), copierClass, this.serviceModelCopiers.copyMethodName()})).orElseGet(() -> builder.addStatement("this.$N.add(e)", new Object[]{this.fieldName()}));
        return builder.endControlFlow().build();
    }

    private CodeBlock enumVarargToListBody() {
        return CodeBlock.builder().beginControlFlow("if (this.$N == null)", new Object[]{this.fieldName()}).addStatement("this.$N = new $T($N.length)", new Object[]{this.fieldName(), ParameterizedTypeName.get((ClassName)this.typeProvider.listImplClassName(), (TypeName[])new TypeName[]{ClassName.get(String.class)}), this.fieldName()}).endControlFlow().beginControlFlow("for ($T ele : $N)", new Object[]{this.modeledEnumElement(), this.fieldName()}).addStatement("this.$N.add(ele.toString())", new Object[]{this.fieldName()}).endControlFlow().build();
    }

    private MemberModel elementModel() {
        return this.memberModel().getListModel().getListMemberModel();
    }

    private TypeName modeledEnumElement() {
        return this.poetExtensions.getModelClass(this.memberModel().getEnumType());
    }

    private TypeName listElementType() {
        return this.typeProvider.parameterType(this.elementModel());
    }

    private ArrayTypeName asArray() {
        return ArrayTypeName.of((TypeName)this.listElementType());
    }

    private ArrayTypeName asArrayOfModeledEnum() {
        return ArrayTypeName.of((TypeName)this.modeledEnumElement());
    }
}

