/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.codegen.poet.client.specs;

import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.FieldSpec;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeVariableName;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.lang.model.element.Modifier;
import software.amazon.awssdk.AmazonServiceException;
import software.amazon.awssdk.client.ClientExecutionParams;
import software.amazon.awssdk.codegen.model.intermediate.IntermediateModel;
import software.amazon.awssdk.codegen.model.intermediate.OperationModel;
import software.amazon.awssdk.codegen.model.intermediate.ShapeType;
import software.amazon.awssdk.codegen.poet.PoetExtensions;
import software.amazon.awssdk.codegen.poet.client.AsyncClientInterface;
import software.amazon.awssdk.codegen.poet.client.specs.ProtocolSpec;
import software.amazon.awssdk.http.HttpResponseHandler;
import software.amazon.awssdk.http.async.SdkHttpResponseHandler;
import software.amazon.awssdk.protocol.json.JsonClientMetadata;
import software.amazon.awssdk.protocol.json.JsonErrorResponseMetadata;
import software.amazon.awssdk.protocol.json.JsonErrorShapeMetadata;
import software.amazon.awssdk.protocol.json.JsonOperationMetadata;
import software.amazon.awssdk.protocol.json.SdkJsonProtocolFactory;
import software.amazon.awssdk.runtime.transform.StreamingRequestMarshaller;

public class JsonProtocolSpec
implements ProtocolSpec {
    private final PoetExtensions poetExtensions;

    public JsonProtocolSpec(PoetExtensions poetExtensions) {
        this.poetExtensions = poetExtensions;
    }

    @Override
    public FieldSpec protocolFactory(IntermediateModel model) {
        return FieldSpec.builder(SdkJsonProtocolFactory.class, (String)"protocolFactory", (Modifier[])new Modifier[0]).addModifiers(new Modifier[]{Modifier.PRIVATE, Modifier.FINAL}).build();
    }

    @Override
    public MethodSpec initProtocolFactory(IntermediateModel model) {
        String exceptionPath = model.getSdkModeledExceptionBaseFqcn().substring(0, model.getSdkModeledExceptionBaseFqcn().lastIndexOf("."));
        ClassName baseException = ClassName.get((String)exceptionPath, (String)model.getSdkModeledExceptionBaseClassName(), (String[])new String[0]);
        ClassName protocolFactory = this.poetExtensions.getClientClass(model.getMetadata().getProtocolFactory());
        MethodSpec.Builder methodSpec = MethodSpec.methodBuilder((String)"init").returns((TypeName)protocolFactory).addModifiers(new Modifier[]{Modifier.PRIVATE}).addCode("return new $T(new $T()\n.withProtocolVersion($S)\n.withSupportsCbor($L)\n.withSupportsIon($L).withBaseServiceExceptionClass($L.class)", new Object[]{SdkJsonProtocolFactory.class, JsonClientMetadata.class, model.getMetadata().getJsonVersion(), model.getMetadata().isCborProtocol(), model.getMetadata().isIonProtocol(), baseException});
        if (model.getMetadata().getContentType() != null) {
            methodSpec.addCode(".withContentTypeOverride($S)", new Object[]{model.getMetadata().getContentType()});
        }
        this.errorUnmarshallers(model).forEach(arg_0 -> ((MethodSpec.Builder)methodSpec).addCode(arg_0));
        methodSpec.addCode(");", new Object[0]);
        return methodSpec.build();
    }

    @Override
    public CodeBlock asyncResponseHandler(OperationModel opModel) {
        ClassName unmarshaller = this.poetExtensions.getTransformClass(opModel.getReturnType().getReturnType() + "Unmarshaller");
        if (opModel.hasStreamingOutput()) {
            return CodeBlock.builder().add("\n\n$T<$T> responseHandler = $L.createAsyncStreamingResponseHandler(new $T(), asyncResponseHandler);", new Object[]{SdkHttpResponseHandler.class, AsyncClientInterface.STREAMING_TYPE_VARIABLE, "protocolFactory", unmarshaller}).build();
        }
        return this.responseHandler(opModel);
    }

    @Override
    public CodeBlock responseHandler(OperationModel opModel) {
        ClassName unmarshaller = this.poetExtensions.getTransformClass(opModel.getReturnType().getReturnType() + "Unmarshaller");
        ClassName returnType = this.poetExtensions.getModelClass(opModel.getReturnType().getReturnType());
        if (opModel.hasStreamingOutput()) {
            return CodeBlock.builder().add("$T<$T> responseHandler = protocolFactory.createStreamingResponseHandler(new $T(), streamingHandler);", new Object[]{HttpResponseHandler.class, AsyncClientInterface.STREAMING_TYPE_VARIABLE, unmarshaller}).build();
        }
        return CodeBlock.builder().add("\n\n$T<$T> responseHandler = $L.createResponseHandler(new $T().withPayloadJson($L), new $T());", new Object[]{HttpResponseHandler.class, returnType, "protocolFactory", JsonOperationMetadata.class, !opModel.getHasBlobMemberAsPayload(), unmarshaller}).build();
    }

    @Override
    public CodeBlock errorResponseHandler(OperationModel opModel) {
        return CodeBlock.builder().add("\n\n$T<$T> errorResponseHandler = createErrorResponseHandler();", new Object[]{HttpResponseHandler.class, AmazonServiceException.class}).build();
    }

    @Override
    public CodeBlock executionHandler(OperationModel opModel) {
        TypeVariableName returnType = opModel.hasStreamingOutput() ? AsyncClientInterface.STREAMING_TYPE_VARIABLE : this.poetExtensions.getModelClass(opModel.getReturnType().getReturnType());
        ClassName requestType = this.poetExtensions.getModelClass(opModel.getInput().getVariableType());
        ClassName marshaller = this.poetExtensions.getRequestTransformClass(opModel.getInputShape().getShapeName() + "Marshaller");
        CodeBlock.Builder codeBlock = CodeBlock.builder().add("\n\nreturn clientHandler.execute(new $T<$T, $T>()\n.withResponseHandler($N)\n.withErrorResponseHandler($N)\n.withInput($L)\n", new Object[]{ClientExecutionParams.class, requestType, returnType, "responseHandler", "errorResponseHandler", opModel.getInput().getVariableName()});
        if (opModel.hasStreamingInput()) {
            return codeBlock.add(".withMarshaller(new $T(new $T(protocolFactory), requestBody)));", new Object[]{ParameterizedTypeName.get((ClassName)ClassName.get(StreamingRequestMarshaller.class), (TypeName[])new TypeName[]{requestType}), marshaller}).build();
        }
        return codeBlock.add(".withMarshaller(new $T(protocolFactory)));", new Object[]{marshaller}).build();
    }

    @Override
    public CodeBlock asyncExecutionHandler(OperationModel opModel) {
        ClassName pojoResponseType = this.poetExtensions.getModelClass(opModel.getReturnType().getReturnType());
        ClassName requestType = this.poetExtensions.getModelClass(opModel.getInput().getVariableType());
        ClassName marshaller = this.poetExtensions.getRequestTransformClass(opModel.getInputShape().getShapeName() + "Marshaller");
        String asyncRequestProvider = opModel.hasStreamingInput() ? ".withAsyncRequestProvider(requestProvider)" : "";
        TypeVariableName returnType = opModel.hasStreamingOutput() ? AsyncClientInterface.STREAMING_TYPE_VARIABLE : pojoResponseType;
        String responseHandler = opModel.hasStreamingOutput() ? ".withAsyncResponseHandler(responseHandler)" : ".withResponseHandler(responseHandler)";
        return CodeBlock.builder().add("\n\nreturn clientHandler.execute(new $T<$T, $T>()\n.withMarshaller(new $T($N))" + responseHandler + ".withErrorResponseHandler($N)\n" + asyncRequestProvider + ".withInput($L));", new Object[]{ClientExecutionParams.class, requestType, returnType, marshaller, "protocolFactory", "errorResponseHandler", opModel.getInput().getVariableName()}).build();
    }

    @Override
    public Optional<MethodSpec> createErrorResponseHandler() {
        ClassName httpResponseHandler = ClassName.get(HttpResponseHandler.class);
        ClassName sdkBaseException = ClassName.get(AmazonServiceException.class);
        ParameterizedTypeName responseHandlerOfException = ParameterizedTypeName.get((ClassName)httpResponseHandler, (TypeName[])new TypeName[]{sdkBaseException});
        return Optional.of(MethodSpec.methodBuilder((String)"createErrorResponseHandler").returns((TypeName)responseHandlerOfException).addModifiers(new Modifier[]{Modifier.PRIVATE}).addStatement("return protocolFactory.createErrorResponseHandler(new $T())", new Object[]{JsonErrorResponseMetadata.class}).build());
    }

    @Override
    public List<CodeBlock> errorUnmarshallers(IntermediateModel model) {
        List exceptions = model.getShapes().values().stream().filter(s -> s.getShapeType().equals((Object)ShapeType.Exception)).collect(Collectors.toList());
        return exceptions.stream().map(s -> {
            ClassName exceptionClass = this.poetExtensions.getModelClass(s.getShapeName());
            return CodeBlock.builder().add(".addErrorMetadata(new $T().withErrorCode($S).withModeledClass($T.class))", new Object[]{JsonErrorShapeMetadata.class, s.getErrorCode(), exceptionClass}).build();
        }).collect(Collectors.toList());
    }
}

