/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.codegen.model.intermediate;

import com.fasterxml.jackson.annotation.JsonIgnore;
import software.amazon.awssdk.codegen.internal.Constants;
import software.amazon.awssdk.codegen.internal.DocumentationUtils;
import software.amazon.awssdk.codegen.internal.TypeUtils;
import software.amazon.awssdk.codegen.model.intermediate.DocumentationModel;
import software.amazon.awssdk.codegen.model.intermediate.ListModel;
import software.amazon.awssdk.codegen.model.intermediate.MapModel;
import software.amazon.awssdk.codegen.model.intermediate.ParameterHttpMapping;
import software.amazon.awssdk.codegen.model.intermediate.ReturnTypeModel;
import software.amazon.awssdk.codegen.model.intermediate.ShapeModel;
import software.amazon.awssdk.codegen.model.intermediate.VariableModel;
import software.amazon.awssdk.runtime.transform.PathMarshallers;
import software.amazon.awssdk.utils.StringUtils;

public class MemberModel
extends DocumentationModel {
    private String name;
    private String c2jName;
    private String c2jShape;
    private VariableModel variable;
    private VariableModel setterModel;
    private ReturnTypeModel getterModel;
    private ParameterHttpMapping http;
    private boolean deprecated;
    private ListModel listModel;
    private MapModel mapModel;
    private String enumType;
    private String xmlNameSpaceUri;
    private boolean idempotencyToken;
    private ShapeModel shape;
    private String fluentGetterMethodName;
    private String fluentSetterMethodName;
    private String beanStyleGetterName;
    private String beanStyleSetterName;

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public MemberModel withName(String name) {
        this.setName(name);
        return this;
    }

    public String getC2jName() {
        return this.c2jName;
    }

    public void setC2jName(String c2jName) {
        this.c2jName = c2jName;
    }

    public MemberModel withC2jName(String c2jName) {
        this.setC2jName(c2jName);
        return this;
    }

    public String getC2jShape() {
        return this.c2jShape;
    }

    public void setC2jShape(String c2jShape) {
        this.c2jShape = c2jShape;
    }

    public MemberModel withC2jShape(String c2jShape) {
        this.setC2jShape(c2jShape);
        return this;
    }

    public VariableModel getVariable() {
        return this.variable;
    }

    public void setVariable(VariableModel variable) {
        this.variable = variable;
    }

    public MemberModel withVariable(VariableModel variable) {
        this.setVariable(variable);
        return this;
    }

    public VariableModel getSetterModel() {
        return this.setterModel;
    }

    public void setSetterModel(VariableModel setterModel) {
        this.setterModel = setterModel;
    }

    public MemberModel withSetterModel(VariableModel setterModel) {
        this.setSetterModel(setterModel);
        return this;
    }

    public String getFluentGetterMethodName() {
        return this.fluentGetterMethodName;
    }

    public void setFluentGetterMethodName(String fluentGetterMethodName) {
        this.fluentGetterMethodName = fluentGetterMethodName;
    }

    public MemberModel withFluentGetterMethodName(String getterMethodName) {
        this.setFluentGetterMethodName(getterMethodName);
        return this;
    }

    public String getBeanStyleGetterMethodName() {
        return this.beanStyleGetterName;
    }

    public void setBeanStyleGetterMethodName(String beanStyleGetterName) {
        this.beanStyleGetterName = beanStyleGetterName;
    }

    public MemberModel withBeanStyleGetterMethodName(String beanStyleGetterName) {
        this.beanStyleGetterName = beanStyleGetterName;
        return this;
    }

    public String getBeanStyleSetterMethodName() {
        return this.beanStyleSetterName;
    }

    public void setBeanStyleSetterMethodName(String beanStyleSetterName) {
        this.beanStyleSetterName = beanStyleSetterName;
    }

    public MemberModel withBeanStyleSetterMethodName(String beanStyleSetterName) {
        this.beanStyleSetterName = beanStyleSetterName;
        return this;
    }

    public String getSetterMethodName() {
        return this.getBeanStyleSetterMethodName();
    }

    public void setSetterMethodName(String setterMethodName) {
        this.setBeanStyleGetterMethodName(setterMethodName);
    }

    public MemberModel withSetterMethodName(String setterMethodName) {
        this.setSetterMethodName(setterMethodName);
        return this;
    }

    public String getFluentSetterMethodName() {
        return this.fluentSetterMethodName;
    }

    public void setFluentSetterMethodName(String fluentSetterMethodName) {
        this.fluentSetterMethodName = fluentSetterMethodName;
    }

    public MemberModel withFluentSetterMethodName(String fluentMethodName) {
        this.setFluentSetterMethodName(fluentMethodName);
        return this;
    }

    public ReturnTypeModel getGetterModel() {
        return this.getterModel;
    }

    public void setGetterModel(ReturnTypeModel getterModel) {
        this.getterModel = getterModel;
    }

    public MemberModel withGetterModel(ReturnTypeModel getterModel) {
        this.setGetterModel(getterModel);
        return this;
    }

    public ParameterHttpMapping getHttp() {
        return this.http;
    }

    public void setHttp(ParameterHttpMapping parameterHttpMapping) {
        this.http = parameterHttpMapping;
    }

    public boolean isSimple() {
        return TypeUtils.isSimple(this.variable.getVariableType());
    }

    public boolean isList() {
        return this.listModel != null;
    }

    public boolean isMap() {
        return this.mapModel != null;
    }

    public boolean isDeprecated() {
        return this.deprecated;
    }

    public void setDeprecated(boolean deprecated) {
        this.deprecated = deprecated;
    }

    public ListModel getListModel() {
        return this.listModel;
    }

    public void setListModel(ListModel listModel) {
        this.listModel = listModel;
    }

    public MapModel getMapModel() {
        return this.mapModel;
    }

    public MemberModel withListModel(ListModel list) {
        this.setListModel(list);
        return this;
    }

    public void setMapModel(MapModel map) {
        this.mapModel = map;
    }

    public MemberModel withMapModel(MapModel map) {
        this.setMapModel(map);
        return this;
    }

    public String getEnumType() {
        return this.enumType;
    }

    public void setEnumType(String enumType) {
        this.enumType = enumType;
    }

    public MemberModel withEnumType(String enumType) {
        this.setEnumType(enumType);
        return this;
    }

    public String getXmlNameSpaceUri() {
        return this.xmlNameSpaceUri;
    }

    public void setXmlNameSpaceUri(String xmlNameSpaceUri) {
        this.xmlNameSpaceUri = xmlNameSpaceUri;
    }

    public MemberModel withXmlNameSpaceUri(String xmlNameSpaceUri) {
        this.setXmlNameSpaceUri(xmlNameSpaceUri);
        return this;
    }

    public String getSetterDocumentation() {
        StringBuilder docBuilder = new StringBuilder();
        docBuilder.append(this.getSetterDoc());
        if ("java.nio.ByteBuffer".equals(this.getGetterModel().getReturnType())) {
            docBuilder.append("<p>").append(Constants.LF).append("AWS SDK for Java performs a Base64 encoding on this field before sending this request to AWS service by default. Users of the SDK should not perform Base64 encoding on this field.").append(Constants.LF).append("</p>").append(Constants.LF);
            docBuilder.append("<p>").append(Constants.LF).append("Warning: ByteBuffers returned by the SDK are mutable. Changes to the content or position of the byte buffer will be seen by all objects that have a reference to this object. It is recommended to call ByteBuffer.duplicate() or ByteBuffer.asReadOnlyBuffer() before using or reading from the buffer. This behavior will be changed in a future major version of the SDK.").append(Constants.LF).append("</p>").append(Constants.LF);
        }
        docBuilder.append(this.getParamDoc()).append(this.getEnumDoc());
        return docBuilder.toString();
    }

    public String getGetterDocumentation() {
        StringBuilder docBuilder = new StringBuilder();
        docBuilder.append(this.documentation != null ? this.documentation : "Returns the value of the %s property for this object.".replace("%s", this.name)).append(Constants.LF);
        if ("java.nio.ByteBuffer".equals(this.getGetterModel().getReturnType())) {
            docBuilder.append("<p>").append(Constants.LF).append("{@code ByteBuffer}s are stateful. Calling their {@code get} methods changes their {@code position}. We recommend using {@link java.nio.ByteBuffer#asReadOnlyBuffer()} to create a read-only view of the buffer with an independent {@code position}, and calling {@code get} methods on this rather than directly on the returned {@code ByteBuffer}. Doing so will ensure that anyone else using the {@code ByteBuffer} will not be affected by changes to the {@code position}.").append(Constants.LF).append("</p>").append(Constants.LF);
        }
        String variableDesc = this.documentation != null ? this.documentation : "The value of the %s property for this object.".replace("%s", this.name);
        docBuilder.append("@return ").append(DocumentationUtils.stripHtmlTags(variableDesc)).append(this.getEnumDoc());
        return docBuilder.toString();
    }

    public String getFluentSetterDocumentation() {
        StringBuilder docBuilder = new StringBuilder();
        docBuilder.append(this.getSetterDoc()).append(this.getParamDoc()).append(Constants.LF).append("@return " + DocumentationUtils.stripHtmlTags("Returns a reference to this object so that method calls can be chained together.")).append(this.getEnumDoc());
        return docBuilder.toString();
    }

    public String getVarargSetterDocumentation() {
        StringBuilder docBuilder = new StringBuilder();
        docBuilder.append(this.getSetterDoc());
        if (this.listModel != null) {
            docBuilder.append(Constants.LF).append("<p><b>NOTE:</b> This method appends the values to the existing list (if any). Use {@link #set%s(java.util.Collection)} or {@link #with%s(java.util.Collection)} if you want to override the existing values.</p>".replaceAll("%s", this.name));
        }
        docBuilder.append(this.getParamDoc()).append(Constants.LF).append("@return " + DocumentationUtils.stripHtmlTags("Returns a reference to this object so that method calls can be chained together.")).append(this.getEnumDoc());
        return docBuilder.toString();
    }

    private String getSetterDoc() {
        return this.documentation != null ? this.documentation : "Sets the value of the %s property for this object.".replace("%s", this.name);
    }

    private String getParamDoc() {
        StringBuilder docBuilder = new StringBuilder();
        String variableDesc = this.documentation != null ? this.documentation : "The new value for the %s property for this object.".replace("%s", this.name);
        docBuilder.append(Constants.LF).append("@param ").append(this.variable.getVariableName()).append(" ").append(DocumentationUtils.stripHtmlTags(variableDesc));
        return docBuilder.toString();
    }

    private String getEnumDoc() {
        StringBuilder docBuilder = new StringBuilder();
        if (this.enumType != null) {
            docBuilder.append(Constants.LF);
            docBuilder.append("@see " + this.enumType);
        }
        return docBuilder.toString();
    }

    public boolean isIdempotencyToken() {
        return this.idempotencyToken;
    }

    public void setIdempotencyToken(boolean idempotencyToken) {
        this.idempotencyToken = idempotencyToken;
    }

    public boolean getIsBinary() {
        return this.http.getIsStreaming() || this.http.getIsPayload() && "java.nio.ByteBuffer".equals(this.variable.getVariableType());
    }

    @JsonIgnore
    public String getPathMarshaller() {
        if (!this.http.isUri()) {
            throw new IllegalStateException("Only members bound to the URI have a path marshaller");
        }
        String prefix = PathMarshallers.class.getName();
        if (this.http.isGreedy()) {
            return prefix + ".GREEDY";
        }
        if (this.isIdempotencyToken()) {
            return prefix + ".IDEMPOTENCY";
        }
        return prefix + ".NON_GREEDY";
    }

    @JsonIgnore
    public String getMarshallerBindingFieldName() {
        return StringUtils.upperCase((String)this.name) + "_BINDING";
    }

    public String getMarshallingType() {
        if (this.isList()) {
            return "LIST";
        }
        if (this.isMap()) {
            return "MAP";
        }
        if (!this.isSimple()) {
            return "STRUCTURED";
        }
        return TypeUtils.getMarshallingType(this.variable.getSimpleType());
    }

    public String getMarshallingTargetClass() {
        if (this.isList()) {
            return "List";
        }
        if (this.isMap()) {
            return "Map";
        }
        if (!this.isSimple()) {
            return "StructuredPojo";
        }
        return this.variable.getVariableType();
    }

    @JsonIgnore
    public ShapeModel getShape() {
        return this.shape;
    }

    public void setShape(ShapeModel shape) {
        this.shape = shape;
    }

    public String toString() {
        return this.c2jName;
    }
}

