/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.codegen.lite.regions;

import com.squareup.javapoet.AnnotationSpec;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.FieldSpec;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import java.lang.reflect.Type;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.lang.model.element.Modifier;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.codegen.lite.PoetClass;
import software.amazon.awssdk.codegen.lite.Utils;
import software.amazon.awssdk.codegen.lite.regions.RegionValidationUtil;
import software.amazon.awssdk.codegen.lite.regions.model.Endpoint;
import software.amazon.awssdk.codegen.lite.regions.model.Partition;
import software.amazon.awssdk.codegen.lite.regions.model.Partitions;
import software.amazon.awssdk.codegen.lite.regions.model.Service;
import software.amazon.awssdk.utils.ImmutableMap;

public class ServiceMetadataGenerator
implements PoetClass {
    private final Partitions partitions;
    private final String service;
    private final String basePackage;
    private final String regionBasePackage;

    public ServiceMetadataGenerator(Partitions partitions, String service, String basePackage, String regionBasePackage) {
        this.partitions = partitions;
        this.service = service;
        this.basePackage = basePackage;
        this.regionBasePackage = regionBasePackage;
    }

    @Override
    public TypeSpec poetClass() {
        ParameterizedTypeName listOfRegions = ParameterizedTypeName.get((ClassName)ClassName.get(List.class), (TypeName[])new TypeName[]{ClassName.get((String)this.regionBasePackage, (String)"Region", (String[])new String[0])});
        ParameterizedTypeName mapOfStringString = ParameterizedTypeName.get(Map.class, (Type[])new Type[]{String.class, String.class});
        return TypeSpec.classBuilder((ClassName)this.className()).addModifiers(new Modifier[]{Modifier.PUBLIC}).addAnnotation(AnnotationSpec.builder(Generated.class).addMember("value", "$S", new Object[]{"software.amazon.awssdk:codegen"}).build()).addAnnotation(SdkPublicApi.class).addModifiers(new Modifier[]{Modifier.FINAL}).addSuperinterface((TypeName)ClassName.get((String)this.regionBasePackage, (String)"ServiceMetadata", (String[])new String[0])).addField(FieldSpec.builder(String.class, (String)"ENDPOINT_PREFIX", (Modifier[])new Modifier[0]).addModifiers(new Modifier[]{Modifier.PRIVATE, Modifier.FINAL, Modifier.STATIC}).initializer("$S", new Object[]{this.service}).build()).addField(FieldSpec.builder((TypeName)mapOfStringString, (String)"PARTITION_OVERRIDDEN_ENDPOINTS", (Modifier[])new Modifier[0]).addModifiers(new Modifier[]{Modifier.PRIVATE, Modifier.FINAL, Modifier.STATIC}).initializer(this.partitionEndpoints(this.partitions)).build()).addField(FieldSpec.builder((TypeName)mapOfStringString, (String)"REGION_OVERRIDDEN_ENDPOINTS", (Modifier[])new Modifier[0]).addModifiers(new Modifier[]{Modifier.PRIVATE, Modifier.FINAL, Modifier.STATIC}).initializer(this.serviceEndpoints(this.partitions)).build()).addField(FieldSpec.builder((TypeName)listOfRegions, (String)"REGIONS", (Modifier[])new Modifier[0]).addModifiers(new Modifier[]{Modifier.PRIVATE, Modifier.FINAL, Modifier.STATIC}).initializer(this.regionsField(this.partitions)).build()).addField(FieldSpec.builder((TypeName)mapOfStringString, (String)"SIGNING_REGION_OVERRIDES", (Modifier[])new Modifier[0]).addModifiers(new Modifier[]{Modifier.PRIVATE, Modifier.FINAL, Modifier.STATIC}).initializer(this.signingRegionOverrides(this.partitions)).build()).addMethod(this.regions()).addMethod(this.endpointFor()).addMethod(this.signingRegion()).build();
    }

    @Override
    public ClassName className() {
        String sanitizedServiceName = this.service.replace(".", "-");
        return ClassName.get((String)this.basePackage, (String)(Stream.of(sanitizedServiceName.split("-")).map(Utils::capitalize).collect(Collectors.joining()) + "ServiceMetadata"), (String[])new String[0]);
    }

    private CodeBlock partitionEndpoints(Partitions partitions) {
        Map<Partition, Service> services = this.getServiceData(partitions);
        CodeBlock.Builder builder = CodeBlock.builder().add("$T.<String, String>builder()", new Object[]{ImmutableMap.class});
        services.entrySet().forEach(e -> {
            if (((Service)e.getValue()).getDefaults() != null && ((Service)e.getValue()).getDefaults().getHostname() != null) {
                builder.add(".put($S, $S)", new Object[]{e.getKey(), ((Service)e.getValue()).getDefaults().getHostname()});
            }
        });
        return builder.add(".build()", new Object[0]).build();
    }

    private CodeBlock serviceEndpoints(Partitions partitions) {
        Map<Partition, Service> services = this.getServiceData(partitions);
        CodeBlock.Builder builder = CodeBlock.builder().add("$T.<String, String>builder()", new Object[]{ImmutableMap.class});
        services.entrySet().stream().forEach(s -> ((Service)s.getValue()).getEndpoints().entrySet().stream().filter(e -> ((Endpoint)e.getValue()).getHostname() != null).filter(r -> RegionValidationUtil.validRegion((String)r.getKey(), ((Partition)s.getKey()).getRegionRegex())).forEach(e -> builder.add(".put(\"" + (String)e.getKey() + "\", \"" + ((Endpoint)e.getValue()).getHostname() + "\")", new Object[0])));
        return builder.add(".build()", new Object[0]).build();
    }

    private CodeBlock regionsField(Partitions partitions) {
        ClassName regionClass = ClassName.get((String)this.regionBasePackage, (String)"Region", (String[])new String[0]);
        CodeBlock.Builder builder = CodeBlock.builder().add("$T.unmodifiableList($T.asList(", new Object[]{Collections.class, Arrays.class});
        ArrayList regions = new ArrayList();
        partitions.getPartitions().stream().filter(p -> p.getServices().containsKey(this.service)).forEach(p -> regions.addAll(p.getServices().get(this.service).getEndpoints().keySet().stream().filter(r -> RegionValidationUtil.validRegion(r, p.getRegionRegex())).collect(Collectors.toList())));
        for (int i = 0; i < regions.size(); ++i) {
            builder.add("$T.of($S)", new Object[]{regionClass, regions.get(i)});
            if (i == regions.size() - 1) continue;
            builder.add(",", new Object[0]);
        }
        return builder.add("))", new Object[0]).build();
    }

    private CodeBlock signingRegionOverrides(Partitions partitions) {
        Map<Partition, Service> serviceData = this.getServiceData(partitions);
        CodeBlock.Builder builder = CodeBlock.builder().add("$T.<String, String>builder()", new Object[]{ImmutableMap.class});
        serviceData.entrySet().stream().forEach(s -> ((Service)s.getValue()).getEndpoints().entrySet().stream().filter(e -> ((Endpoint)e.getValue()).getCredentialScope() != null).filter(e -> ((Endpoint)e.getValue()).getCredentialScope().getRegion() != null).filter(r -> RegionValidationUtil.validRegion((String)r.getKey(), ((Partition)s.getKey()).getRegionRegex())).forEach(fm -> builder.add(".put(\"" + (String)fm.getKey() + "\", \"" + ((Endpoint)fm.getValue()).getCredentialScope().getRegion() + "\")", new Object[0])));
        return builder.add(".build()", new Object[0]).build();
    }

    private MethodSpec regions() {
        ParameterizedTypeName listOfRegions = ParameterizedTypeName.get((ClassName)ClassName.get(List.class), (TypeName[])new TypeName[]{ClassName.get((String)this.regionBasePackage, (String)"Region", (String[])new String[0])});
        return MethodSpec.methodBuilder((String)"regions").addModifiers(new Modifier[]{Modifier.PUBLIC}).addAnnotation(Override.class).returns((TypeName)listOfRegions).addStatement("return $L", new Object[]{"REGIONS"}).build();
    }

    private MethodSpec endpointFor() {
        return MethodSpec.methodBuilder((String)"endpointFor").addModifiers(new Modifier[]{Modifier.PUBLIC}).addParameter((TypeName)ClassName.get((String)this.regionBasePackage, (String)"Region", (String[])new String[0]), "region", new Modifier[0]).addAnnotation(Override.class).returns(URI.class).addStatement("return $T.create(REGION_OVERRIDDEN_ENDPOINTS.containsKey(region.id()) ? REGION_OVERRIDDEN_ENDPOINTS.get(region.id()) : computeEndpoint(ENDPOINT_PREFIX, PARTITION_OVERRIDDEN_ENDPOINTS, region))", new Object[]{URI.class}).build();
    }

    private MethodSpec signingRegion() {
        return MethodSpec.methodBuilder((String)"signingRegion").addModifiers(new Modifier[]{Modifier.PUBLIC}).addParameter((TypeName)ClassName.get((String)this.regionBasePackage, (String)"Region", (String[])new String[0]), "region", new Modifier[0]).addAnnotation(Override.class).returns((TypeName)ClassName.get((String)this.regionBasePackage, (String)"Region", (String[])new String[0])).addStatement("return Region.of(SIGNING_REGION_OVERRIDES.getOrDefault(region.id(), region.id()))", new Object[0]).build();
    }

    private Map<Partition, Service> getServiceData(Partitions partitions) {
        TreeMap<Partition, Service> serviceData = new TreeMap<Partition, Service>(Comparator.comparing(Partition::getPartition));
        partitions.getPartitions().stream().forEach(p -> p.getServices().entrySet().stream().filter(s -> ((String)s.getKey()).equalsIgnoreCase(this.service)).forEach(s -> {
            Service cfr_ignored_0 = (Service)serviceData.put((Partition)p, (Service)s.getValue());
        }));
        return serviceData;
    }
}

