/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.codegen.lite.defaultsmode;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.codegen.lite.defaultsmode.DefaultConfiguration;
import software.amazon.awssdk.protocols.jsoncore.JsonNode;
import software.amazon.awssdk.protocols.jsoncore.JsonNodeParser;
import software.amazon.awssdk.protocols.jsoncore.JsonNodeVisitor;
import software.amazon.awssdk.utils.Logger;

@SdkInternalApi
public final class DefaultsLoader {
    private static final Logger log = Logger.loggerFor(DefaultsLoader.class);
    private static final Set<String> UNSUPPORTED_OPTIONS = new HashSet<String>();

    private DefaultsLoader() {
    }

    public static DefaultConfiguration load(File path) {
        return DefaultsLoader.loadDefaultsFromFile(path);
    }

    private static DefaultConfiguration loadDefaultsFromFile(File path) {
        DefaultConfiguration defaultsResolution = new DefaultConfiguration();
        HashMap<String, Map<String, String>> resolvedDefaults = new HashMap<String, Map<String, String>>();
        try (FileInputStream fileInputStream = new FileInputStream(path);){
            JsonNodeParser jsonNodeParser = JsonNodeParser.builder().build();
            Map sdkDefaultConfiguration = jsonNodeParser.parse((InputStream)fileInputStream).asObject();
            Map base = ((JsonNode)sdkDefaultConfiguration.get("base")).asObject();
            Map modes = ((JsonNode)sdkDefaultConfiguration.get("modes")).asObject();
            modes.forEach((mode, modifiers) -> DefaultsLoader.applyModificationToOneMode(resolvedDefaults, base, mode, modifiers));
            Map documentation = ((JsonNode)sdkDefaultConfiguration.get("documentation")).asObject();
            Map modesDocumentation = ((JsonNode)documentation.get("modes")).asObject();
            Map configDocumentation = ((JsonNode)documentation.get("configuration")).asObject();
            defaultsResolution.modesDocumentation(modesDocumentation.entrySet().stream().collect(HashMap::new, (m, e) -> m.put((String)e.getKey(), ((JsonNode)e.getValue()).asString()), Map::putAll));
            defaultsResolution.configurationDocumentation(configDocumentation.entrySet().stream().filter(e -> !UNSUPPORTED_OPTIONS.contains(e.getKey())).collect(HashMap::new, (m, e) -> m.put((String)e.getKey(), ((JsonNode)e.getValue()).asString()), Map::putAll));
        }
        catch (IOException e2) {
            throw new RuntimeException(e2);
        }
        defaultsResolution.modeDefaults(resolvedDefaults);
        return defaultsResolution;
    }

    private static void applyModificationToOneConfigurationOption(Map<String, String> resolvedDefaultsForCurrentMode, String option, JsonNode modifier) {
        String resolvedValue;
        String modifierString;
        String baseValue = resolvedDefaultsForCurrentMode.get(option);
        if (UNSUPPORTED_OPTIONS.contains(option)) {
            return;
        }
        Map modifierMap = modifier.asObject();
        if (modifierMap.size() != 1) {
            throw new IllegalStateException("More than one modifier exists for option " + option);
        }
        switch (modifierString = (String)modifierMap.keySet().iterator().next()) {
            case "override": {
                resolvedValue = (String)((JsonNode)modifierMap.get("override")).visit((JsonNodeVisitor)new StringJsonNodeVisitor());
                break;
            }
            case "multiply": {
                resolvedValue = DefaultsLoader.processMultiply(baseValue, modifierMap);
                break;
            }
            case "add": {
                resolvedValue = DefaultsLoader.processAdd(baseValue, modifierMap);
                break;
            }
            default: {
                throw new UnsupportedOperationException("Unsupported modifier: " + modifierString);
            }
        }
        resolvedDefaultsForCurrentMode.put(option, resolvedValue);
    }

    private static void applyModificationToOneMode(Map<String, Map<String, String>> resolvedDefaults, Map<String, JsonNode> base, String mode, JsonNode modifiers) {
        log.info(() -> "Apply modification for mode: " + mode);
        Map resolvedDefaultsForCurrentMode = base.entrySet().stream().filter(e -> !UNSUPPORTED_OPTIONS.contains(e.getKey())).collect(HashMap::new, (m, e) -> m.put((String)e.getKey(), (String)((JsonNode)e.getValue()).visit((JsonNodeVisitor)new StringJsonNodeVisitor())), Map::putAll);
        modifiers.asObject().forEach((option, modifier) -> DefaultsLoader.applyModificationToOneConfigurationOption(resolvedDefaultsForCurrentMode, option, modifier));
        resolvedDefaults.put(mode, resolvedDefaultsForCurrentMode);
    }

    private static String processAdd(String baseValue, Map<String, JsonNode> modifierMap) {
        String add = modifierMap.get("add").asNumber();
        int parsedAdd = Integer.parseInt(add);
        int number = Math.addExact(Integer.parseInt(baseValue), parsedAdd);
        String resolvedValue = String.valueOf(number);
        return resolvedValue;
    }

    private static String processMultiply(String baseValue, Map<String, JsonNode> modifierMap) {
        String multiply = modifierMap.get("multiply").asNumber();
        double parsedValue = Double.parseDouble(multiply);
        double resolvedNumber = (double)Integer.parseInt(baseValue) * parsedValue;
        int castValue = (int)resolvedNumber;
        if ((double)castValue != resolvedNumber) {
            throw new IllegalStateException("The transformed value must be be a float number: " + castValue);
        }
        String resolvedValue = String.valueOf(castValue);
        return resolvedValue;
    }

    static {
        UNSUPPORTED_OPTIONS.add("stsRegionalEndpoints");
    }

    private static final class StringJsonNodeVisitor
    implements JsonNodeVisitor<String> {
        private StringJsonNodeVisitor() {
        }

        public String visitNull() {
            throw new IllegalStateException("Invalid type encountered");
        }

        public String visitBoolean(boolean b) {
            throw new IllegalStateException("Invalid type (boolean) encountered " + b);
        }

        public String visitNumber(String s) {
            return s;
        }

        public String visitString(String s) {
            return s;
        }

        public String visitArray(List<JsonNode> list) {
            throw new IllegalStateException("Invalid type (list) encountered: " + list);
        }

        public String visitObject(Map<String, JsonNode> map) {
            throw new IllegalStateException("Invalid type (map) encountered: " + map);
        }

        public String visitEmbeddedObject(Object o) {
            throw new IllegalStateException("Invalid type (embedded) encountered: " + o);
        }
    }
}

