/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.codegen.lite.regions;

import com.squareup.javapoet.AnnotationSpec;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.FieldSpec;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import javax.lang.model.element.Modifier;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.codegen.lite.PoetClass;
import software.amazon.awssdk.codegen.lite.regions.model.Partitions;
import software.amazon.awssdk.utils.Validate;
import software.amazon.awssdk.utils.http.SdkHttpUtils;

public class RegionGenerator
implements PoetClass {
    private final Partitions partitions;
    private final String basePackage;

    public RegionGenerator(Partitions partitions, String basePackage) {
        this.partitions = partitions;
        this.basePackage = basePackage;
    }

    @Override
    public TypeSpec poetClass() {
        TypeSpec.Builder builder = TypeSpec.classBuilder((ClassName)this.className()).addModifiers(new Modifier[]{Modifier.FINAL, Modifier.PUBLIC}).addJavadoc(this.documentation()).addAnnotation(SdkPublicApi.class).addAnnotation(AnnotationSpec.builder(Generated.class).addMember("value", "$S", new Object[]{"software.amazon.awssdk:codegen"}).build()).addMethod(MethodSpec.constructorBuilder().addModifiers(new Modifier[]{Modifier.PRIVATE}).addParameter(String.class, "id", new Modifier[0]).addParameter(Boolean.TYPE, "isGlobalRegion", new Modifier[0]).addStatement("this.id = id", new Object[0]).addStatement("this.isGlobalRegion = isGlobalRegion", new Object[0]).build());
        this.regions(builder);
        builder.addField(FieldSpec.builder(Boolean.TYPE, (String)"isGlobalRegion", (Modifier[])new Modifier[0]).addModifiers(new Modifier[]{Modifier.FINAL, Modifier.PRIVATE}).build()).addField(FieldSpec.builder(String.class, (String)"id", (Modifier[])new Modifier[0]).addModifiers(new Modifier[]{Modifier.FINAL, Modifier.PRIVATE}).build()).addMethod(this.regionOf()).addMethod(this.regionOfGlobal()).addMethod(this.regionsGetter()).addMethod(this.id()).addMethod(this.metadata()).addMethod(this.isGlobalRegion()).addMethod(this.regionToString());
        return builder.addType(this.cache()).build();
    }

    private void regions(TypeSpec.Builder builder) {
        Set regions = this.partitions.getPartitions().stream().flatMap(p -> p.getRegions().keySet().stream()).collect(Collectors.toSet());
        CodeBlock.Builder regionsArray = CodeBlock.builder().add("$T.unmodifiableList($T.asList(", new Object[]{Collections.class, Arrays.class});
        String regionsCodeBlock = regions.stream().map(r -> {
            builder.addField(FieldSpec.builder((TypeName)this.className(), (String)this.regionName((String)r), (Modifier[])new Modifier[0]).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.STATIC, Modifier.FINAL}).initializer("$T.of($S)", new Object[]{this.className(), r}).build());
            return this.regionName((String)r);
        }).collect(Collectors.joining(", "));
        this.addGlobalRegions(builder);
        regionsArray.add(regionsCodeBlock + ", ", new Object[0]).add("AWS_GLOBAL, ", new Object[0]).add("AWS_CN_GLOBAL, ", new Object[0]).add("AWS_US_GOV_GLOBAL", new Object[0]);
        regionsArray.add("))", new Object[0]);
        ParameterizedTypeName listOfRegions = ParameterizedTypeName.get((ClassName)ClassName.get(List.class), (TypeName[])new TypeName[]{this.className()});
        builder.addField(FieldSpec.builder((TypeName)listOfRegions, (String)"REGIONS", (Modifier[])new Modifier[0]).addModifiers(new Modifier[]{Modifier.PRIVATE, Modifier.STATIC, Modifier.FINAL}).initializer(regionsArray.build()).build());
    }

    private void addGlobalRegions(TypeSpec.Builder builder) {
        builder.addField(FieldSpec.builder((TypeName)this.className(), (String)"AWS_GLOBAL", (Modifier[])new Modifier[0]).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.STATIC, Modifier.FINAL}).initializer("$T.of($S, true)", new Object[]{this.className(), "aws-global"}).build()).addField(FieldSpec.builder((TypeName)this.className(), (String)"AWS_CN_GLOBAL", (Modifier[])new Modifier[0]).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.STATIC, Modifier.FINAL}).initializer("$T.of($S, true)", new Object[]{this.className(), "aws-cn-global"}).build()).addField(FieldSpec.builder((TypeName)this.className(), (String)"AWS_US_GOV_GLOBAL", (Modifier[])new Modifier[0]).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.STATIC, Modifier.FINAL}).initializer("$T.of($S, true)", new Object[]{this.className(), "aws-us-gov-global"}).build());
    }

    private String regionName(String region) {
        return region.replace("-", "_").toUpperCase(Locale.US);
    }

    private MethodSpec regionOf() {
        return MethodSpec.methodBuilder((String)"of").addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.STATIC}).addParameter(String.class, "value", new Modifier[0]).returns((TypeName)this.className()).addStatement("return of($L, false)", new Object[]{"value"}).build();
    }

    private MethodSpec regionOfGlobal() {
        return MethodSpec.methodBuilder((String)"of").addModifiers(new Modifier[]{Modifier.PRIVATE, Modifier.STATIC}).addParameter(String.class, "value", new Modifier[0]).addParameter(Boolean.TYPE, "isGlobalRegion", new Modifier[0]).returns((TypeName)this.className()).addStatement("$T.paramNotBlank($L, $S)", new Object[]{Validate.class, "value", "region"}).addStatement("$T $L = $T.urlEncode($L)", new Object[]{String.class, "urlEncodedValue", SdkHttpUtils.class, "value"}).addStatement("return $L.put($L, $L)", new Object[]{"RegionCache", "urlEncodedValue", "isGlobalRegion"}).build();
    }

    private MethodSpec id() {
        return MethodSpec.methodBuilder((String)"id").addModifiers(new Modifier[]{Modifier.PUBLIC}).returns(String.class).addStatement("return this.id", new Object[0]).build();
    }

    private MethodSpec metadata() {
        ClassName regionMetadataClass = ClassName.get((String)"software.amazon.awssdk.regions", (String)"RegionMetadata", (String[])new String[0]);
        return MethodSpec.methodBuilder((String)"metadata").addModifiers(new Modifier[]{Modifier.PUBLIC}).returns((TypeName)regionMetadataClass).addStatement("return $T.of(this)", new Object[]{regionMetadataClass}).build();
    }

    private MethodSpec regionsGetter() {
        return MethodSpec.methodBuilder((String)"regions").addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.STATIC}).returns((TypeName)ParameterizedTypeName.get((ClassName)ClassName.get(List.class), (TypeName[])new TypeName[]{this.className()})).addStatement("return $L", new Object[]{"REGIONS"}).build();
    }

    private MethodSpec isGlobalRegion() {
        return MethodSpec.methodBuilder((String)"isGlobalRegion").addModifiers(new Modifier[]{Modifier.PUBLIC}).returns(Boolean.TYPE).addStatement("return $L", new Object[]{"isGlobalRegion"}).build();
    }

    private MethodSpec regionToString() {
        return MethodSpec.methodBuilder((String)"toString").addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PUBLIC}).returns(String.class).addStatement("return $L", new Object[]{"id"}).build();
    }

    private TypeSpec cache() {
        ParameterizedTypeName mapOfStringRegion = ParameterizedTypeName.get((ClassName)ClassName.get(ConcurrentHashMap.class), (TypeName[])new TypeName[]{ClassName.get(String.class), this.className()});
        return TypeSpec.classBuilder((String)"RegionCache").addModifiers(new Modifier[]{Modifier.PRIVATE, Modifier.STATIC}).addField(FieldSpec.builder((TypeName)mapOfStringRegion, (String)"VALUES", (Modifier[])new Modifier[0]).addModifiers(new Modifier[]{Modifier.PRIVATE, Modifier.STATIC, Modifier.FINAL}).initializer("new $T<>()", new Object[]{ConcurrentHashMap.class}).build()).addMethod(MethodSpec.constructorBuilder().addModifiers(new Modifier[]{Modifier.PRIVATE}).build()).addMethod(MethodSpec.methodBuilder((String)"put").addModifiers(new Modifier[]{Modifier.PRIVATE, Modifier.STATIC}).addParameter(String.class, "value", new Modifier[0]).addParameter(Boolean.TYPE, "isGlobalRegion", new Modifier[0]).returns((TypeName)this.className()).addStatement("return $L.computeIfAbsent(value, v -> new $T(value, isGlobalRegion))", new Object[]{"VALUES", this.className()}).build()).build();
    }

    private CodeBlock documentation() {
        return CodeBlock.builder().add("An Amazon Web Services region that hosts a set of Amazon services.", new Object[0]).add(System.lineSeparator(), new Object[0]).add("<p>An instance of this class can be retrieved by referencing one of the static constants defined in this class (eg. {@link Region#US_EAST_1}) or by using the {@link Region#of(String)} method if the region you want is not included in this release of the SDK.</p>", new Object[0]).add(System.lineSeparator(), new Object[0]).add("<p>Each AWS region corresponds to a separate geographical location where a set of Amazon services is deployed. These regions (except for the special {@link #AWS_GLOBAL} and {@link #AWS_CN_GLOBAL} regions) are separate from each other, with their own set of resources. This means a resource created in one region (eg. an SQS queue) is not available in another region.</p>", new Object[0]).add(System.lineSeparator(), new Object[0]).add("<p>To programmatically determine whether a particular service is deployed to a region, you can use the {@code serviceMetadata} method on the service's client interface. Additional metadata about a region can be discovered using {@link RegionMetadata#of(Region)}.</p>", new Object[0]).add(System.lineSeparator(), new Object[0]).add("<p>The {@link Region#id()} will be used as the signing region for all requests to AWS services unless an explicit region override is available in {@link RegionMetadata}. This id will also be used to construct the endpoint for accessing a service unless an explicit endpoint is available for that region in {@link RegionMetadata}.</p>", new Object[0]).build();
    }

    @Override
    public ClassName className() {
        return ClassName.get((String)this.basePackage, (String)"Region", (String[])new String[0]);
    }
}

