/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.codegen.lite.maven.plugin;

import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.HashSet;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import software.amazon.awssdk.codegen.lite.CodeGenerator;
import software.amazon.awssdk.codegen.lite.PoetClass;
import software.amazon.awssdk.codegen.lite.regions.PartitionMetadataGenerator;
import software.amazon.awssdk.codegen.lite.regions.PartitionMetadataProviderGenerator;
import software.amazon.awssdk.codegen.lite.regions.RegionGenerator;
import software.amazon.awssdk.codegen.lite.regions.RegionMetadataGenerator;
import software.amazon.awssdk.codegen.lite.regions.RegionMetadataLoader;
import software.amazon.awssdk.codegen.lite.regions.RegionMetadataProviderGenerator;
import software.amazon.awssdk.codegen.lite.regions.ServiceMetadataGenerator;
import software.amazon.awssdk.codegen.lite.regions.ServiceMetadataProviderGenerator;
import software.amazon.awssdk.codegen.lite.regions.model.Partitions;

@Mojo(name="generate-regions")
public class RegionGenerationMojo
extends AbstractMojo {
    private static final String PARTITION_METADATA_BASE = "software.amazon.awssdk.regions.partitionmetadata";
    private static final String SERVICE_METADATA_BASE = "software.amazon.awssdk.regions.servicemetadata";
    private static final String REGION_METADATA_BASE = "software.amazon.awssdk.regions.regionmetadata";
    private static final String REGION_BASE = "software.amazon.awssdk.regions";
    @Parameter(property="outputDirectory", defaultValue="${project.build.directory}")
    private String outputDirectory;
    @Parameter(defaultValue="${project}", readonly=true)
    private MavenProject project;
    @Parameter(property="endpoints", defaultValue="${basedir}/src/main/resources/software/amazon/awssdk/regions/internal/region/endpoints.json")
    private File endpoints;

    public void execute() throws MojoExecutionException {
        Path baseSourcesDirectory = Paths.get(this.outputDirectory, new String[0]).resolve("generated-sources").resolve("sdk");
        Path testsDirectory = Paths.get(this.outputDirectory, new String[0]).resolve("generated-test-sources").resolve("sdk-tests");
        Partitions partitions = RegionMetadataLoader.build((File)this.endpoints);
        this.generatePartitionMetadataClass(baseSourcesDirectory, partitions);
        this.generateRegionClass(baseSourcesDirectory, partitions);
        this.generateServiceMetadata(baseSourcesDirectory, partitions);
        this.generateRegions(baseSourcesDirectory, partitions);
        this.generatePartitionProvider(baseSourcesDirectory, partitions);
        this.generateRegionProvider(baseSourcesDirectory, partitions);
        this.generateServiceProvider(baseSourcesDirectory, partitions);
        this.project.addCompileSourceRoot(baseSourcesDirectory.toFile().getAbsolutePath());
        this.project.addTestCompileSourceRoot(testsDirectory.toFile().getAbsolutePath());
    }

    public void generatePartitionMetadataClass(Path baseSourcesDirectory, Partitions partitions) {
        Path sourcesDirectory = baseSourcesDirectory.resolve(PARTITION_METADATA_BASE.replace(".", "/"));
        partitions.getPartitions().forEach(p -> new CodeGenerator(sourcesDirectory.toString(), (PoetClass)new PartitionMetadataGenerator(p, PARTITION_METADATA_BASE, REGION_BASE)).generate());
    }

    public void generateRegionClass(Path baseSourcesDirectory, Partitions partitions) {
        Path sourcesDirectory = baseSourcesDirectory.resolve(REGION_BASE.replace(".", "/"));
        new CodeGenerator(sourcesDirectory.toString(), (PoetClass)new RegionGenerator(partitions, REGION_BASE)).generate();
    }

    public void generateServiceMetadata(Path baseSourcesDirectory, Partitions partitions) {
        Path sourcesDirectory = baseSourcesDirectory.resolve(SERVICE_METADATA_BASE.replace(".", "/"));
        HashSet services = new HashSet();
        partitions.getPartitions().forEach(p -> services.addAll(p.getServices().keySet()));
        services.stream().filter(s -> !"elasticache".equals(s)).forEach(s -> new CodeGenerator(sourcesDirectory.toString(), (PoetClass)new ServiceMetadataGenerator(partitions, s, SERVICE_METADATA_BASE, REGION_BASE)).generate());
    }

    public void generateRegions(Path baseSourcesDirectory, Partitions partitions) {
        Path sourcesDirectory = baseSourcesDirectory.resolve(REGION_METADATA_BASE.replace(".", "/"));
        partitions.getPartitions().forEach(p -> p.getRegions().forEach((k, v) -> new CodeGenerator(sourcesDirectory.toString(), (PoetClass)new RegionMetadataGenerator(p, k, v.getDescription(), REGION_METADATA_BASE, REGION_BASE)).generate()));
    }

    public void generatePartitionProvider(Path baseSourcesDirectory, Partitions partitions) {
        Path sourcesDirectory = baseSourcesDirectory.resolve(REGION_BASE.replace(".", "/"));
        new CodeGenerator(sourcesDirectory.toString(), (PoetClass)new PartitionMetadataProviderGenerator(partitions, PARTITION_METADATA_BASE, REGION_BASE)).generate();
    }

    public void generateRegionProvider(Path baseSourcesDirectory, Partitions partitions) {
        Path sourcesDirectory = baseSourcesDirectory.resolve(REGION_BASE.replace(".", "/"));
        new CodeGenerator(sourcesDirectory.toString(), (PoetClass)new RegionMetadataProviderGenerator(partitions, REGION_METADATA_BASE, REGION_BASE)).generate();
    }

    public void generateServiceProvider(Path baseSourcesDirectory, Partitions partitions) {
        Path sourcesDirectory = baseSourcesDirectory.resolve(REGION_BASE.replace(".", "/"));
        new CodeGenerator(sourcesDirectory.toString(), (PoetClass)new ServiceMetadataProviderGenerator(partitions, SERVICE_METADATA_BASE, REGION_BASE)).generate();
    }
}

