/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.codedeploy.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about an on-premises instance.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class InstanceInfo implements SdkPojo, Serializable, ToCopyableBuilder<InstanceInfo.Builder, InstanceInfo> {
    private static final SdkField<String> INSTANCE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("instanceName").getter(getter(InstanceInfo::instanceName)).setter(setter(Builder::instanceName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("instanceName").build()).build();

    private static final SdkField<String> IAM_SESSION_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("iamSessionArn").getter(getter(InstanceInfo::iamSessionArn)).setter(setter(Builder::iamSessionArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("iamSessionArn").build()).build();

    private static final SdkField<String> IAM_USER_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("iamUserArn").getter(getter(InstanceInfo::iamUserArn)).setter(setter(Builder::iamUserArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("iamUserArn").build()).build();

    private static final SdkField<String> INSTANCE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("instanceArn").getter(getter(InstanceInfo::instanceArn)).setter(setter(Builder::instanceArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("instanceArn").build()).build();

    private static final SdkField<Instant> REGISTER_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("registerTime").getter(getter(InstanceInfo::registerTime)).setter(setter(Builder::registerTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("registerTime").build()).build();

    private static final SdkField<Instant> DEREGISTER_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("deregisterTime").getter(getter(InstanceInfo::deregisterTime)).setter(setter(Builder::deregisterTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("deregisterTime").build()).build();

    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField
            .<List<Tag>> builder(MarshallingType.LIST)
            .memberName("tags")
            .getter(getter(InstanceInfo::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Tag> builder(MarshallingType.SDK_POJO)
                                            .constructor(Tag::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(INSTANCE_NAME_FIELD, IAM_SESSION_ARN_FIELD, IAM_USER_ARN_FIELD, INSTANCE_ARN_FIELD, REGISTER_TIME_FIELD,
                    DEREGISTER_TIME_FIELD, TAGS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String instanceName;

    private final String iamSessionArn;

    private final String iamUserArn;

    private final String instanceArn;

    private final Instant registerTime;

    private final Instant deregisterTime;

    private final List<Tag> tags;

    private InstanceInfo(BuilderImpl builder) {
        this.instanceName = builder.instanceName;
        this.iamSessionArn = builder.iamSessionArn;
        this.iamUserArn = builder.iamUserArn;
        this.instanceArn = builder.instanceArn;
        this.registerTime = builder.registerTime;
        this.deregisterTime = builder.deregisterTime;
        this.tags = builder.tags;
    }

    /**
     * <p>
     * The name of the on-premises instance.
     * </p>
     * 
     * @return The name of the on-premises instance.
     */
    public final String instanceName() {
        return instanceName;
    }

    /**
     * <p>
     * The ARN of the IAM session associated with the on-premises instance.
     * </p>
     * 
     * @return The ARN of the IAM session associated with the on-premises instance.
     */
    public final String iamSessionArn() {
        return iamSessionArn;
    }

    /**
     * <p>
     * The user ARN associated with the on-premises instance.
     * </p>
     * 
     * @return The user ARN associated with the on-premises instance.
     */
    public final String iamUserArn() {
        return iamUserArn;
    }

    /**
     * <p>
     * The ARN of the on-premises instance.
     * </p>
     * 
     * @return The ARN of the on-premises instance.
     */
    public final String instanceArn() {
        return instanceArn;
    }

    /**
     * <p>
     * The time at which the on-premises instance was registered.
     * </p>
     * 
     * @return The time at which the on-premises instance was registered.
     */
    public final Instant registerTime() {
        return registerTime;
    }

    /**
     * <p>
     * If the on-premises instance was deregistered, the time at which the on-premises instance was deregistered.
     * </p>
     * 
     * @return If the on-premises instance was deregistered, the time at which the on-premises instance was
     *         deregistered.
     */
    public final Instant deregisterTime() {
        return deregisterTime;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The tags currently associated with the on-premises instance.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return The tags currently associated with the on-premises instance.
     */
    public final List<Tag> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(instanceName());
        hashCode = 31 * hashCode + Objects.hashCode(iamSessionArn());
        hashCode = 31 * hashCode + Objects.hashCode(iamUserArn());
        hashCode = 31 * hashCode + Objects.hashCode(instanceArn());
        hashCode = 31 * hashCode + Objects.hashCode(registerTime());
        hashCode = 31 * hashCode + Objects.hashCode(deregisterTime());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InstanceInfo)) {
            return false;
        }
        InstanceInfo other = (InstanceInfo) obj;
        return Objects.equals(instanceName(), other.instanceName()) && Objects.equals(iamSessionArn(), other.iamSessionArn())
                && Objects.equals(iamUserArn(), other.iamUserArn()) && Objects.equals(instanceArn(), other.instanceArn())
                && Objects.equals(registerTime(), other.registerTime())
                && Objects.equals(deregisterTime(), other.deregisterTime()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("InstanceInfo").add("InstanceName", instanceName()).add("IamSessionArn", iamSessionArn())
                .add("IamUserArn", iamUserArn()).add("InstanceArn", instanceArn()).add("RegisterTime", registerTime())
                .add("DeregisterTime", deregisterTime()).add("Tags", hasTags() ? tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "instanceName":
            return Optional.ofNullable(clazz.cast(instanceName()));
        case "iamSessionArn":
            return Optional.ofNullable(clazz.cast(iamSessionArn()));
        case "iamUserArn":
            return Optional.ofNullable(clazz.cast(iamUserArn()));
        case "instanceArn":
            return Optional.ofNullable(clazz.cast(instanceArn()));
        case "registerTime":
            return Optional.ofNullable(clazz.cast(registerTime()));
        case "deregisterTime":
            return Optional.ofNullable(clazz.cast(deregisterTime()));
        case "tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("instanceName", INSTANCE_NAME_FIELD);
        map.put("iamSessionArn", IAM_SESSION_ARN_FIELD);
        map.put("iamUserArn", IAM_USER_ARN_FIELD);
        map.put("instanceArn", INSTANCE_ARN_FIELD);
        map.put("registerTime", REGISTER_TIME_FIELD);
        map.put("deregisterTime", DEREGISTER_TIME_FIELD);
        map.put("tags", TAGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<InstanceInfo, T> g) {
        return obj -> g.apply((InstanceInfo) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, InstanceInfo> {
        /**
         * <p>
         * The name of the on-premises instance.
         * </p>
         * 
         * @param instanceName
         *        The name of the on-premises instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceName(String instanceName);

        /**
         * <p>
         * The ARN of the IAM session associated with the on-premises instance.
         * </p>
         * 
         * @param iamSessionArn
         *        The ARN of the IAM session associated with the on-premises instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder iamSessionArn(String iamSessionArn);

        /**
         * <p>
         * The user ARN associated with the on-premises instance.
         * </p>
         * 
         * @param iamUserArn
         *        The user ARN associated with the on-premises instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder iamUserArn(String iamUserArn);

        /**
         * <p>
         * The ARN of the on-premises instance.
         * </p>
         * 
         * @param instanceArn
         *        The ARN of the on-premises instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceArn(String instanceArn);

        /**
         * <p>
         * The time at which the on-premises instance was registered.
         * </p>
         * 
         * @param registerTime
         *        The time at which the on-premises instance was registered.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder registerTime(Instant registerTime);

        /**
         * <p>
         * If the on-premises instance was deregistered, the time at which the on-premises instance was deregistered.
         * </p>
         * 
         * @param deregisterTime
         *        If the on-premises instance was deregistered, the time at which the on-premises instance was
         *        deregistered.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deregisterTime(Instant deregisterTime);

        /**
         * <p>
         * The tags currently associated with the on-premises instance.
         * </p>
         * 
         * @param tags
         *        The tags currently associated with the on-premises instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Collection<Tag> tags);

        /**
         * <p>
         * The tags currently associated with the on-premises instance.
         * </p>
         * 
         * @param tags
         *        The tags currently associated with the on-premises instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Tag... tags);

        /**
         * <p>
         * The tags currently associated with the on-premises instance.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.codedeploy.model.Tag.Builder} avoiding the need to create one manually
         * via {@link software.amazon.awssdk.services.codedeploy.model.Tag#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.codedeploy.model.Tag.Builder#build()} is called immediately and its
         * result is passed to {@link #tags(List<Tag>)}.
         * 
         * @param tags
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.codedeploy.model.Tag.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tags(java.util.Collection<Tag>)
         */
        Builder tags(Consumer<Tag.Builder>... tags);
    }

    static final class BuilderImpl implements Builder {
        private String instanceName;

        private String iamSessionArn;

        private String iamUserArn;

        private String instanceArn;

        private Instant registerTime;

        private Instant deregisterTime;

        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(InstanceInfo model) {
            instanceName(model.instanceName);
            iamSessionArn(model.iamSessionArn);
            iamUserArn(model.iamUserArn);
            instanceArn(model.instanceArn);
            registerTime(model.registerTime);
            deregisterTime(model.deregisterTime);
            tags(model.tags);
        }

        public final String getInstanceName() {
            return instanceName;
        }

        public final void setInstanceName(String instanceName) {
            this.instanceName = instanceName;
        }

        @Override
        public final Builder instanceName(String instanceName) {
            this.instanceName = instanceName;
            return this;
        }

        public final String getIamSessionArn() {
            return iamSessionArn;
        }

        public final void setIamSessionArn(String iamSessionArn) {
            this.iamSessionArn = iamSessionArn;
        }

        @Override
        public final Builder iamSessionArn(String iamSessionArn) {
            this.iamSessionArn = iamSessionArn;
            return this;
        }

        public final String getIamUserArn() {
            return iamUserArn;
        }

        public final void setIamUserArn(String iamUserArn) {
            this.iamUserArn = iamUserArn;
        }

        @Override
        public final Builder iamUserArn(String iamUserArn) {
            this.iamUserArn = iamUserArn;
            return this;
        }

        public final String getInstanceArn() {
            return instanceArn;
        }

        public final void setInstanceArn(String instanceArn) {
            this.instanceArn = instanceArn;
        }

        @Override
        public final Builder instanceArn(String instanceArn) {
            this.instanceArn = instanceArn;
            return this;
        }

        public final Instant getRegisterTime() {
            return registerTime;
        }

        public final void setRegisterTime(Instant registerTime) {
            this.registerTime = registerTime;
        }

        @Override
        public final Builder registerTime(Instant registerTime) {
            this.registerTime = registerTime;
            return this;
        }

        public final Instant getDeregisterTime() {
            return deregisterTime;
        }

        public final void setDeregisterTime(Instant deregisterTime) {
            this.deregisterTime = deregisterTime;
        }

        @Override
        public final Builder deregisterTime(Instant deregisterTime) {
            this.deregisterTime = deregisterTime;
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag... tags) {
            tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder>... tags) {
            tags(Stream.of(tags).map(c -> Tag.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public InstanceInfo build() {
            return new InstanceInfo(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
