/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codedeploy.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.codedeploy.model.DeploymentOption;
import software.amazon.awssdk.services.codedeploy.model.DeploymentType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DeploymentStyle
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, DeploymentStyle> {
    private static final SdkField<String> DEPLOYMENT_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DeploymentStyle.getter(DeploymentStyle::deploymentTypeAsString)).setter(DeploymentStyle.setter(Builder::deploymentType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("deploymentType").build()}).build();
    private static final SdkField<String> DEPLOYMENT_OPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DeploymentStyle.getter(DeploymentStyle::deploymentOptionAsString)).setter(DeploymentStyle.setter(Builder::deploymentOption)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("deploymentOption").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DEPLOYMENT_TYPE_FIELD, DEPLOYMENT_OPTION_FIELD));
    private static final long serialVersionUID = 1L;
    private final String deploymentType;
    private final String deploymentOption;

    private DeploymentStyle(BuilderImpl builder) {
        this.deploymentType = builder.deploymentType;
        this.deploymentOption = builder.deploymentOption;
    }

    public DeploymentType deploymentType() {
        return DeploymentType.fromValue(this.deploymentType);
    }

    public String deploymentTypeAsString() {
        return this.deploymentType;
    }

    public DeploymentOption deploymentOption() {
        return DeploymentOption.fromValue(this.deploymentOption);
    }

    public String deploymentOptionAsString() {
        return this.deploymentOption;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.deploymentTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.deploymentOptionAsString());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeploymentStyle)) {
            return false;
        }
        DeploymentStyle other = (DeploymentStyle)obj;
        return Objects.equals(this.deploymentTypeAsString(), other.deploymentTypeAsString()) && Objects.equals(this.deploymentOptionAsString(), other.deploymentOptionAsString());
    }

    public String toString() {
        return ToString.builder((String)"DeploymentStyle").add("DeploymentType", (Object)this.deploymentTypeAsString()).add("DeploymentOption", (Object)this.deploymentOptionAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "deploymentType": {
                return Optional.ofNullable(clazz.cast(this.deploymentTypeAsString()));
            }
            case "deploymentOption": {
                return Optional.ofNullable(clazz.cast(this.deploymentOptionAsString()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DeploymentStyle, T> g) {
        return obj -> g.apply((DeploymentStyle)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String deploymentType;
        private String deploymentOption;

        private BuilderImpl() {
        }

        private BuilderImpl(DeploymentStyle model) {
            this.deploymentType(model.deploymentType);
            this.deploymentOption(model.deploymentOption);
        }

        public final String getDeploymentType() {
            return this.deploymentType;
        }

        @Override
        public final Builder deploymentType(String deploymentType) {
            this.deploymentType = deploymentType;
            return this;
        }

        @Override
        public final Builder deploymentType(DeploymentType deploymentType) {
            this.deploymentType(deploymentType.toString());
            return this;
        }

        public final void setDeploymentType(String deploymentType) {
            this.deploymentType = deploymentType;
        }

        public final String getDeploymentOption() {
            return this.deploymentOption;
        }

        @Override
        public final Builder deploymentOption(String deploymentOption) {
            this.deploymentOption = deploymentOption;
            return this;
        }

        @Override
        public final Builder deploymentOption(DeploymentOption deploymentOption) {
            this.deploymentOption(deploymentOption.toString());
            return this;
        }

        public final void setDeploymentOption(String deploymentOption) {
            this.deploymentOption = deploymentOption;
        }

        public DeploymentStyle build() {
            return new DeploymentStyle(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, DeploymentStyle> {
        public Builder deploymentType(String var1);

        public Builder deploymentType(DeploymentType var1);

        public Builder deploymentOption(String var1);

        public Builder deploymentOption(DeploymentOption var1);
    }
}

