/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codedeploy.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.codedeploy.model.InstanceAction;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class BlueInstanceTerminationOption
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, BlueInstanceTerminationOption> {
    private static final SdkField<String> ACTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(BlueInstanceTerminationOption.getter(BlueInstanceTerminationOption::actionAsString)).setter(BlueInstanceTerminationOption.setter(Builder::action)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("action").build()}).build();
    private static final SdkField<Integer> TERMINATION_WAIT_TIME_IN_MINUTES_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).getter(BlueInstanceTerminationOption.getter(BlueInstanceTerminationOption::terminationWaitTimeInMinutes)).setter(BlueInstanceTerminationOption.setter(Builder::terminationWaitTimeInMinutes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("terminationWaitTimeInMinutes").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACTION_FIELD, TERMINATION_WAIT_TIME_IN_MINUTES_FIELD));
    private static final long serialVersionUID = 1L;
    private final String action;
    private final Integer terminationWaitTimeInMinutes;

    private BlueInstanceTerminationOption(BuilderImpl builder) {
        this.action = builder.action;
        this.terminationWaitTimeInMinutes = builder.terminationWaitTimeInMinutes;
    }

    public InstanceAction action() {
        return InstanceAction.fromValue(this.action);
    }

    public String actionAsString() {
        return this.action;
    }

    public Integer terminationWaitTimeInMinutes() {
        return this.terminationWaitTimeInMinutes;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.actionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.terminationWaitTimeInMinutes());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BlueInstanceTerminationOption)) {
            return false;
        }
        BlueInstanceTerminationOption other = (BlueInstanceTerminationOption)obj;
        return Objects.equals(this.actionAsString(), other.actionAsString()) && Objects.equals(this.terminationWaitTimeInMinutes(), other.terminationWaitTimeInMinutes());
    }

    public String toString() {
        return ToString.builder((String)"BlueInstanceTerminationOption").add("Action", (Object)this.actionAsString()).add("TerminationWaitTimeInMinutes", (Object)this.terminationWaitTimeInMinutes()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "action": {
                return Optional.ofNullable(clazz.cast(this.actionAsString()));
            }
            case "terminationWaitTimeInMinutes": {
                return Optional.ofNullable(clazz.cast(this.terminationWaitTimeInMinutes()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<BlueInstanceTerminationOption, T> g) {
        return obj -> g.apply((BlueInstanceTerminationOption)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String action;
        private Integer terminationWaitTimeInMinutes;

        private BuilderImpl() {
        }

        private BuilderImpl(BlueInstanceTerminationOption model) {
            this.action(model.action);
            this.terminationWaitTimeInMinutes(model.terminationWaitTimeInMinutes);
        }

        public final String getAction() {
            return this.action;
        }

        @Override
        public final Builder action(String action) {
            this.action = action;
            return this;
        }

        @Override
        public final Builder action(InstanceAction action) {
            this.action(action.toString());
            return this;
        }

        public final void setAction(String action) {
            this.action = action;
        }

        public final Integer getTerminationWaitTimeInMinutes() {
            return this.terminationWaitTimeInMinutes;
        }

        @Override
        public final Builder terminationWaitTimeInMinutes(Integer terminationWaitTimeInMinutes) {
            this.terminationWaitTimeInMinutes = terminationWaitTimeInMinutes;
            return this;
        }

        public final void setTerminationWaitTimeInMinutes(Integer terminationWaitTimeInMinutes) {
            this.terminationWaitTimeInMinutes = terminationWaitTimeInMinutes;
        }

        public BlueInstanceTerminationOption build() {
            return new BlueInstanceTerminationOption(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, BlueInstanceTerminationOption> {
        public Builder action(String var1);

        public Builder action(InstanceAction var1);

        public Builder terminationWaitTimeInMinutes(Integer var1);
    }
}

