/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codedeploy.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.codedeploy.model.AutoRollbackConfiguration;
import software.amazon.awssdk.services.codedeploy.model.CodeDeployRequest;
import software.amazon.awssdk.services.codedeploy.model.FileExistsBehavior;
import software.amazon.awssdk.services.codedeploy.model.RevisionLocation;
import software.amazon.awssdk.services.codedeploy.model.TargetInstances;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateDeploymentRequest
extends CodeDeployRequest
implements ToCopyableBuilder<Builder, CreateDeploymentRequest> {
    private static final SdkField<String> APPLICATION_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("applicationName").getter(CreateDeploymentRequest.getter(CreateDeploymentRequest::applicationName)).setter(CreateDeploymentRequest.setter(Builder::applicationName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("applicationName").build()}).build();
    private static final SdkField<String> DEPLOYMENT_GROUP_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("deploymentGroupName").getter(CreateDeploymentRequest.getter(CreateDeploymentRequest::deploymentGroupName)).setter(CreateDeploymentRequest.setter(Builder::deploymentGroupName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("deploymentGroupName").build()}).build();
    private static final SdkField<RevisionLocation> REVISION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("revision").getter(CreateDeploymentRequest.getter(CreateDeploymentRequest::revision)).setter(CreateDeploymentRequest.setter(Builder::revision)).constructor(RevisionLocation::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("revision").build()}).build();
    private static final SdkField<String> DEPLOYMENT_CONFIG_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("deploymentConfigName").getter(CreateDeploymentRequest.getter(CreateDeploymentRequest::deploymentConfigName)).setter(CreateDeploymentRequest.setter(Builder::deploymentConfigName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("deploymentConfigName").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("description").getter(CreateDeploymentRequest.getter(CreateDeploymentRequest::description)).setter(CreateDeploymentRequest.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()}).build();
    private static final SdkField<Boolean> IGNORE_APPLICATION_STOP_FAILURES_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("ignoreApplicationStopFailures").getter(CreateDeploymentRequest.getter(CreateDeploymentRequest::ignoreApplicationStopFailures)).setter(CreateDeploymentRequest.setter(Builder::ignoreApplicationStopFailures)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ignoreApplicationStopFailures").build()}).build();
    private static final SdkField<TargetInstances> TARGET_INSTANCES_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("targetInstances").getter(CreateDeploymentRequest.getter(CreateDeploymentRequest::targetInstances)).setter(CreateDeploymentRequest.setter(Builder::targetInstances)).constructor(TargetInstances::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("targetInstances").build()}).build();
    private static final SdkField<AutoRollbackConfiguration> AUTO_ROLLBACK_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("autoRollbackConfiguration").getter(CreateDeploymentRequest.getter(CreateDeploymentRequest::autoRollbackConfiguration)).setter(CreateDeploymentRequest.setter(Builder::autoRollbackConfiguration)).constructor(AutoRollbackConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("autoRollbackConfiguration").build()}).build();
    private static final SdkField<Boolean> UPDATE_OUTDATED_INSTANCES_ONLY_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("updateOutdatedInstancesOnly").getter(CreateDeploymentRequest.getter(CreateDeploymentRequest::updateOutdatedInstancesOnly)).setter(CreateDeploymentRequest.setter(Builder::updateOutdatedInstancesOnly)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("updateOutdatedInstancesOnly").build()}).build();
    private static final SdkField<String> FILE_EXISTS_BEHAVIOR_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("fileExistsBehavior").getter(CreateDeploymentRequest.getter(CreateDeploymentRequest::fileExistsBehaviorAsString)).setter(CreateDeploymentRequest.setter(Builder::fileExistsBehavior)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("fileExistsBehavior").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APPLICATION_NAME_FIELD, DEPLOYMENT_GROUP_NAME_FIELD, REVISION_FIELD, DEPLOYMENT_CONFIG_NAME_FIELD, DESCRIPTION_FIELD, IGNORE_APPLICATION_STOP_FAILURES_FIELD, TARGET_INSTANCES_FIELD, AUTO_ROLLBACK_CONFIGURATION_FIELD, UPDATE_OUTDATED_INSTANCES_ONLY_FIELD, FILE_EXISTS_BEHAVIOR_FIELD));
    private final String applicationName;
    private final String deploymentGroupName;
    private final RevisionLocation revision;
    private final String deploymentConfigName;
    private final String description;
    private final Boolean ignoreApplicationStopFailures;
    private final TargetInstances targetInstances;
    private final AutoRollbackConfiguration autoRollbackConfiguration;
    private final Boolean updateOutdatedInstancesOnly;
    private final String fileExistsBehavior;

    private CreateDeploymentRequest(BuilderImpl builder) {
        super(builder);
        this.applicationName = builder.applicationName;
        this.deploymentGroupName = builder.deploymentGroupName;
        this.revision = builder.revision;
        this.deploymentConfigName = builder.deploymentConfigName;
        this.description = builder.description;
        this.ignoreApplicationStopFailures = builder.ignoreApplicationStopFailures;
        this.targetInstances = builder.targetInstances;
        this.autoRollbackConfiguration = builder.autoRollbackConfiguration;
        this.updateOutdatedInstancesOnly = builder.updateOutdatedInstancesOnly;
        this.fileExistsBehavior = builder.fileExistsBehavior;
    }

    public final String applicationName() {
        return this.applicationName;
    }

    public final String deploymentGroupName() {
        return this.deploymentGroupName;
    }

    public final RevisionLocation revision() {
        return this.revision;
    }

    public final String deploymentConfigName() {
        return this.deploymentConfigName;
    }

    public final String description() {
        return this.description;
    }

    public final Boolean ignoreApplicationStopFailures() {
        return this.ignoreApplicationStopFailures;
    }

    public final TargetInstances targetInstances() {
        return this.targetInstances;
    }

    public final AutoRollbackConfiguration autoRollbackConfiguration() {
        return this.autoRollbackConfiguration;
    }

    public final Boolean updateOutdatedInstancesOnly() {
        return this.updateOutdatedInstancesOnly;
    }

    public final FileExistsBehavior fileExistsBehavior() {
        return FileExistsBehavior.fromValue(this.fileExistsBehavior);
    }

    public final String fileExistsBehaviorAsString() {
        return this.fileExistsBehavior;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.applicationName());
        hashCode = 31 * hashCode + Objects.hashCode(this.deploymentGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(this.revision());
        hashCode = 31 * hashCode + Objects.hashCode(this.deploymentConfigName());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.ignoreApplicationStopFailures());
        hashCode = 31 * hashCode + Objects.hashCode(this.targetInstances());
        hashCode = 31 * hashCode + Objects.hashCode(this.autoRollbackConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.updateOutdatedInstancesOnly());
        hashCode = 31 * hashCode + Objects.hashCode(this.fileExistsBehaviorAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateDeploymentRequest)) {
            return false;
        }
        CreateDeploymentRequest other = (CreateDeploymentRequest)((Object)obj);
        return Objects.equals(this.applicationName(), other.applicationName()) && Objects.equals(this.deploymentGroupName(), other.deploymentGroupName()) && Objects.equals(this.revision(), other.revision()) && Objects.equals(this.deploymentConfigName(), other.deploymentConfigName()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.ignoreApplicationStopFailures(), other.ignoreApplicationStopFailures()) && Objects.equals(this.targetInstances(), other.targetInstances()) && Objects.equals(this.autoRollbackConfiguration(), other.autoRollbackConfiguration()) && Objects.equals(this.updateOutdatedInstancesOnly(), other.updateOutdatedInstancesOnly()) && Objects.equals(this.fileExistsBehaviorAsString(), other.fileExistsBehaviorAsString());
    }

    public final String toString() {
        return ToString.builder((String)"CreateDeploymentRequest").add("ApplicationName", (Object)this.applicationName()).add("DeploymentGroupName", (Object)this.deploymentGroupName()).add("Revision", (Object)this.revision()).add("DeploymentConfigName", (Object)this.deploymentConfigName()).add("Description", (Object)this.description()).add("IgnoreApplicationStopFailures", (Object)this.ignoreApplicationStopFailures()).add("TargetInstances", (Object)this.targetInstances()).add("AutoRollbackConfiguration", (Object)this.autoRollbackConfiguration()).add("UpdateOutdatedInstancesOnly", (Object)this.updateOutdatedInstancesOnly()).add("FileExistsBehavior", (Object)this.fileExistsBehaviorAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "applicationName": {
                return Optional.ofNullable(clazz.cast(this.applicationName()));
            }
            case "deploymentGroupName": {
                return Optional.ofNullable(clazz.cast(this.deploymentGroupName()));
            }
            case "revision": {
                return Optional.ofNullable(clazz.cast(this.revision()));
            }
            case "deploymentConfigName": {
                return Optional.ofNullable(clazz.cast(this.deploymentConfigName()));
            }
            case "description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "ignoreApplicationStopFailures": {
                return Optional.ofNullable(clazz.cast(this.ignoreApplicationStopFailures()));
            }
            case "targetInstances": {
                return Optional.ofNullable(clazz.cast(this.targetInstances()));
            }
            case "autoRollbackConfiguration": {
                return Optional.ofNullable(clazz.cast(this.autoRollbackConfiguration()));
            }
            case "updateOutdatedInstancesOnly": {
                return Optional.ofNullable(clazz.cast(this.updateOutdatedInstancesOnly()));
            }
            case "fileExistsBehavior": {
                return Optional.ofNullable(clazz.cast(this.fileExistsBehaviorAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateDeploymentRequest, T> g) {
        return obj -> g.apply((CreateDeploymentRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CodeDeployRequest.BuilderImpl
    implements Builder {
        private String applicationName;
        private String deploymentGroupName;
        private RevisionLocation revision;
        private String deploymentConfigName;
        private String description;
        private Boolean ignoreApplicationStopFailures;
        private TargetInstances targetInstances;
        private AutoRollbackConfiguration autoRollbackConfiguration;
        private Boolean updateOutdatedInstancesOnly;
        private String fileExistsBehavior;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateDeploymentRequest model) {
            super(model);
            this.applicationName(model.applicationName);
            this.deploymentGroupName(model.deploymentGroupName);
            this.revision(model.revision);
            this.deploymentConfigName(model.deploymentConfigName);
            this.description(model.description);
            this.ignoreApplicationStopFailures(model.ignoreApplicationStopFailures);
            this.targetInstances(model.targetInstances);
            this.autoRollbackConfiguration(model.autoRollbackConfiguration);
            this.updateOutdatedInstancesOnly(model.updateOutdatedInstancesOnly);
            this.fileExistsBehavior(model.fileExistsBehavior);
        }

        public final String getApplicationName() {
            return this.applicationName;
        }

        public final void setApplicationName(String applicationName) {
            this.applicationName = applicationName;
        }

        @Override
        public final Builder applicationName(String applicationName) {
            this.applicationName = applicationName;
            return this;
        }

        public final String getDeploymentGroupName() {
            return this.deploymentGroupName;
        }

        public final void setDeploymentGroupName(String deploymentGroupName) {
            this.deploymentGroupName = deploymentGroupName;
        }

        @Override
        public final Builder deploymentGroupName(String deploymentGroupName) {
            this.deploymentGroupName = deploymentGroupName;
            return this;
        }

        public final RevisionLocation.Builder getRevision() {
            return this.revision != null ? this.revision.toBuilder() : null;
        }

        public final void setRevision(RevisionLocation.BuilderImpl revision) {
            this.revision = revision != null ? revision.build() : null;
        }

        @Override
        public final Builder revision(RevisionLocation revision) {
            this.revision = revision;
            return this;
        }

        public final String getDeploymentConfigName() {
            return this.deploymentConfigName;
        }

        public final void setDeploymentConfigName(String deploymentConfigName) {
            this.deploymentConfigName = deploymentConfigName;
        }

        @Override
        public final Builder deploymentConfigName(String deploymentConfigName) {
            this.deploymentConfigName = deploymentConfigName;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final Boolean getIgnoreApplicationStopFailures() {
            return this.ignoreApplicationStopFailures;
        }

        public final void setIgnoreApplicationStopFailures(Boolean ignoreApplicationStopFailures) {
            this.ignoreApplicationStopFailures = ignoreApplicationStopFailures;
        }

        @Override
        public final Builder ignoreApplicationStopFailures(Boolean ignoreApplicationStopFailures) {
            this.ignoreApplicationStopFailures = ignoreApplicationStopFailures;
            return this;
        }

        public final TargetInstances.Builder getTargetInstances() {
            return this.targetInstances != null ? this.targetInstances.toBuilder() : null;
        }

        public final void setTargetInstances(TargetInstances.BuilderImpl targetInstances) {
            this.targetInstances = targetInstances != null ? targetInstances.build() : null;
        }

        @Override
        public final Builder targetInstances(TargetInstances targetInstances) {
            this.targetInstances = targetInstances;
            return this;
        }

        public final AutoRollbackConfiguration.Builder getAutoRollbackConfiguration() {
            return this.autoRollbackConfiguration != null ? this.autoRollbackConfiguration.toBuilder() : null;
        }

        public final void setAutoRollbackConfiguration(AutoRollbackConfiguration.BuilderImpl autoRollbackConfiguration) {
            this.autoRollbackConfiguration = autoRollbackConfiguration != null ? autoRollbackConfiguration.build() : null;
        }

        @Override
        public final Builder autoRollbackConfiguration(AutoRollbackConfiguration autoRollbackConfiguration) {
            this.autoRollbackConfiguration = autoRollbackConfiguration;
            return this;
        }

        public final Boolean getUpdateOutdatedInstancesOnly() {
            return this.updateOutdatedInstancesOnly;
        }

        public final void setUpdateOutdatedInstancesOnly(Boolean updateOutdatedInstancesOnly) {
            this.updateOutdatedInstancesOnly = updateOutdatedInstancesOnly;
        }

        @Override
        public final Builder updateOutdatedInstancesOnly(Boolean updateOutdatedInstancesOnly) {
            this.updateOutdatedInstancesOnly = updateOutdatedInstancesOnly;
            return this;
        }

        public final String getFileExistsBehavior() {
            return this.fileExistsBehavior;
        }

        public final void setFileExistsBehavior(String fileExistsBehavior) {
            this.fileExistsBehavior = fileExistsBehavior;
        }

        @Override
        public final Builder fileExistsBehavior(String fileExistsBehavior) {
            this.fileExistsBehavior = fileExistsBehavior;
            return this;
        }

        @Override
        public final Builder fileExistsBehavior(FileExistsBehavior fileExistsBehavior) {
            this.fileExistsBehavior(fileExistsBehavior == null ? null : fileExistsBehavior.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateDeploymentRequest build() {
            return new CreateDeploymentRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends CodeDeployRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateDeploymentRequest> {
        public Builder applicationName(String var1);

        public Builder deploymentGroupName(String var1);

        public Builder revision(RevisionLocation var1);

        default public Builder revision(Consumer<RevisionLocation.Builder> revision) {
            return this.revision((RevisionLocation)((RevisionLocation.Builder)RevisionLocation.builder().applyMutation(revision)).build());
        }

        public Builder deploymentConfigName(String var1);

        public Builder description(String var1);

        public Builder ignoreApplicationStopFailures(Boolean var1);

        public Builder targetInstances(TargetInstances var1);

        default public Builder targetInstances(Consumer<TargetInstances.Builder> targetInstances) {
            return this.targetInstances((TargetInstances)((TargetInstances.Builder)TargetInstances.builder().applyMutation(targetInstances)).build());
        }

        public Builder autoRollbackConfiguration(AutoRollbackConfiguration var1);

        default public Builder autoRollbackConfiguration(Consumer<AutoRollbackConfiguration.Builder> autoRollbackConfiguration) {
            return this.autoRollbackConfiguration((AutoRollbackConfiguration)((AutoRollbackConfiguration.Builder)AutoRollbackConfiguration.builder().applyMutation(autoRollbackConfiguration)).build());
        }

        public Builder updateOutdatedInstancesOnly(Boolean var1);

        public Builder fileExistsBehavior(String var1);

        public Builder fileExistsBehavior(FileExistsBehavior var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

