/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codedeploy.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.codedeploy.model.CodeDeployResponse;
import software.amazon.awssdk.services.codedeploy.model.InstanceInfo;
import software.amazon.awssdk.services.codedeploy.model.InstanceInfoListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class BatchGetOnPremisesInstancesResponse
extends CodeDeployResponse
implements ToCopyableBuilder<Builder, BatchGetOnPremisesInstancesResponse> {
    private static final SdkField<List<InstanceInfo>> INSTANCE_INFOS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("instanceInfos").getter(BatchGetOnPremisesInstancesResponse.getter(BatchGetOnPremisesInstancesResponse::instanceInfos)).setter(BatchGetOnPremisesInstancesResponse.setter(Builder::instanceInfos)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("instanceInfos").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(InstanceInfo::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INSTANCE_INFOS_FIELD));
    private final List<InstanceInfo> instanceInfos;

    private BatchGetOnPremisesInstancesResponse(BuilderImpl builder) {
        super(builder);
        this.instanceInfos = builder.instanceInfos;
    }

    public boolean hasInstanceInfos() {
        return this.instanceInfos != null && !(this.instanceInfos instanceof SdkAutoConstructList);
    }

    public List<InstanceInfo> instanceInfos() {
        return this.instanceInfos;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceInfos());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchGetOnPremisesInstancesResponse)) {
            return false;
        }
        BatchGetOnPremisesInstancesResponse other = (BatchGetOnPremisesInstancesResponse)((Object)obj);
        return Objects.equals(this.instanceInfos(), other.instanceInfos());
    }

    public String toString() {
        return ToString.builder((String)"BatchGetOnPremisesInstancesResponse").add("InstanceInfos", this.instanceInfos()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "instanceInfos": {
                return Optional.ofNullable(clazz.cast(this.instanceInfos()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<BatchGetOnPremisesInstancesResponse, T> g) {
        return obj -> g.apply((BatchGetOnPremisesInstancesResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CodeDeployResponse.BuilderImpl
    implements Builder {
        private List<InstanceInfo> instanceInfos = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(BatchGetOnPremisesInstancesResponse model) {
            super(model);
            this.instanceInfos(model.instanceInfos);
        }

        public final Collection<InstanceInfo.Builder> getInstanceInfos() {
            return this.instanceInfos != null ? (Collection)this.instanceInfos.stream().map(InstanceInfo::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder instanceInfos(Collection<InstanceInfo> instanceInfos) {
            this.instanceInfos = InstanceInfoListCopier.copy(instanceInfos);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder instanceInfos(InstanceInfo ... instanceInfos) {
            this.instanceInfos(Arrays.asList(instanceInfos));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder instanceInfos(Consumer<InstanceInfo.Builder> ... instanceInfos) {
            this.instanceInfos(Stream.of(instanceInfos).map(c -> (InstanceInfo)((InstanceInfo.Builder)InstanceInfo.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setInstanceInfos(Collection<InstanceInfo.BuilderImpl> instanceInfos) {
            this.instanceInfos = InstanceInfoListCopier.copyFromBuilder(instanceInfos);
        }

        @Override
        public BatchGetOnPremisesInstancesResponse build() {
            return new BatchGetOnPremisesInstancesResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends CodeDeployResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, BatchGetOnPremisesInstancesResponse> {
        public Builder instanceInfos(Collection<InstanceInfo> var1);

        public Builder instanceInfos(InstanceInfo ... var1);

        public Builder instanceInfos(Consumer<InstanceInfo.Builder> ... var1);
    }
}

