/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codedeploy.model;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum RevisionLocationType {
    S3("S3"),
    GIT_HUB("GitHub"),
    STRING("String"),
    APP_SPEC_CONTENT("AppSpecContent"),
    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private RevisionLocationType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static RevisionLocationType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(RevisionLocationType.values()).filter(e -> e.toString().equals(value)).findFirst().orElse(UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<RevisionLocationType> knownValues() {
        return Stream.of(RevisionLocationType.values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(Collectors.toSet());
    }
}

