/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codedeploy.model;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum DeploymentTargetType {
    INSTANCE_TARGET("InstanceTarget"),
    LAMBDA_TARGET("LambdaTarget"),
    ECS_TARGET("ECSTarget"),
    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private DeploymentTargetType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static DeploymentTargetType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(DeploymentTargetType.values()).filter(e -> e.toString().equals(value)).findFirst().orElse(UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<DeploymentTargetType> knownValues() {
        return Stream.of(DeploymentTargetType.values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(Collectors.toSet());
    }
}

