/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codedeploy.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.codedeploy.model.Diagnostics;
import software.amazon.awssdk.services.codedeploy.model.LifecycleEventStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class LifecycleEvent
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, LifecycleEvent> {
    private static final SdkField<String> LIFECYCLE_EVENT_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(LifecycleEvent.getter(LifecycleEvent::lifecycleEventName)).setter(LifecycleEvent.setter(Builder::lifecycleEventName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lifecycleEventName").build()}).build();
    private static final SdkField<Diagnostics> DIAGNOSTICS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(LifecycleEvent.getter(LifecycleEvent::diagnostics)).setter(LifecycleEvent.setter(Builder::diagnostics)).constructor(Diagnostics::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("diagnostics").build()}).build();
    private static final SdkField<Instant> START_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).getter(LifecycleEvent.getter(LifecycleEvent::startTime)).setter(LifecycleEvent.setter(Builder::startTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("startTime").build()}).build();
    private static final SdkField<Instant> END_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).getter(LifecycleEvent.getter(LifecycleEvent::endTime)).setter(LifecycleEvent.setter(Builder::endTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("endTime").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(LifecycleEvent.getter(LifecycleEvent::statusAsString)).setter(LifecycleEvent.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LIFECYCLE_EVENT_NAME_FIELD, DIAGNOSTICS_FIELD, START_TIME_FIELD, END_TIME_FIELD, STATUS_FIELD));
    private static final long serialVersionUID = 1L;
    private final String lifecycleEventName;
    private final Diagnostics diagnostics;
    private final Instant startTime;
    private final Instant endTime;
    private final String status;

    private LifecycleEvent(BuilderImpl builder) {
        this.lifecycleEventName = builder.lifecycleEventName;
        this.diagnostics = builder.diagnostics;
        this.startTime = builder.startTime;
        this.endTime = builder.endTime;
        this.status = builder.status;
    }

    public String lifecycleEventName() {
        return this.lifecycleEventName;
    }

    public Diagnostics diagnostics() {
        return this.diagnostics;
    }

    public Instant startTime() {
        return this.startTime;
    }

    public Instant endTime() {
        return this.endTime;
    }

    public LifecycleEventStatus status() {
        return LifecycleEventStatus.fromValue(this.status);
    }

    public String statusAsString() {
        return this.status;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.lifecycleEventName());
        hashCode = 31 * hashCode + Objects.hashCode(this.diagnostics());
        hashCode = 31 * hashCode + Objects.hashCode(this.startTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.endTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LifecycleEvent)) {
            return false;
        }
        LifecycleEvent other = (LifecycleEvent)obj;
        return Objects.equals(this.lifecycleEventName(), other.lifecycleEventName()) && Objects.equals(this.diagnostics(), other.diagnostics()) && Objects.equals(this.startTime(), other.startTime()) && Objects.equals(this.endTime(), other.endTime()) && Objects.equals(this.statusAsString(), other.statusAsString());
    }

    public String toString() {
        return ToString.builder((String)"LifecycleEvent").add("LifecycleEventName", (Object)this.lifecycleEventName()).add("Diagnostics", (Object)this.diagnostics()).add("StartTime", (Object)this.startTime()).add("EndTime", (Object)this.endTime()).add("Status", (Object)this.statusAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "lifecycleEventName": {
                return Optional.ofNullable(clazz.cast(this.lifecycleEventName()));
            }
            case "diagnostics": {
                return Optional.ofNullable(clazz.cast(this.diagnostics()));
            }
            case "startTime": {
                return Optional.ofNullable(clazz.cast(this.startTime()));
            }
            case "endTime": {
                return Optional.ofNullable(clazz.cast(this.endTime()));
            }
            case "status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<LifecycleEvent, T> g) {
        return obj -> g.apply((LifecycleEvent)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String lifecycleEventName;
        private Diagnostics diagnostics;
        private Instant startTime;
        private Instant endTime;
        private String status;

        private BuilderImpl() {
        }

        private BuilderImpl(LifecycleEvent model) {
            this.lifecycleEventName(model.lifecycleEventName);
            this.diagnostics(model.diagnostics);
            this.startTime(model.startTime);
            this.endTime(model.endTime);
            this.status(model.status);
        }

        public final String getLifecycleEventName() {
            return this.lifecycleEventName;
        }

        @Override
        public final Builder lifecycleEventName(String lifecycleEventName) {
            this.lifecycleEventName = lifecycleEventName;
            return this;
        }

        public final void setLifecycleEventName(String lifecycleEventName) {
            this.lifecycleEventName = lifecycleEventName;
        }

        public final Diagnostics.Builder getDiagnostics() {
            return this.diagnostics != null ? this.diagnostics.toBuilder() : null;
        }

        @Override
        public final Builder diagnostics(Diagnostics diagnostics) {
            this.diagnostics = diagnostics;
            return this;
        }

        public final void setDiagnostics(Diagnostics.BuilderImpl diagnostics) {
            this.diagnostics = diagnostics != null ? diagnostics.build() : null;
        }

        public final Instant getStartTime() {
            return this.startTime;
        }

        @Override
        public final Builder startTime(Instant startTime) {
            this.startTime = startTime;
            return this;
        }

        public final void setStartTime(Instant startTime) {
            this.startTime = startTime;
        }

        public final Instant getEndTime() {
            return this.endTime;
        }

        @Override
        public final Builder endTime(Instant endTime) {
            this.endTime = endTime;
            return this;
        }

        public final void setEndTime(Instant endTime) {
            this.endTime = endTime;
        }

        public final String getStatusAsString() {
            return this.status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(LifecycleEventStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public LifecycleEvent build() {
            return new LifecycleEvent(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, LifecycleEvent> {
        public Builder lifecycleEventName(String var1);

        public Builder diagnostics(Diagnostics var1);

        default public Builder diagnostics(Consumer<Diagnostics.Builder> diagnostics) {
            return this.diagnostics((Diagnostics)((Diagnostics.Builder)Diagnostics.builder().applyMutation(diagnostics)).build());
        }

        public Builder startTime(Instant var1);

        public Builder endTime(Instant var1);

        public Builder status(String var1);

        public Builder status(LifecycleEventStatus var1);
    }
}

