/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.codedeploy.transform;

import com.fasterxml.jackson.core.JsonToken;
import software.amazon.awssdk.core.runtime.transform.JsonUnmarshallerContext;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.codedeploy.model.Diagnostics;

public class DiagnosticsUnmarshaller
implements Unmarshaller<Diagnostics, JsonUnmarshallerContext> {
    private static final DiagnosticsUnmarshaller INSTANCE = new DiagnosticsUnmarshaller();

    public Diagnostics unmarshall(JsonUnmarshallerContext context) throws Exception {
        Diagnostics.Builder diagnosticsBuilder = Diagnostics.builder();
        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;
        JsonToken token = context.getCurrentToken();
        if (token == null) {
            token = context.nextToken();
        }
        if (token == JsonToken.VALUE_NULL) {
            return null;
        }
        while (token != null) {
            if (token == JsonToken.FIELD_NAME || token == JsonToken.START_OBJECT) {
                if (context.testExpression("errorCode", targetDepth)) {
                    context.nextToken();
                    diagnosticsBuilder.errorCode((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("scriptName", targetDepth)) {
                    context.nextToken();
                    diagnosticsBuilder.scriptName((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("message", targetDepth)) {
                    context.nextToken();
                    diagnosticsBuilder.message((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("logTail", targetDepth)) {
                    context.nextToken();
                    diagnosticsBuilder.logTail((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
            } else if (!(token != JsonToken.END_ARRAY && token != JsonToken.END_OBJECT || context.getLastParsedParentElement() != null && !context.getLastParsedParentElement().equals(currentParentElement) || context.getCurrentDepth() > originalDepth)) break;
            token = context.nextToken();
        }
        return (Diagnostics)diagnosticsBuilder.build();
    }

    public static DiagnosticsUnmarshaller getInstance() {
        return INSTANCE;
    }
}

